/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.oneone;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

public abstract class OneToOneEncoder
implements ChannelDownstreamHandler {
    protected OneToOneEncoder() {
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e2 = (MessageEvent)evt;
        if (!this.doEncode(ctx, e2)) {
            ctx.sendDownstream(e2);
        }
    }

    protected boolean doEncode(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        Object encodedMessage;
        Object originalMessage = e2.getMessage();
        if (originalMessage == (encodedMessage = this.encode(ctx, e2.getChannel(), originalMessage))) {
            return false;
        }
        if (encodedMessage != null) {
            Channels.write(ctx, e2.getFuture(), encodedMessage, e2.getRemoteAddress());
        }
        return true;
    }

    protected abstract Object encode(ChannelHandlerContext var1, Channel var2, Object var3) throws Exception;
}

