/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.spdy.SpdyHttpHeaders;
import org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;

public class SpdyHttpResponseStreamIdHandler
extends SimpleChannelHandler {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new ConcurrentLinkedQueue<Integer>();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        if (e2.getMessage() instanceof HttpMessage) {
            boolean contains = ((HttpMessage)e2.getMessage()).headers().contains("X-SPDY-Stream-ID");
            if (!contains) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(SpdyHttpHeaders.getStreamId((HttpMessage)e2.getMessage()));
            }
        } else if (e2.getMessage() instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)e2.getMessage()).getStreamId());
        }
        super.messageReceived(ctx, e2);
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        if (e2.getMessage() instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)e2.getMessage();
            Integer id = this.ids.poll();
            if (id != null && id.intValue() != NO_ID.intValue() && !response.headers().contains("X-SPDY-Stream-ID")) {
                SpdyHttpHeaders.setStreamId(response, id);
            }
        }
        super.writeRequested(ctx, e2);
    }
}

