/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.execution;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.execution.ChannelDownstreamEventRunnable;
import org.jboss.netty.handler.execution.ChannelUpstreamEventRunnable;
import org.jboss.netty.util.ExternalResourceReleasable;

@ChannelHandler.Sharable
public class ExecutionHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler,
ExternalResourceReleasable {
    private final Executor executor;
    private final boolean handleDownstream;
    private final boolean handleUpstream;

    public ExecutionHandler(Executor executor) {
        this(executor, false, true);
    }

    public ExecutionHandler(Executor executor, boolean handleDownstream, boolean handleUpstream) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (!handleDownstream && !handleUpstream) {
            throw new IllegalArgumentException("You must handle at least handle one event type");
        }
        this.executor = executor;
        this.handleDownstream = handleDownstream;
        this.handleUpstream = handleUpstream;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void releaseExternalResources() {
        Executor executor = this.getExecutor();
        if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).shutdown();
        }
        if (executor instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)executor)).releaseExternalResources();
        }
    }

    public void handleUpstream(ChannelHandlerContext context, ChannelEvent e2) throws Exception {
        if (this.handleUpstream) {
            this.executor.execute(new ChannelUpstreamEventRunnable(context, e2, this.executor));
        } else {
            context.sendUpstream(e2);
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        if (!this.handleReadSuspend(ctx, e2)) {
            if (this.handleDownstream) {
                this.executor.execute(new ChannelDownstreamEventRunnable(ctx, e2, this.executor));
            } else {
                ctx.sendDownstream(e2);
            }
        }
    }

    protected boolean handleReadSuspend(ChannelHandlerContext ctx, ChannelEvent e2) {
        ChannelStateEvent cse;
        if (e2 instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e2).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e2.getFuture().setSuccess();
                return true;
            }
        }
        return false;
    }
}

