/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.logging;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogLevel;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class LoggingHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogLevel DEFAULT_LEVEL;
    private static final String NEWLINE;
    private static final String[] BYTE2HEX;
    private static final String[] HEXPADDING;
    private static final String[] BYTEPADDING;
    private static final char[] BYTE2CHAR;
    private final InternalLogger logger;
    private final InternalLogLevel level;
    private final boolean hexDump;

    public LoggingHandler() {
        this(true);
    }

    public LoggingHandler(InternalLogLevel level) {
        this(level, true);
    }

    public LoggingHandler(boolean hexDump) {
        this(DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(InternalLogLevel level, boolean hexDump) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(this.getClass());
        this.level = level;
        this.hexDump = hexDump;
    }

    public LoggingHandler(Class<?> clazz) {
        this(clazz, true);
    }

    public LoggingHandler(Class<?> clazz, boolean hexDump) {
        this(clazz, DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(Class<?> clazz, InternalLogLevel level) {
        this(clazz, level, true);
    }

    public LoggingHandler(Class<?> clazz, InternalLogLevel level, boolean hexDump) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(clazz);
        this.level = level;
        this.hexDump = hexDump;
    }

    public LoggingHandler(String name) {
        this(name, true);
    }

    public LoggingHandler(String name, boolean hexDump) {
        this(name, DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(String name, InternalLogLevel level, boolean hexDump) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(name);
        this.level = level;
        this.hexDump = hexDump;
    }

    public InternalLogger getLogger() {
        return this.logger;
    }

    public InternalLogLevel getLevel() {
        return this.level;
    }

    public void log(ChannelEvent e2) {
        if (this.getLogger().isEnabled(this.level)) {
            MessageEvent me;
            String msg = e2.toString();
            if (this.hexDump && e2 instanceof MessageEvent && (me = (MessageEvent)e2).getMessage() instanceof ChannelBuffer) {
                msg = msg + LoggingHandler.formatBuffer((ChannelBuffer)me.getMessage());
            }
            if (e2 instanceof ExceptionEvent) {
                this.getLogger().log(this.level, msg, ((ExceptionEvent)e2).getCause());
            } else {
                this.getLogger().log(this.level, msg);
            }
        }
    }

    private static String formatBuffer(ChannelBuffer buf) {
        int i2;
        int length = buf.readableBytes();
        int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
        StringBuilder dump = new StringBuilder(rows * 80);
        dump.append(NEWLINE + "         +-------------------------------------------------+" + NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + NEWLINE + "+--------+-------------------------------------------------+----------------+");
        int startIndex = buf.readerIndex();
        int endIndex = buf.writerIndex();
        for (i2 = startIndex; i2 < endIndex; ++i2) {
            int relIdx = i2 - startIndex;
            int relIdxMod16 = relIdx & 0xF;
            if (relIdxMod16 == 0) {
                dump.append(NEWLINE);
                dump.append(Long.toHexString((long)relIdx & 0xFFFFFFFFL | 0x100000000L));
                dump.setCharAt(dump.length() - 9, '|');
                dump.append('|');
            }
            dump.append(BYTE2HEX[buf.getUnsignedByte(i2)]);
            if (relIdxMod16 != 15) continue;
            dump.append(" |");
            for (int j2 = i2 - 15; j2 <= i2; ++j2) {
                dump.append(BYTE2CHAR[buf.getUnsignedByte(j2)]);
            }
            dump.append('|');
        }
        if ((i2 - startIndex & 0xF) != 0) {
            int remainder = length & 0xF;
            dump.append(HEXPADDING[remainder]);
            dump.append(" |");
            for (int j3 = i2 - remainder; j3 < i2; ++j3) {
                dump.append(BYTE2CHAR[buf.getUnsignedByte(j3)]);
            }
            dump.append(BYTEPADDING[remainder]);
            dump.append('|');
        }
        dump.append(NEWLINE + "+--------+-------------------------------------------------+----------------+");
        return dump.toString();
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        this.log(e2);
        ctx.sendUpstream(e2);
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        this.log(e2);
        ctx.sendDownstream(e2);
    }

    static {
        int j2;
        StringBuilder buf;
        StringBuilder buf2;
        int i2;
        DEFAULT_LEVEL = InternalLogLevel.DEBUG;
        NEWLINE = String.format("%n", new Object[0]);
        BYTE2HEX = new String[256];
        HEXPADDING = new String[16];
        BYTEPADDING = new String[16];
        BYTE2CHAR = new char[256];
        for (i2 = 0; i2 < 10; ++i2) {
            buf2 = new StringBuilder(3);
            buf2.append(" 0");
            buf2.append(i2);
            LoggingHandler.BYTE2HEX[i2] = buf2.toString();
        }
        while (i2 < 16) {
            buf2 = new StringBuilder(3);
            buf2.append(" 0");
            buf2.append((char)(97 + i2 - 10));
            LoggingHandler.BYTE2HEX[i2] = buf2.toString();
            ++i2;
        }
        while (i2 < BYTE2HEX.length) {
            buf2 = new StringBuilder(3);
            buf2.append(' ');
            buf2.append(Integer.toHexString(i2));
            LoggingHandler.BYTE2HEX[i2] = buf2.toString();
            ++i2;
        }
        for (i2 = 0; i2 < HEXPADDING.length; ++i2) {
            int padding = HEXPADDING.length - i2;
            buf = new StringBuilder(padding * 3);
            for (j2 = 0; j2 < padding; ++j2) {
                buf.append("   ");
            }
            LoggingHandler.HEXPADDING[i2] = buf.toString();
        }
        for (i2 = 0; i2 < BYTEPADDING.length; ++i2) {
            int padding = BYTEPADDING.length - i2;
            buf = new StringBuilder(padding);
            for (j2 = 0; j2 < padding; ++j2) {
                buf.append(' ');
            }
            LoggingHandler.BYTEPADDING[i2] = buf.toString();
        }
        for (i2 = 0; i2 < BYTE2CHAR.length; ++i2) {
            LoggingHandler.BYTE2CHAR[i2] = i2 <= 31 || i2 >= 127 ? 46 : (char)i2;
        }
    }
}

