/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.queue;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedWriteHandler
extends SimpleChannelHandler
implements LifeCycleAwareChannelHandler {
    private final Queue<MessageEvent> queue;
    private final boolean consolidateOnFlush;
    private volatile ChannelHandlerContext ctx;
    private final AtomicBoolean flush = new AtomicBoolean(false);

    public BufferedWriteHandler() {
        this(false);
    }

    public BufferedWriteHandler(Queue<MessageEvent> queue) {
        this(queue, false);
    }

    public BufferedWriteHandler(boolean consolidateOnFlush) {
        this(new ConcurrentLinkedQueue<MessageEvent>(), consolidateOnFlush);
    }

    public BufferedWriteHandler(Queue<MessageEvent> queue, boolean consolidateOnFlush) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        this.queue = queue;
        this.consolidateOnFlush = consolidateOnFlush;
    }

    public boolean isConsolidateOnFlush() {
        return this.consolidateOnFlush;
    }

    protected Queue<MessageEvent> getQueue() {
        return this.queue;
    }

    public void flush() {
        this.flush(this.consolidateOnFlush);
    }

    public void flush(boolean consolidateOnFlush) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        Channel channel = ctx.getChannel();
        boolean acquired = this.flush.compareAndSet(false, true);
        if (acquired) {
            Queue<MessageEvent> queue = this.getQueue();
            if (consolidateOnFlush) {
                MessageEvent e2;
                if (queue.isEmpty()) {
                    this.flush.set(false);
                    return;
                }
                List<MessageEvent> pendingWrites = new ArrayList<MessageEvent>();
                while ((e2 = queue.poll()) != null) {
                    if (!(e2.getMessage() instanceof ChannelBuffer)) {
                        if ((pendingWrites = this.consolidatedWrite(pendingWrites)) == null) {
                            pendingWrites = new ArrayList();
                        }
                        ctx.sendDownstream(e2);
                        continue;
                    }
                    pendingWrites.add(e2);
                }
                this.consolidatedWrite(pendingWrites);
            } else {
                MessageEvent e3;
                while ((e3 = queue.poll()) != null) {
                    ctx.sendDownstream(e3);
                }
            }
            this.flush.set(false);
        }
        if (acquired && (!channel.isConnected() || channel.isWritable() && !this.queue.isEmpty())) {
            this.flush(consolidateOnFlush);
        }
    }

    private List<MessageEvent> consolidatedWrite(final List<MessageEvent> pendingWrites) {
        int size = pendingWrites.size();
        if (size == 1) {
            this.ctx.sendDownstream(pendingWrites.remove(0));
            return pendingWrites;
        }
        if (size == 0) {
            return pendingWrites;
        }
        ChannelBuffer[] data = new ChannelBuffer[size];
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = (ChannelBuffer)pendingWrites.get(i2).getMessage();
        }
        ChannelBuffer composite = ChannelBuffers.wrappedBuffer(data);
        ChannelFuture future = Channels.future(this.ctx.getChannel());
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    for (MessageEvent e2 : pendingWrites) {
                        e2.getFuture().setSuccess();
                    }
                } else {
                    Throwable cause = future.getCause();
                    for (MessageEvent e3 : pendingWrites) {
                        e3.getFuture().setFailure(cause);
                    }
                }
            }
        });
        Channels.write(this.ctx, future, composite);
        return null;
    }

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        if (this.ctx == null) {
            this.ctx = ctx;
        } else assert (this.ctx == ctx);
        this.getQueue().add(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectRequested(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        try {
            this.flush(this.consolidateOnFlush);
            Object var4_3 = null;
            ctx.sendDownstream(e2);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.sendDownstream(e2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        try {
            this.flush(this.consolidateOnFlush);
            Object var4_3 = null;
            ctx.sendDownstream(e2);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.sendDownstream(e2);
            throw throwable;
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        MessageEvent ev;
        ClosedChannelException cause = null;
        while ((ev = this.queue.poll()) != null) {
            if (cause == null) {
                cause = new ClosedChannelException();
            }
            ev.getFuture().setFailure(cause);
        }
        if (cause != null) {
            Channels.fireExceptionCaught(ctx.getChannel(), (Throwable)cause);
        }
        super.channelClosed(ctx, e2);
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        this.flush(this.consolidateOnFlush);
    }

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        MessageEvent ev;
        IOException cause = null;
        while ((ev = this.queue.poll()) != null) {
            if (cause == null) {
                cause = new IOException("Unable to flush message");
            }
            ev.getFuture().setFailure(cause);
        }
        if (cause != null) {
            Channels.fireExceptionCaughtLater(ctx.getChannel(), cause);
        }
    }
}

