/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.ssl;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;
import org.apache.tomcat.jni.Buffer;
import org.apache.tomcat.jni.SSL;
import org.jboss.netty.handler.ssl.OpenSsl;
import org.jboss.netty.handler.ssl.SslBufferPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.EmptyArrays;

public final class OpenSslEngine
extends SSLEngine {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslEngine.class);
    private static final Certificate[] EMPTY_CERTIFICATES = new Certificate[0];
    private static final X509Certificate[] EMPTY_X509_CERTIFICATES = new X509Certificate[0];
    private static final SSLException ENGINE_CLOSED = new SSLException("engine closed");
    private static final SSLException RENEGOTIATION_UNSUPPORTED = new SSLException("renegotiation unsupported");
    private static final SSLException ENCRYPTED_PACKET_OVERSIZED = new SSLException("encrypted packet oversized");
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    private static final AtomicIntegerFieldUpdater<OpenSslEngine> DESTROYED_UPDATER;
    private long ssl;
    private long networkBIO;
    private int accepted;
    private boolean handshakeFinished;
    private boolean receivedShutdown;
    private volatile int destroyed;
    private String cipher;
    private volatile String applicationProtocol;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private int lastPrimingReadResult;
    private final SslBufferPool bufPool;
    private final String fallbackApplicationProtocol;
    private SSLSession session;

    public OpenSslEngine(long sslCtx, SslBufferPool bufPool, String fallbackApplicationProtocol) {
        OpenSsl.ensureAvailability();
        if (sslCtx == 0L) {
            throw new NullPointerException("sslContext");
        }
        if (bufPool == null) {
            throw new NullPointerException("bufPool");
        }
        this.bufPool = bufPool;
        this.ssl = SSL.newSSL((long)sslCtx, (boolean)true);
        this.networkBIO = SSL.makeNetworkBIO((long)this.ssl);
        this.fallbackApplicationProtocol = fallbackApplicationProtocol;
    }

    public synchronized void shutdown() {
        if (DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            SSL.freeSSL((long)this.ssl);
            SSL.freeBIO((long)this.networkBIO);
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.engineClosed = true;
            this.isOutboundDone = true;
            this.isInboundDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer src) {
        int sslWrote;
        int pos = src.position();
        int limit = src.limit();
        int len = Math.min(limit - pos, 16384);
        if (src.isDirect()) {
            long addr = Buffer.address((ByteBuffer)src) + (long)pos;
            sslWrote = SSL.writeToSSL((long)this.ssl, (long)addr, (int)len);
            if (sslWrote > 0) {
                src.position(pos + sslWrote);
                return sslWrote;
            }
        } else {
            ByteBuffer buf;
            block8: {
                buf = this.bufPool.acquireBuffer();
                try {
                    assert (buf.isDirect());
                    assert (len <= buf.capacity()) : "buffer pool write overflow";
                    long addr = Buffer.address((ByteBuffer)buf);
                    src.limit(pos + len);
                    buf.put(src);
                    src.limit(limit);
                    sslWrote = SSL.writeToSSL((long)this.ssl, (long)addr, (int)len);
                    if (sslWrote <= 0) break block8;
                    src.position(pos + sslWrote);
                    int n2 = sslWrote;
                    Object var11_10 = null;
                    this.bufPool.releaseBuffer(buf);
                    return n2;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    this.bufPool.releaseBuffer(buf);
                    throw throwable;
                }
            }
            src.position(pos);
            Object var11_11 = null;
            this.bufPool.releaseBuffer(buf);
        }
        throw new IllegalStateException("SSL.writeToSSL() returned a non-positive value: " + sslWrote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeEncryptedData(ByteBuffer src) {
        int pos = src.position();
        int len = src.remaining();
        if (src.isDirect()) {
            long addr = Buffer.address((ByteBuffer)src) + (long)pos;
            int netWrote = SSL.writeToBIO((long)this.networkBIO, (long)addr, (int)len);
            if (netWrote >= 0) {
                src.position(pos + netWrote);
                this.lastPrimingReadResult = SSL.readFromSSL((long)this.ssl, (long)addr, (int)0);
                return netWrote;
            }
        } else {
            ByteBuffer buf;
            block8: {
                buf = this.bufPool.acquireBuffer();
                try {
                    assert (buf.isDirect());
                    assert (len <= buf.capacity());
                    long addr = Buffer.address((ByteBuffer)buf);
                    buf.put(src);
                    int netWrote = SSL.writeToBIO((long)this.networkBIO, (long)addr, (int)len);
                    if (netWrote < 0) break block8;
                    src.position(pos + netWrote);
                    this.lastPrimingReadResult = SSL.readFromSSL((long)this.ssl, (long)addr, (int)0);
                    int n2 = netWrote;
                    Object var10_10 = null;
                    this.bufPool.releaseBuffer(buf);
                    return n2;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    this.bufPool.releaseBuffer(buf);
                    throw throwable;
                }
            }
            src.position(pos);
            Object var10_11 = null;
            this.bufPool.releaseBuffer(buf);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer dst) {
        if (dst.isDirect()) {
            int len;
            int pos = dst.position();
            long addr = Buffer.address((ByteBuffer)dst) + (long)pos;
            int sslRead = SSL.readFromSSL((long)this.ssl, (long)addr, (int)(len = dst.limit() - pos));
            if (sslRead > 0) {
                dst.position(pos + sslRead);
                return sslRead;
            }
        } else {
            ByteBuffer buf;
            block7: {
                buf = this.bufPool.acquireBuffer();
                try {
                    assert (buf.isDirect());
                    long addr = Buffer.address((ByteBuffer)buf);
                    int len = Math.min(buf.capacity(), dst.remaining());
                    buf.limit(len);
                    int sslRead = SSL.readFromSSL((long)this.ssl, (long)addr, (int)len);
                    if (sslRead <= 0) break block7;
                    buf.limit(sslRead);
                    dst.put(buf);
                    int n2 = sslRead;
                    Object var9_11 = null;
                    this.bufPool.releaseBuffer(buf);
                    return n2;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    this.bufPool.releaseBuffer(buf);
                    throw throwable;
                }
            }
            Object var9_12 = null;
            this.bufPool.releaseBuffer(buf);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readEncryptedData(ByteBuffer dst, int pending) {
        if (dst.isDirect() && dst.remaining() >= pending) {
            int pos = dst.position();
            long addr = Buffer.address((ByteBuffer)dst) + (long)pos;
            int bioRead = SSL.readFromBIO((long)this.networkBIO, (long)addr, (int)pending);
            if (bioRead > 0) {
                dst.position(pos + bioRead);
                return bioRead;
            }
        } else {
            ByteBuffer buf;
            block8: {
                buf = this.bufPool.acquireBuffer();
                try {
                    assert (buf.isDirect());
                    long addr = Buffer.address((ByteBuffer)buf);
                    assert (buf.capacity() >= pending) : "network BIO read overflow (pending: " + pending + ", capacity: " + buf.capacity() + ')';
                    int bioRead = SSL.readFromBIO((long)this.networkBIO, (long)addr, (int)pending);
                    if (bioRead <= 0) break block8;
                    buf.limit(bioRead);
                    dst.put(buf);
                    int n2 = bioRead;
                    Object var9_10 = null;
                    this.bufPool.releaseBuffer(buf);
                    return n2;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    this.bufPool.releaseBuffer(buf);
                    throw throwable;
                }
            }
            Object var9_11 = null;
            this.bufPool.releaseBuffer(buf);
        }
        return 0;
    }

    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        if (this.destroyed != 0) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (srcs == null) {
            throw new NullPointerException("srcs");
        }
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        if (offset >= srcs.length || offset + length > srcs.length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + " (expected: offset <= offset + length <= srcs.length (" + srcs.length + "))");
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.accepted == 0) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        }
        int bytesProduced = 0;
        int pendingNet = SSL.pendingWrittenBytesInBIO((long)this.networkBIO);
        if (pendingNet > 0) {
            int capacity = dst.remaining();
            if (capacity < pendingNet) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, bytesProduced);
            }
            try {
                bytesProduced += this.readEncryptedData(dst, pendingNet);
            }
            catch (Exception e2) {
                throw new SSLException(e2);
            }
            if (this.isOutboundDone) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), 0, bytesProduced);
        }
        int bytesConsumed = 0;
        for (int i2 = offset; i2 < length; ++i2) {
            ByteBuffer src = srcs[i2];
            while (src.hasRemaining()) {
                try {
                    bytesConsumed += this.writePlaintextData(src);
                }
                catch (Exception e3) {
                    throw new SSLException(e3);
                }
                pendingNet = SSL.pendingWrittenBytesInBIO((long)this.networkBIO);
                if (pendingNet <= 0) continue;
                int capacity = dst.remaining();
                if (capacity < pendingNet) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), bytesConsumed, bytesProduced);
                }
                try {
                }
                catch (Exception e4) {
                    throw new SSLException(e4);
                }
                return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced += this.readEncryptedData(dst, pendingNet));
            }
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced);
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        int pendingApp;
        if (this.destroyed != 0) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (src == null) {
            throw new NullPointerException("src");
        }
        if (dsts == null) {
            throw new NullPointerException("dsts");
        }
        if (offset >= dsts.length || offset + length > dsts.length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + " (expected: offset <= offset + length <= dsts.length (" + dsts.length + "))");
        }
        int capacity = 0;
        int endOffset = offset + length;
        for (int i2 = offset; i2 < endOffset; ++i2) {
            ByteBuffer dst = dsts[i2];
            if (dst == null) {
                throw new IllegalArgumentException();
            }
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            capacity += dst.remaining();
        }
        if (this.accepted == 0) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        }
        if (src.remaining() > 18713) {
            this.isInboundDone = true;
            this.isOutboundDone = true;
            this.engineClosed = true;
            this.shutdown();
            throw ENCRYPTED_PACKET_OVERSIZED;
        }
        int bytesConsumed = 0;
        this.lastPrimingReadResult = 0;
        try {
            bytesConsumed += this.writeEncryptedData(src);
        }
        catch (Exception e2) {
            throw new SSLException(e2);
        }
        String error = SSL.getLastError();
        if (error != null && !error.startsWith("error:00000000:")) {
            if (logger.isInfoEnabled()) {
                logger.info("SSL_read failed: primingReadResult: " + this.lastPrimingReadResult + "; OpenSSL error: '" + error + '\'');
            }
            this.shutdown();
            throw new SSLException(error);
        }
        int n2 = pendingApp = SSL.isInInit((long)this.ssl) == 0 ? SSL.pendingReadableBytesInSSL((long)this.ssl) : 0;
        if (capacity < pendingApp) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), bytesConsumed, 0);
        }
        int bytesProduced = 0;
        int idx = offset;
        while (idx < endOffset) {
            int bytesRead;
            ByteBuffer dst = dsts[idx];
            if (!dst.hasRemaining()) {
                ++idx;
                continue;
            }
            if (pendingApp <= 0) break;
            try {
                bytesRead = this.readPlaintextData(dst);
            }
            catch (Exception e3) {
                throw new SSLException(e3);
            }
            if (bytesRead == 0) break;
            bytesProduced += bytesRead;
            pendingApp -= bytesRead;
            if (dst.hasRemaining()) continue;
            ++idx;
        }
        if (!this.receivedShutdown && (SSL.getShutdown((long)this.ssl) & 2) == 2) {
            this.receivedShutdown = true;
            this.closeOutbound();
            this.closeInbound();
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced);
    }

    public Runnable getDelegatedTask() {
        return null;
    }

    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        if (this.accepted != 0) {
            if (!this.receivedShutdown) {
                this.shutdown();
                throw new SSLException("close_notify has not been received");
            }
        } else {
            this.shutdown();
        }
    }

    public synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    public synchronized void closeOutbound() {
        if (this.isOutboundDone) {
            return;
        }
        this.isOutboundDone = true;
        this.engineClosed = true;
        if (this.accepted != 0 && this.destroyed == 0) {
            int mode = SSL.getShutdown((long)this.ssl);
            if ((mode & 1) != 1) {
                SSL.shutdownSSL((long)this.ssl);
            }
        } else {
            this.shutdown();
        }
    }

    public synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    public String[] getSupportedCipherSuites() {
        return EmptyArrays.EMPTY_STRINGS;
    }

    public String[] getEnabledCipherSuites() {
        return EmptyArrays.EMPTY_STRINGS;
    }

    public void setEnabledCipherSuites(String[] strings) {
        throw new UnsupportedOperationException();
    }

    public String[] getSupportedProtocols() {
        return EmptyArrays.EMPTY_STRINGS;
    }

    public String[] getEnabledProtocols() {
        return EmptyArrays.EMPTY_STRINGS;
    }

    public void setEnabledProtocols(String[] strings) {
        throw new UnsupportedOperationException();
    }

    public SSLSession getSession() {
        SSLSession session = this.session;
        if (session == null) {
            this.session = session = new SSLSession(){

                public byte[] getId() {
                    return String.valueOf(OpenSslEngine.this.ssl).getBytes();
                }

                public SSLSessionContext getSessionContext() {
                    return null;
                }

                public long getCreationTime() {
                    return 0L;
                }

                public long getLastAccessedTime() {
                    return 0L;
                }

                public void invalidate() {
                }

                public boolean isValid() {
                    return false;
                }

                public void putValue(String s2, Object o2) {
                }

                public Object getValue(String s2) {
                    return null;
                }

                public void removeValue(String s2) {
                }

                public String[] getValueNames() {
                    return EmptyArrays.EMPTY_STRINGS;
                }

                public Certificate[] getPeerCertificates() {
                    return EMPTY_CERTIFICATES;
                }

                public Certificate[] getLocalCertificates() {
                    return EMPTY_CERTIFICATES;
                }

                public X509Certificate[] getPeerCertificateChain() {
                    return EMPTY_X509_CERTIFICATES;
                }

                public Principal getPeerPrincipal() {
                    return null;
                }

                public Principal getLocalPrincipal() {
                    return null;
                }

                public String getCipherSuite() {
                    return OpenSslEngine.this.cipher;
                }

                public String getProtocol() {
                    String applicationProtocol = OpenSslEngine.this.applicationProtocol;
                    if (applicationProtocol == null) {
                        return "unknown";
                    }
                    return "unknown:" + applicationProtocol;
                }

                public String getPeerHost() {
                    return null;
                }

                public int getPeerPort() {
                    return 0;
                }

                public int getPacketBufferSize() {
                    return 18713;
                }

                public int getApplicationBufferSize() {
                    return 16384;
                }
            };
        }
        return session;
    }

    public synchronized void beginHandshake() throws SSLException {
        if (this.engineClosed) {
            throw ENGINE_CLOSED;
        }
        switch (this.accepted) {
            case 0: {
                SSL.doHandshake((long)this.ssl);
                this.accepted = 2;
                break;
            }
            case 1: {
                this.accepted = 2;
                break;
            }
            case 2: {
                throw RENEGOTIATION_UNSUPPORTED;
            }
            default: {
                throw new Error();
            }
        }
    }

    private synchronized void beginHandshakeImplicitly() throws SSLException {
        if (this.engineClosed) {
            throw ENGINE_CLOSED;
        }
        if (this.accepted == 0) {
            SSL.doHandshake((long)this.ssl);
            this.accepted = 1;
        }
    }

    private SSLEngineResult.Status getEngineStatus() {
        return this.engineClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.accepted == 0 || this.destroyed != 0) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        if (!this.handshakeFinished) {
            if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (SSL.isInInit((long)this.ssl) == 0) {
                this.handshakeFinished = true;
                this.cipher = SSL.getCipherForSSL((long)this.ssl);
                String applicationProtocol = SSL.getNextProtoNegotiated((long)this.ssl);
                if (applicationProtocol == null) {
                    applicationProtocol = this.fallbackApplicationProtocol;
                }
                this.applicationProtocol = applicationProtocol != null ? applicationProtocol.replace(':', '_') : null;
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.engineClosed) {
            if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public void setUseClientMode(boolean clientMode) {
        if (clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean getUseClientMode() {
        return false;
    }

    public void setNeedClientAuth(boolean b2) {
        if (b2) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean getNeedClientAuth() {
        return false;
    }

    public void setWantClientAuth(boolean b2) {
        if (b2) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean getWantClientAuth() {
        return false;
    }

    public void setEnableSessionCreation(boolean b2) {
        if (b2) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean getEnableSessionCreation() {
        return false;
    }

    static {
        ENGINE_CLOSED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        RENEGOTIATION_UNSUPPORTED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        ENCRYPTED_PACKET_OVERSIZED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        DESTROYED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OpenSslEngine.class, "destroyed");
    }
}

