/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.traffic;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.traffic.AbstractTrafficShapingHandler;
import org.jboss.netty.handler.traffic.TrafficCounter;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.jboss.netty.util.internal.ConcurrentHashMap;

@ChannelHandler.Sharable
public class GlobalTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ConcurrentMap<Integer, PerChannel> channelQueues = new ConcurrentHashMap<Integer, PerChannel>();
    private final AtomicLong queuesSize = new AtomicLong();
    long maxGlobalWriteSize = 0x19000000L;

    void createGlobalTrafficCounter() {
        if (this.timer != null) {
            TrafficCounter tc = new TrafficCounter(this, this.timer, "GlobalTC", this.checkInterval);
            this.setTrafficCounter(tc);
            tc.start();
        }
    }

    public GlobalTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval) {
        super(timer, writeLimit, readLimit, checkInterval);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(timer, writeLimit, readLimit, checkInterval, maxTime);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(Timer timer, long writeLimit, long readLimit) {
        super(timer, writeLimit, readLimit);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(Timer timer, long checkInterval) {
        super(timer, checkInterval);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(Timer timer) {
        super(timer);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, maxTime);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit) {
        super(objectSizeEstimator, timer, writeLimit, readLimit);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        super(objectSizeEstimator, timer, checkInterval);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        super(objectSizeEstimator, timer);
        this.createGlobalTrafficCounter();
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long maxGlobalWriteSize) {
        this.maxGlobalWriteSize = maxGlobalWriteSize;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    private synchronized PerChannel getOrSetPerChannel(ChannelHandlerContext ctx) {
        Integer key = ctx.getChannel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel == null) {
            perChannel = new PerChannel();
            perChannel.messagesQueue = new LinkedList<ToSend>();
            perChannel.ctx = ctx;
            perChannel.queueSize = 0L;
            perChannel.lastWriteTimestamp = perChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put(key, perChannel);
        }
        return perChannel;
    }

    long checkWaitReadTime(ChannelHandlerContext ctx, long wait, long now) {
        Integer key = ctx.getChannel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel != null && wait > this.maxTime && now + wait - perChannel.lastReadTimestamp > this.maxTime) {
            wait = this.maxTime;
        }
        return wait;
    }

    void informReadOperation(ChannelHandlerContext ctx, long now) {
        Integer key = ctx.getChannel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel != null) {
            perChannel.lastReadTimestamp = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitWrite(final ChannelHandlerContext ctx, MessageEvent evt, long size, long writedelay, long now) throws Exception {
        ToSend newToSend;
        long delay;
        PerChannel perChannel = this.getOrSetPerChannel(ctx);
        boolean globalSizeExceeded = false;
        Channel channel = ctx.getChannel();
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            if (writedelay == 0L && perChannel.messagesQueue.isEmpty()) {
                if (!channel.isConnected()) {
                    return;
                }
                if (this.trafficCounter != null) {
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                }
                ctx.sendDownstream(evt);
                perChannel.lastWriteTimestamp = now;
                return;
            }
            delay = writedelay;
            if (delay > this.maxTime && now + delay - perChannel.lastWriteTimestamp > this.maxTime) {
                delay = this.maxTime;
            }
            if (this.timer == null) {
                Thread.sleep(delay);
                if (!ctx.getChannel().isConnected()) {
                    return;
                }
                if (this.trafficCounter != null) {
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                }
                ctx.sendDownstream(evt);
                perChannel.lastWriteTimestamp = now;
                return;
            }
            if (!ctx.getChannel().isConnected()) {
                return;
            }
            newToSend = new ToSend(delay + now, evt, size);
            perChannel.messagesQueue.add(newToSend);
            perChannel.queueSize += size;
            this.queuesSize.addAndGet(size);
            this.checkWriteSuspend(ctx, delay, perChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                globalSizeExceeded = true;
            }
        }
        if (globalSizeExceeded) {
            this.setWritable(ctx, false);
        }
        final long futureNow = newToSend.relativeTimeAction;
        final PerChannel forSchedule = perChannel;
        this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                GlobalTrafficShapingHandler.this.sendAllValid(ctx, forSchedule, futureNow);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext ctx, PerChannel perChannel, long now) throws Exception {
        Channel channel = ctx.getChannel();
        if (!channel.isConnected()) {
            return;
        }
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            while (!perChannel.messagesQueue.isEmpty()) {
                ToSend newToSend = perChannel.messagesQueue.remove(0);
                if (newToSend.relativeTimeAction <= now) {
                    if (!channel.isConnected()) break;
                    long size = newToSend.size;
                    if (this.trafficCounter != null) {
                        this.trafficCounter.bytesRealWriteFlowControl(size);
                    }
                    perChannel.queueSize -= size;
                    this.queuesSize.addAndGet(-size);
                    ctx.sendDownstream(newToSend.toSend);
                    perChannel.lastWriteTimestamp = now;
                    continue;
                }
                perChannel.messagesQueue.add(0, newToSend);
                break;
            }
            if (perChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(ctx);
            }
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        this.getOrSetPerChannel(ctx);
        super.channelConnected(ctx, e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        Integer key = ctx.getChannel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.remove(key);
        if (perChannel != null) {
            PerChannel perChannel2 = perChannel;
            synchronized (perChannel2) {
                this.queuesSize.addAndGet(-perChannel.queueSize);
                perChannel.messagesQueue.clear();
            }
        }
        super.channelClosed(ctx, e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExternalResources() {
        for (PerChannel perChannel : this.channelQueues.values()) {
            if (perChannel == null || perChannel.ctx == null || !perChannel.ctx.getChannel().isConnected()) continue;
            Channel channel = perChannel.ctx.getChannel();
            PerChannel perChannel2 = perChannel;
            synchronized (perChannel2) {
                for (ToSend toSend : perChannel.messagesQueue) {
                    if (!channel.isConnected()) break;
                    perChannel.ctx.sendDownstream(toSend.toSend);
                }
                perChannel.messagesQueue.clear();
            }
        }
        this.channelQueues.clear();
        this.queuesSize.set(0L);
        super.releaseExternalResources();
    }

    private static final class ToSend {
        final long relativeTimeAction;
        final MessageEvent toSend;
        final long size;

        private ToSend(long delay, MessageEvent toSend, long size) {
            this.relativeTimeAction = delay;
            this.toSend = toSend;
            this.size = size;
        }
    }

    private static final class PerChannel {
        List<ToSend> messagesQueue;
        ChannelHandlerContext ctx;
        long queueSize;
        long lastWriteTimestamp;
        long lastReadTimestamp;

        private PerChannel() {
        }
    }
}

