/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.util.EstimatableObjectWrapper;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.internal.ConcurrentIdentityWeakKeyHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectSizeEstimator
implements ObjectSizeEstimator {
    private final ConcurrentMap<Class<?>, Integer> class2size = new ConcurrentIdentityWeakKeyHashMap();

    public DefaultObjectSizeEstimator() {
        this.class2size.put(Boolean.TYPE, 4);
        this.class2size.put(Byte.TYPE, 1);
        this.class2size.put(Character.TYPE, 2);
        this.class2size.put(Integer.TYPE, 4);
        this.class2size.put(Short.TYPE, 2);
        this.class2size.put(Long.TYPE, 8);
        this.class2size.put(Float.TYPE, 4);
        this.class2size.put(Double.TYPE, 8);
        this.class2size.put(Void.TYPE, 0);
    }

    @Override
    public int estimateSize(Object o2) {
        if (o2 == null) {
            return 8;
        }
        int answer = 8 + this.estimateSize(o2.getClass(), null);
        if (o2 instanceof EstimatableObjectWrapper) {
            answer += this.estimateSize(((EstimatableObjectWrapper)o2).unwrap());
        } else if (o2 instanceof MessageEvent) {
            answer += this.estimateSize(((MessageEvent)o2).getMessage());
        } else if (o2 instanceof ChannelBuffer) {
            answer += ((ChannelBuffer)o2).capacity();
        } else if (o2 instanceof byte[]) {
            answer += ((byte[])o2).length;
        } else if (o2 instanceof ByteBuffer) {
            answer += ((ByteBuffer)o2).remaining();
        } else if (o2 instanceof CharSequence) {
            answer += ((CharSequence)o2).length() << 1;
        } else if (o2 instanceof Iterable) {
            for (Object m2 : (Iterable)o2) {
                answer += this.estimateSize(m2);
            }
        }
        return DefaultObjectSizeEstimator.align(answer);
    }

    private int estimateSize(Class<?> clazz, Set<Class<?>> visitedClasses) {
        Integer objectSize = (Integer)this.class2size.get(clazz);
        if (objectSize != null) {
            return objectSize;
        }
        if (visitedClasses != null) {
            if (visitedClasses.contains(clazz)) {
                return 0;
            }
        } else {
            visitedClasses = new HashSet();
        }
        visitedClasses.add(clazz);
        int answer = 8;
        for (Class<?> c2 = clazz; c2 != null; c2 = c2.getSuperclass()) {
            Field[] fields;
            for (Field f2 : fields = c2.getDeclaredFields()) {
                if ((f2.getModifiers() & 8) != 0) continue;
                answer += this.estimateSize(f2.getType(), visitedClasses);
            }
        }
        visitedClasses.remove(clazz);
        answer = DefaultObjectSizeEstimator.align(answer);
        this.class2size.putIfAbsent(clazz, answer);
        return answer;
    }

    private static int align(int size) {
        int r2 = size % 8;
        if (r2 != 0) {
            size += 8 - r2;
        }
        return size;
    }
}

