/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.util.internal.ReusableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    Set<K> keySet;
    Set<Map.Entry<K, V>> entrySet;
    Collection<V> values;

    private static int hash(int h2) {
        h2 += h2 << 15 ^ 0xFFFFCD7D;
        h2 ^= h2 >>> 10;
        h2 += h2 << 3;
        h2 ^= h2 >>> 6;
        h2 += (h2 << 2) + (h2 << 14);
        return h2 ^ h2 >>> 16;
    }

    Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    private static int hashOf(Object key) {
        return ConcurrentHashMap.hash(key.hashCode());
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c2;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c2 = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c2;
        }
        for (cap = 1; cap < c2; cap <<= 1) {
        }
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = new Segment(cap, loadFactor);
        }
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map<? extends K, ? extends V> m2) {
        this(Math.max((int)((float)m2.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(m2);
    }

    @Override
    public boolean isEmpty() {
        int i2;
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i2 = 0; i2 < segments.length; ++i2) {
            if (segments[i2].count != 0) {
                return false;
            }
            mc[i2] = segments[i2].modCount;
            mcsum += mc[i2];
        }
        if (mcsum != 0) {
            for (i2 = 0; i2 < segments.length; ++i2) {
                if (segments[i2].count == 0 && mc[i2] == segments[i2].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k2 = 0; k2 < 2; ++k2) {
            int i2;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i2 = 0; i2 < segments.length; ++i2) {
                sum += (long)segments[i2].count;
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
            }
            if (mcsum != 0) {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    check += (long)segments[i2].count;
                    if (mc[i2] == segments[i2].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            sum = 0L;
            for (Segment<K, V> segment : segments) {
                segment.lock();
            }
            for (Segment<K, V> segment : segments) {
                sum += (long)segment.count;
            }
            for (Segment<K, V> segment : segments) {
                segment.unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    @Override
    public V get(Object key) {
        int hash = ConcurrentHashMap.hashOf(key);
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = ConcurrentHashMap.hashOf(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k2 = 0; k2 < 2; ++k2) {
            int mcsum = 0;
            for (int i2 = 0; i2 < segments.length; ++i2) {
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
                if (!segments[i2].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i3 = 0; i3 < segments.length; ++i3) {
                    if (mc[i3] == segments[i3].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (Segment<K, V> segment : segments) {
            segment.lock();
        }
        boolean found = false;
        try {
            for (Segment<K, V> segment : segments) {
                if (!segment.containsValue(value)) continue;
                found = true;
                break;
            }
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            for (Segment<K, V> segment : segments) {
                segment.unlock();
            }
            throw throwable;
        }
        for (Segment<K, V> segment : segments) {
            segment.unlock();
        }
        return found;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hashOf(key);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hashOf(key);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m2) {
        for (Map.Entry<K, V> e2 : m2.entrySet()) {
            this.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int hash = ConcurrentHashMap.hashOf(key);
        return this.segmentFor(hash).remove(key, hash, null, false);
    }

    @Override
    public boolean remove(Object key, Object value) {
        int hash = ConcurrentHashMap.hashOf(key);
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value, false) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hashOf(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hashOf(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void clear() {
        for (Segment<K, V> segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object v = ConcurrentHashMap.this.get(e2.getKey());
            return v != null && v.equals(e2.getValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return ConcurrentHashMap.this.remove(e2.getKey(), e2.getValue());
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return ConcurrentHashMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return ConcurrentHashMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            return ConcurrentHashMap.this.remove(o2) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements ReusableIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry e2 = this.nextEntry();
            return new WriteThroughEntry(e2.key(), e2.value());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        WriteThroughEntry(K k2, V v) {
            super(k2, v);
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value);
            ConcurrentHashMap.this.put(this.getKey(), value);
            return v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return SimpleEntry.eq(this.key, e2.getKey()) && SimpleEntry.eq(this.value, e2.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements ReusableIterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value();
        }

        @Override
        public V nextElement() {
            return this.nextEntry().value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements ReusableIterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().key();
        }

        @Override
        public K nextElement() {
            return this.nextEntry().key();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;
        K currentKey;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public void rewind() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.currentTable = null;
            this.nextEntry = null;
            this.lastReturned = null;
            this.currentKey = null;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = ConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j2 = this.currentTable.length - 1; j2 >= 0; --j2) {
                    this.nextEntry = this.currentTable[j2];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j2 - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            while (this.nextEntry != null) {
                if (this.nextEntry.key() != null) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        HashEntry<K, V> nextEntry() {
            do {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                this.currentKey = this.lastReturned.key();
                this.advance();
            } while (this.currentKey == null);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.currentKey);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Segment<K, V>
    extends ReentrantLock {
        private static final long serialVersionUID = -2001752926705396395L;
        volatile transient int count;
        int modCount;
        int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(HashEntry.newArray(initialCapacity));
        }

        static <K, V> Segment<K, V>[] newArray(int i2) {
            return new Segment[i2];
        }

        private static boolean keyEq(Object src, Object dest) {
            return src.equals(dest);
        }

        void setTable(HashEntry<K, V>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashEntry<K, V> getFirst(int hash) {
            HashEntry<K, V>[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        HashEntry<K, V> newHashEntry(K key, int hash, HashEntry<K, V> next, V value) {
            return new HashEntry<K, V>(key, hash, next, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<K, V> e2) {
            V v;
            this.lock();
            try {
                v = e2.value();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return v;
        }

        V get(Object key, int hash) {
            if (this.count != 0) {
                HashEntry<K, V> e2 = this.getFirst(hash);
                while (e2 != null) {
                    if (e2.hash == hash && Segment.keyEq(key, e2.key())) {
                        V opaque = e2.value();
                        if (opaque != null) {
                            return opaque;
                        }
                        return this.readValueUnderLock(e2);
                    }
                    e2 = e2.next;
                }
            }
            return null;
        }

        boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                HashEntry<K, V> e2 = this.getFirst(hash);
                while (e2 != null) {
                    if (e2.hash == hash && Segment.keyEq(key, e2.key())) {
                        return true;
                    }
                    e2 = e2.next;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                for (HashEntry<K, V> e2 : this.table) {
                    while (e2 != null) {
                        V opaque = e2.value();
                        V v = opaque == null ? this.readValueUnderLock(e2) : opaque;
                        if (value.equals(v)) {
                            return true;
                        }
                        e2 = e2.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            boolean bl;
            this.lock();
            try {
                HashEntry<K, V> e2 = this.getFirst(hash);
                while (!(e2 == null || e2.hash == hash && Segment.keyEq(key, e2.key()))) {
                    e2 = e2.next;
                }
                boolean replaced = false;
                if (e2 != null && oldValue.equals(e2.value())) {
                    replaced = true;
                    e2.setValue(newValue);
                }
                bl = replaced;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key, int hash, V newValue) {
            V v;
            this.lock();
            try {
                HashEntry<K, V> e2 = this.getFirst(hash);
                while (!(e2 == null || e2.hash == hash && Segment.keyEq(key, e2.key()))) {
                    e2 = e2.next;
                }
                V oldValue = null;
                if (e2 != null) {
                    oldValue = e2.value();
                    e2.setValue(newValue);
                }
                v = oldValue;
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent) {
            V v;
            this.lock();
            try {
                V oldValue;
                HashEntry<K, V> first;
                int reduced;
                int c2 = this.count;
                if (c2++ > this.threshold && (reduced = this.rehash()) > 0) {
                    this.count = (c2 -= reduced) - 1;
                }
                HashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<K, V> e2 = first = tab[index];
                while (!(e2 == null || e2.hash == hash && Segment.keyEq(key, e2.key()))) {
                    e2 = e2.next;
                }
                if (e2 != null) {
                    oldValue = e2.value();
                    if (!onlyIfAbsent) {
                        e2.setValue(value);
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = this.newHashEntry(key, hash, first, value);
                    this.count = c2;
                }
                v = oldValue;
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return v;
        }

        int rehash() {
            HashEntry<K, V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return 0;
            }
            HashEntry<K, V>[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            int reduce = 0;
            for (HashEntry<K, V> e2 : oldTable) {
                if (e2 == null) continue;
                HashEntry next = e2.next;
                int idx = e2.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e2;
                    continue;
                }
                HashEntry<K, V> lastRun = e2;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    int k2 = last.hash & sizeMask;
                    if (k2 != lastIdx) {
                        lastIdx = k2;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry<K, V> p2 = e2;
                while (p2 != lastRun) {
                    K key = p2.key();
                    if (key == null) {
                        ++reduce;
                    } else {
                        int k3 = p2.hash & sizeMask;
                        HashEntry n2 = newTable[k3];
                        newTable[k3] = this.newHashEntry(key, p2.hash, n2, p2.value());
                    }
                    p2 = p2.next;
                }
            }
            this.table = newTable;
            return reduce;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash, Object value, boolean refRemove) {
            V v;
            this.lock();
            try {
                HashEntry<K, V> first;
                int c2 = this.count - 1;
                HashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<K, V> e2 = first = tab[index];
                while (e2 != null && key != e2.key && (refRemove || hash != e2.hash || !Segment.keyEq(key, e2.key()))) {
                    e2 = e2.next;
                }
                V oldValue = null;
                if (e2 != null) {
                    V v2 = e2.value();
                    if (value == null || value.equals(v2)) {
                        oldValue = v2;
                        ++this.modCount;
                        HashEntry newFirst = e2.next;
                        HashEntry<K, V> p2 = first;
                        while (p2 != e2) {
                            K pKey = p2.key();
                            if (pKey == null) {
                                --c2;
                            } else {
                                newFirst = this.newHashEntry(pKey, p2.hash, newFirst, p2.value());
                            }
                            p2 = p2.next;
                        }
                        tab[index] = newFirst;
                        this.count = c2;
                    }
                }
                v = oldValue;
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<K, V>[] tab = this.table;
                    for (int i2 = 0; i2 < tab.length; ++i2) {
                        tab[i2] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.unlock();
                    throw throwable;
                }
                this.unlock();
                {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HashEntry<K, V> {
        final Object key;
        final int hash;
        volatile Object value;
        final HashEntry<K, V> next;

        HashEntry(K key, int hash, HashEntry<K, V> next, V value) {
            this.hash = hash;
            this.next = next;
            this.key = key;
            this.value = value;
        }

        K key() {
            return (K)this.key;
        }

        V value() {
            return (V)this.value;
        }

        void setValue(V value) {
            this.value = value;
        }

        static <K, V> HashEntry<K, V>[] newArray(int i2) {
            return new HashEntry[i2];
        }
    }
}

