/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.ArrayList;
import java.util.Formatter;

public final class StringUtil {
    public static final String NEWLINE;
    private static final String EMPTY_STRING = "";

    private StringUtil() {
    }

    public static String stripControlCharacters(Object value) {
        if (value == null) {
            return null;
        }
        return StringUtil.stripControlCharacters(value.toString());
    }

    public static String stripControlCharacters(String value) {
        int i2;
        if (value == null) {
            return null;
        }
        boolean hasControlChars = false;
        for (int i3 = value.length() - 1; i3 >= 0; --i3) {
            if (!Character.isISOControl(value.charAt(i3))) continue;
            hasControlChars = true;
            break;
        }
        if (!hasControlChars) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value.length());
        for (i2 = 0; i2 < value.length() && Character.isISOControl(value.charAt(i2)); ++i2) {
        }
        boolean suppressingControlChars = false;
        while (i2 < value.length()) {
            if (Character.isISOControl(value.charAt(i2))) {
                suppressingControlChars = true;
            } else {
                if (suppressingControlChars) {
                    suppressingControlChars = false;
                    buf.append(' ');
                }
                buf.append(value.charAt(i2));
            }
            ++i2;
        }
        return buf.toString();
    }

    public static String[] split(String value, char delim) {
        int i2;
        int end = value.length();
        ArrayList<String> res = new ArrayList<String>();
        int start = 0;
        for (i2 = 0; i2 < end; ++i2) {
            if (value.charAt(i2) != delim) continue;
            if (start == i2) {
                res.add(EMPTY_STRING);
            } else {
                res.add(value.substring(start, i2));
            }
            start = i2 + 1;
        }
        if (start == 0) {
            res.add(value);
        } else if (start != end) {
            res.add(value.substring(start, end));
        } else {
            for (i2 = res.size() - 1; i2 >= 0 && ((String)res.get(i2)).length() == 0; --i2) {
                res.remove(i2);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] split(String value, char delim, int maxParts) {
        int i2;
        int end = value.length();
        ArrayList<String> res = new ArrayList<String>();
        int start = 0;
        int cpt = 1;
        for (i2 = 0; i2 < end && cpt < maxParts; ++i2) {
            if (value.charAt(i2) != delim) continue;
            if (start == i2) {
                res.add(EMPTY_STRING);
            } else {
                res.add(value.substring(start, i2));
            }
            start = i2 + 1;
            ++cpt;
        }
        if (start == 0) {
            res.add(value);
        } else if (start != end) {
            res.add(value.substring(start, end));
        } else {
            for (i2 = res.size() - 1; i2 >= 0 && ((String)res.get(i2)).length() == 0; --i2) {
                res.remove(i2);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public static String substringAfter(String value, char delim) {
        int pos = value.indexOf(delim);
        if (pos >= 0) {
            return value.substring(pos + 1);
        }
        return null;
    }

    static {
        String newLine;
        try {
            newLine = new Formatter().format("%n", new Object[0]).toString();
        }
        catch (Exception e2) {
            newLine = "\n";
        }
        NEWLINE = newLine;
    }
}

