/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal.jzlib;

import org.jboss.netty.util.internal.jzlib.Adler32;
import org.jboss.netty.util.internal.jzlib.InfCodes;
import org.jboss.netty.util.internal.jzlib.InfTree;
import org.jboss.netty.util.internal.jzlib.ZStream;

final class InfBlocks {
    private static final int[] inflate_mask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private static final int[] border = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final int TYPE = 0;
    private static final int LENS = 1;
    private static final int STORED = 2;
    private static final int TABLE = 3;
    private static final int BTREE = 4;
    private static final int DTREE = 5;
    private static final int CODES = 6;
    private static final int DRY = 7;
    private static final int DONE = 8;
    private static final int BAD = 9;
    private int mode;
    private int left;
    private int table;
    private int index;
    private int[] blens;
    private final int[] bb = new int[1];
    private final int[] tb = new int[1];
    private final InfCodes codes = new InfCodes();
    private int last;
    int bitk;
    int bitb;
    private int[] hufts;
    byte[] window;
    final int end;
    int read;
    int write;
    private final Object checkfn;
    private long check;
    private final InfTree inftree = new InfTree();

    InfBlocks(ZStream z, Object checkfn, int w) {
        this.hufts = new int[4320];
        this.window = new byte[w];
        this.end = w;
        this.checkfn = checkfn;
        this.mode = 0;
        this.reset(z, null);
    }

    void reset(ZStream z, long[] c2) {
        if (c2 != null) {
            c2[0] = this.check;
        }
        this.mode = 0;
        this.bitk = 0;
        this.bitb = 0;
        this.write = 0;
        this.read = 0;
        if (this.checkfn != null) {
            z.adler = this.check = Adler32.adler32(0L, null, 0, 0);
        }
    }

    int proc(ZStream z, int r2) {
        int p2 = z.next_in_index;
        int n2 = z.avail_in;
        int b2 = this.bitb;
        int k2 = this.bitk;
        int q2 = this.write;
        int m2 = q2 < this.read ? this.read - q2 - 1 : this.end - q2;
        block18: while (true) {
            switch (this.mode) {
                case 0: {
                    Object td;
                    Object tl;
                    int[] bd;
                    int[] bl;
                    while (k2 < 3) {
                        if (n2 == 0) {
                            this.bitb = b2;
                            this.bitk = k2;
                            z.avail_in = n2;
                            z.total_in += (long)(p2 - z.next_in_index);
                            z.next_in_index = p2;
                            this.write = q2;
                            return this.inflate_flush(z, r2);
                        }
                        r2 = 0;
                        --n2;
                        b2 |= (z.next_in[p2++] & 0xFF) << k2;
                        k2 += 8;
                    }
                    int t = b2 & 7;
                    this.last = t & 1;
                    switch (t >>> 1) {
                        case 0: {
                            b2 >>>= 3;
                            t = (k2 -= 3) & 7;
                            b2 >>>= t;
                            k2 -= t;
                            this.mode = 1;
                            break;
                        }
                        case 1: {
                            bl = new int[1];
                            bd = new int[1];
                            tl = new int[1][];
                            td = new int[1][];
                            InfTree.inflate_trees_fixed(bl, bd, tl, td);
                            this.codes.init(bl[0], bd[0], tl[0], 0, td[0], 0);
                            b2 >>>= 3;
                            k2 -= 3;
                            this.mode = 6;
                            break;
                        }
                        case 2: {
                            b2 >>>= 3;
                            k2 -= 3;
                            this.mode = 3;
                            break;
                        }
                        case 3: {
                            this.mode = 9;
                            z.msg = "invalid block type";
                            r2 = -3;
                            this.bitb = b2 >>>= 3;
                            this.bitk = k2 -= 3;
                            z.avail_in = n2;
                            z.total_in += (long)(p2 - z.next_in_index);
                            z.next_in_index = p2;
                            this.write = q2;
                            return this.inflate_flush(z, r2);
                        }
                    }
                    continue block18;
                }
                case 1: {
                    while (k2 < 32) {
                        if (n2 == 0) {
                            this.bitb = b2;
                            this.bitk = k2;
                            z.avail_in = n2;
                            z.total_in += (long)(p2 - z.next_in_index);
                            z.next_in_index = p2;
                            this.write = q2;
                            return this.inflate_flush(z, r2);
                        }
                        r2 = 0;
                        --n2;
                        b2 |= (z.next_in[p2++] & 0xFF) << k2;
                        k2 += 8;
                    }
                    if ((~b2 >>> 16 & 0xFFFF) != (b2 & 0xFFFF)) {
                        this.mode = 9;
                        z.msg = "invalid stored block lengths";
                        r2 = -3;
                        this.bitb = b2;
                        this.bitk = k2;
                        z.avail_in = n2;
                        z.total_in += (long)(p2 - z.next_in_index);
                        z.next_in_index = p2;
                        this.write = q2;
                        return this.inflate_flush(z, r2);
                    }
                    this.left = b2 & 0xFFFF;
                    k2 = 0;
                    b2 = 0;
                    this.mode = this.left != 0 ? 2 : (this.last != 0 ? 7 : 0);
                    continue block18;
                }
                case 2: {
                    if (n2 == 0) {
                        this.bitb = b2;
                        this.bitk = k2;
                        z.avail_in = 0;
                        z.total_in += (long)(p2 - z.next_in_index);
                        z.next_in_index = p2;
                        this.write = q2;
                        return this.inflate_flush(z, r2);
                    }
                    if (m2 == 0) {
                        if (q2 == this.end && this.read != 0) {
                            q2 = 0;
                            int n3 = m2 = q2 < this.read ? this.read - q2 - 1 : this.end - q2;
                        }
                        if (m2 == 0) {
                            this.write = q2;
                            r2 = this.inflate_flush(z, r2);
                            q2 = this.write;
                            int n4 = m2 = q2 < this.read ? this.read - q2 - 1 : this.end - q2;
                            if (q2 == this.end && this.read != 0) {
                                q2 = 0;
                                int n5 = m2 = q2 < this.read ? this.read - q2 - 1 : this.end - q2;
                            }
                            if (m2 == 0) {
                                this.bitb = b2;
                                this.bitk = k2;
                                z.avail_in = n2;
                                z.total_in += (long)(p2 - z.next_in_index);
                                z.next_in_index = p2;
                                this.write = q2;
                                return this.inflate_flush(z, r2);
                            }
                        }
                    }
                    r2 = 0;
                    int t = this.left;
                    if (t > n2) {
                        t = n2;
                    }
                    if (t > m2) {
                        t = m2;
                    }
                    System.arraycopy(z.next_in, p2, this.window, q2, t);
                    p2 += t;
                    n2 -= t;
                    q2 += t;
                    m2 -= t;
                    if ((this.left -= t) != 0) continue block18;
                    this.mode = this.last != 0 ? 7 : 0;
                    continue block18;
                }
                case 3: {
                    int t;
                    while (k2 < 14) {
                        if (n2 == 0) {
                            this.bitb = b2;
                            this.bitk = k2;
                            z.avail_in = n2;
                            z.total_in += (long)(p2 - z.next_in_index);
                            z.next_in_index = p2;
                            this.write = q2;
                            return this.inflate_flush(z, r2);
                        }
                        r2 = 0;
                        --n2;
                        b2 |= (z.next_in[p2++] & 0xFF) << k2;
                        k2 += 8;
                    }
                    this.table = t = b2 & 0x3FFF;
                    if ((t & 0x1F) > 29 || (t >> 5 & 0x1F) > 29) {
                        this.mode = 9;
                        z.msg = "too many length or distance symbols";
                        r2 = -3;
                        this.bitb = b2;
                        this.bitk = k2;
                        z.avail_in = n2;
                        z.total_in += (long)(p2 - z.next_in_index);
                        z.next_in_index = p2;
                        this.write = q2;
                        return this.inflate_flush(z, r2);
                    }
                    t = 258 + (t & 0x1F) + (t >> 5 & 0x1F);
                    if (this.blens == null || this.blens.length < t) {
                        this.blens = new int[t];
                    } else {
                        for (int i2 = 0; i2 < t; ++i2) {
                            this.blens[i2] = 0;
                        }
                    }
                    b2 >>>= 14;
                    k2 -= 14;
                    this.index = 0;
                    this.mode = 4;
                }
                case 4: {
                    while (this.index < 4 + (this.table >>> 10)) {
                        while (k2 < 3) {
                            if (n2 == 0) {
                                this.bitb = b2;
                                this.bitk = k2;
                                z.avail_in = n2;
                                z.total_in += (long)(p2 - z.next_in_index);
                                z.next_in_index = p2;
                                this.write = q2;
                                return this.inflate_flush(z, r2);
                            }
                            r2 = 0;
                            --n2;
                            b2 |= (z.next_in[p2++] & 0xFF) << k2;
                            k2 += 8;
                        }
                        this.blens[InfBlocks.border[this.index++]] = b2 & 7;
                        b2 >>>= 3;
                        k2 -= 3;
                    }
                    while (this.index < 19) {
                        this.blens[InfBlocks.border[this.index++]] = 0;
                    }
                    this.bb[0] = 7;
                    int t = this.inftree.inflate_trees_bits(this.blens, this.bb, this.tb, this.hufts, z);
                    if (t != 0) {
                        r2 = t;
                        if (r2 == -3) {
                            this.blens = null;
                            this.mode = 9;
                        }
                        this.bitb = b2;
                        this.bitk = k2;
                        z.avail_in = n2;
                        z.total_in += (long)(p2 - z.next_in_index);
                        z.next_in_index = p2;
                        this.write = q2;
                        return this.inflate_flush(z, r2);
                    }
                    this.index = 0;
                    this.mode = 5;
                }
                case 5: {
                    int t;
                    while (this.index < 258 + ((t = this.table) & 0x1F) + (t >> 5 & 0x1F)) {
                        int j2;
                        int c2;
                        t = this.bb[0];
                        while (k2 < t) {
                            if (n2 == 0) {
                                this.bitb = b2;
                                this.bitk = k2;
                                z.avail_in = n2;
                                z.total_in += (long)(p2 - z.next_in_index);
                                z.next_in_index = p2;
                                this.write = q2;
                                return this.inflate_flush(z, r2);
                            }
                            r2 = 0;
                            --n2;
                            b2 |= (z.next_in[p2++] & 0xFF) << k2;
                            k2 += 8;
                        }
                        if (this.tb[0] == -1) {
                            // empty if block
                        }
                        if ((c2 = this.hufts[(this.tb[0] + (b2 & inflate_mask[t = this.hufts[(this.tb[0] + (b2 & inflate_mask[t])) * 3 + 1]])) * 3 + 2]) < 16) {
                            b2 >>>= t;
                            k2 -= t;
                            this.blens[this.index++] = c2;
                            continue;
                        }
                        int i3 = c2 == 18 ? 7 : c2 - 14;
                        int n6 = j2 = c2 == 18 ? 11 : 3;
                        while (k2 < t + i3) {
                            if (n2 == 0) {
                                this.bitb = b2;
                                this.bitk = k2;
                                z.avail_in = n2;
                                z.total_in += (long)(p2 - z.next_in_index);
                                z.next_in_index = p2;
                                this.write = q2;
                                return this.inflate_flush(z, r2);
                            }
                            r2 = 0;
                            --n2;
                            b2 |= (z.next_in[p2++] & 0xFF) << k2;
                            k2 += 8;
                        }
                        k2 -= t;
                        j2 += (b2 >>>= t) & inflate_mask[i3];
                        b2 >>>= i3;
                        k2 -= i3;
                        i3 = this.index;
                        t = this.table;
                        if (i3 + j2 > 258 + (t & 0x1F) + (t >> 5 & 0x1F) || c2 == 16 && i3 < 1) {
                            this.blens = null;
                            this.mode = 9;
                            z.msg = "invalid bit length repeat";
                            r2 = -3;
                            this.bitb = b2;
                            this.bitk = k2;
                            z.avail_in = n2;
                            z.total_in += (long)(p2 - z.next_in_index);
                            z.next_in_index = p2;
                            this.write = q2;
                            return this.inflate_flush(z, r2);
                        }
                        c2 = c2 == 16 ? this.blens[i3 - 1] : 0;
                        do {
                            this.blens[i3++] = c2;
                        } while (--j2 != 0);
                        this.index = i3;
                    }
                    this.tb[0] = -1;
                    int[] bl = new int[1];
                    int[] bd = new int[1];
                    Object tl = new int[1];
                    Object td = new int[1];
                    bl[0] = 9;
                    bd[0] = 6;
                    t = this.table;
                    t = this.inftree.inflate_trees_dynamic(257 + (t & 0x1F), 1 + (t >> 5 & 0x1F), this.blens, bl, bd, (int[])tl, (int[])td, this.hufts, z);
                    if (t != 0) {
                        if (t == -3) {
                            this.blens = null;
                            this.mode = 9;
                        }
                        r2 = t;
                        this.bitb = b2;
                        this.bitk = k2;
                        z.avail_in = n2;
                        z.total_in += (long)(p2 - z.next_in_index);
                        z.next_in_index = p2;
                        this.write = q2;
                        return this.inflate_flush(z, r2);
                    }
                    this.codes.init(bl[0], bd[0], this.hufts, (int)tl[0], this.hufts, (int)td[0]);
                    this.mode = 6;
                }
                case 6: {
                    this.bitb = b2;
                    this.bitk = k2;
                    z.avail_in = n2;
                    z.total_in += (long)(p2 - z.next_in_index);
                    z.next_in_index = p2;
                    this.write = q2;
                    r2 = this.codes.proc(this, z, r2);
                    if (r2 != 1) {
                        return this.inflate_flush(z, r2);
                    }
                    r2 = 0;
                    p2 = z.next_in_index;
                    n2 = z.avail_in;
                    b2 = this.bitb;
                    k2 = this.bitk;
                    q2 = this.write;
                    int n7 = m2 = q2 < this.read ? this.read - q2 - 1 : this.end - q2;
                    if (this.last == 0) {
                        this.mode = 0;
                        continue block18;
                    }
                    this.mode = 7;
                }
                case 7: {
                    this.write = q2;
                    r2 = this.inflate_flush(z, r2);
                    q2 = this.write;
                    if (this.read != this.write) {
                        this.bitb = b2;
                        this.bitk = k2;
                        z.avail_in = n2;
                        z.total_in += (long)(p2 - z.next_in_index);
                        z.next_in_index = p2;
                        this.write = q2;
                        return this.inflate_flush(z, r2);
                    }
                    this.mode = 8;
                }
                case 8: {
                    r2 = 1;
                    this.bitb = b2;
                    this.bitk = k2;
                    z.avail_in = n2;
                    z.total_in += (long)(p2 - z.next_in_index);
                    z.next_in_index = p2;
                    this.write = q2;
                    return this.inflate_flush(z, r2);
                }
                case 9: {
                    r2 = -3;
                    this.bitb = b2;
                    this.bitk = k2;
                    z.avail_in = n2;
                    z.total_in += (long)(p2 - z.next_in_index);
                    z.next_in_index = p2;
                    this.write = q2;
                    return this.inflate_flush(z, r2);
                }
            }
            break;
        }
        r2 = -2;
        this.bitb = b2;
        this.bitk = k2;
        z.avail_in = n2;
        z.total_in += (long)(p2 - z.next_in_index);
        z.next_in_index = p2;
        this.write = q2;
        return this.inflate_flush(z, r2);
    }

    void free(ZStream z) {
        this.reset(z, null);
        this.window = null;
        this.hufts = null;
    }

    void set_dictionary(byte[] d2, int start, int n2) {
        System.arraycopy(d2, start, this.window, 0, n2);
        this.read = this.write = n2;
    }

    int sync_point() {
        return this.mode == 1 ? 1 : 0;
    }

    int inflate_flush(ZStream z, int r2) {
        int p2 = z.next_out_index;
        int q2 = this.read;
        int n2 = (q2 <= this.write ? this.write : this.end) - q2;
        if (n2 > z.avail_out) {
            n2 = z.avail_out;
        }
        if (n2 != 0 && r2 == -5) {
            r2 = 0;
        }
        z.avail_out -= n2;
        z.total_out += (long)n2;
        if (this.checkfn != null) {
            z.adler = this.check = Adler32.adler32(this.check, this.window, q2, n2);
        }
        System.arraycopy(this.window, q2, z.next_out, p2, n2);
        p2 += n2;
        if ((q2 += n2) == this.end) {
            q2 = 0;
            if (this.write == this.end) {
                this.write = 0;
            }
            if ((n2 = this.write - q2) > z.avail_out) {
                n2 = z.avail_out;
            }
            if (n2 != 0 && r2 == -5) {
                r2 = 0;
            }
            z.avail_out -= n2;
            z.total_out += (long)n2;
            if (this.checkfn != null) {
                z.adler = this.check = Adler32.adler32(this.check, this.window, q2, n2);
            }
            System.arraycopy(this.window, q2, z.next_out, p2, n2);
            p2 += n2;
            q2 += n2;
        }
        z.next_out_index = p2;
        this.read = q2;
        return r2;
    }
}

