/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwt.consumer;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jose4j.jca.ProviderContext;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.InvalidJwtSignatureException;
import org.jose4j.jwt.consumer.JweCustomizer;
import org.jose4j.jwt.consumer.JwsCustomizer;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.ExceptionHelp;
import org.jose4j.lang.JoseException;

public class JwtConsumer {
    private VerificationKeyResolver verificationKeyResolver;
    private DecryptionKeyResolver decryptionKeyResolver;
    private List<ErrorCodeValidator> validators;
    private AlgorithmConstraints jwsAlgorithmConstraints;
    private AlgorithmConstraints jweAlgorithmConstraints;
    private AlgorithmConstraints jweContentEncryptionAlgorithmConstraints;
    private boolean requireSignature = true;
    private boolean requireEncryption;
    private boolean liberalContentTypeHandling;
    private boolean skipSignatureVerification;
    private boolean relaxVerificationKeyValidation;
    private boolean skipVerificationKeyResolutionOnNone;
    private boolean relaxDecryptionKeyValidation;
    private ProviderContext jwsProviderContext;
    private ProviderContext jweProviderContext;
    private JwsCustomizer jwsCustomizer;
    private JweCustomizer jweCustomizer;

    JwtConsumer() {
    }

    void setJwsAlgorithmConstraints(AlgorithmConstraints constraints) {
        this.jwsAlgorithmConstraints = constraints;
    }

    void setJweAlgorithmConstraints(AlgorithmConstraints constraints) {
        this.jweAlgorithmConstraints = constraints;
    }

    void setJweContentEncryptionAlgorithmConstraints(AlgorithmConstraints constraints) {
        this.jweContentEncryptionAlgorithmConstraints = constraints;
    }

    void setVerificationKeyResolver(VerificationKeyResolver verificationKeyResolver) {
        this.verificationKeyResolver = verificationKeyResolver;
    }

    void setDecryptionKeyResolver(DecryptionKeyResolver decryptionKeyResolver) {
        this.decryptionKeyResolver = decryptionKeyResolver;
    }

    void setValidators(List<ErrorCodeValidator> validators) {
        this.validators = validators;
    }

    void setRequireSignature(boolean requireSignature) {
        this.requireSignature = requireSignature;
    }

    void setRequireEncryption(boolean requireEncryption) {
        this.requireEncryption = requireEncryption;
    }

    void setLiberalContentTypeHandling(boolean liberalContentTypeHandling) {
        this.liberalContentTypeHandling = liberalContentTypeHandling;
    }

    void setSkipSignatureVerification(boolean skipSignatureVerification) {
        this.skipSignatureVerification = skipSignatureVerification;
    }

    void setRelaxVerificationKeyValidation(boolean relaxVerificationKeyValidation) {
        this.relaxVerificationKeyValidation = relaxVerificationKeyValidation;
    }

    public void setSkipVerificationKeyResolutionOnNone(boolean skipVerificationKeyResolutionOnNone) {
        this.skipVerificationKeyResolutionOnNone = skipVerificationKeyResolutionOnNone;
    }

    void setRelaxDecryptionKeyValidation(boolean relaxDecryptionKeyValidation) {
        this.relaxDecryptionKeyValidation = relaxDecryptionKeyValidation;
    }

    void setJwsProviderContext(ProviderContext jwsProviderContext) {
        this.jwsProviderContext = jwsProviderContext;
    }

    void setJweProviderContext(ProviderContext jweProviderContext) {
        this.jweProviderContext = jweProviderContext;
    }

    void setJwsCustomizer(JwsCustomizer jwsCustomizer) {
        this.jwsCustomizer = jwsCustomizer;
    }

    void setJweCustomizer(JweCustomizer jweCustomizer) {
        this.jweCustomizer = jweCustomizer;
    }

    public JwtClaims processToClaims(String jwt) throws InvalidJwtException {
        return this.process(jwt).getJwtClaims();
    }

    public void processContext(JwtContext jwtContext) throws InvalidJwtException {
        boolean hasSignature = false;
        boolean hasEncryption = false;
        ArrayList<JsonWebStructure> originalJoseObjects = new ArrayList<JsonWebStructure>(jwtContext.getJoseObjects());
        for (int idx = originalJoseObjects.size() - 1; idx >= 0; --idx) {
            ErrorCodeValidator.Error error;
            List<JsonWebStructure> joseObjects = originalJoseObjects.subList(idx + 1, originalJoseObjects.size());
            List<JsonWebStructure> nestingContext = Collections.unmodifiableList(joseObjects);
            JsonWebStructure currentJoseObject = originalJoseObjects.get(idx);
            try {
                if (currentJoseObject instanceof JsonWebSignature) {
                    JsonWebSignature jws = (JsonWebSignature)currentJoseObject;
                    boolean isNoneAlg = "none".equals(jws.getAlgorithmHeaderValue());
                    if (!this.skipSignatureVerification) {
                        if (this.jwsProviderContext != null) {
                            jws.setProviderContext(this.jwsProviderContext);
                        }
                        if (this.relaxVerificationKeyValidation) {
                            jws.setDoKeyValidation(false);
                        }
                        if (this.jwsAlgorithmConstraints != null) {
                            jws.setAlgorithmConstraints(this.jwsAlgorithmConstraints);
                        }
                        if (!isNoneAlg || !this.skipVerificationKeyResolutionOnNone) {
                            Key key = this.verificationKeyResolver.resolveKey(jws, nestingContext);
                            jws.setKey(key);
                        }
                        if (this.jwsCustomizer != null) {
                            this.jwsCustomizer.customize(jws, nestingContext);
                        }
                        if (!jws.verifySignature()) {
                            throw new InvalidJwtSignatureException(jws, jwtContext);
                        }
                    }
                    if (isNoneAlg) continue;
                    hasSignature = true;
                    continue;
                }
                JsonWebEncryption jwe = (JsonWebEncryption)currentJoseObject;
                Key key = this.decryptionKeyResolver.resolveKey(jwe, nestingContext);
                if (key != null && !key.equals(jwe.getKey())) {
                    List<ErrorCodeValidator.Error> errors = Collections.singletonList(new ErrorCodeValidator.Error(17, "Key resolution problem."));
                    throw new InvalidJwtException("The resolved decryption key is different than the one originally used to decrypt the JWE.", errors, jwtContext);
                }
                if (this.jweAlgorithmConstraints != null) {
                    this.jweAlgorithmConstraints.checkConstraint(jwe.getAlgorithmHeaderValue());
                }
                if (this.jweContentEncryptionAlgorithmConstraints != null) {
                    this.jweContentEncryptionAlgorithmConstraints.checkConstraint(jwe.getEncryptionMethodHeaderParameter());
                }
                hasEncryption = true;
                continue;
            }
            catch (JoseException e2) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to process");
                if (!joseObjects.isEmpty()) {
                    sb.append(" nested");
                }
                sb.append(" JOSE object (cause: ").append(e2).append("): ").append(currentJoseObject);
                error = new ErrorCodeValidator.Error(17, sb.toString());
                throw new InvalidJwtException("JWT processing failed.", error, e2, jwtContext);
            }
            catch (InvalidJwtException e3) {
                throw e3;
            }
            catch (Exception e4) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unexpected exception encountered while processing");
                if (!joseObjects.isEmpty()) {
                    sb.append(" nested");
                }
                sb.append(" JOSE object (").append(e4).append("): ").append(currentJoseObject);
                error = new ErrorCodeValidator.Error(17, sb.toString());
                throw new InvalidJwtException("JWT processing failed.", error, e4, jwtContext);
            }
        }
        if (this.requireSignature && !hasSignature) {
            List<ErrorCodeValidator.Error> errors = Collections.singletonList(new ErrorCodeValidator.Error(10, "Missing signature."));
            throw new InvalidJwtException("The JWT has no signature but the JWT Consumer is configured to require one: " + jwtContext.getJwt(), errors, jwtContext);
        }
        if (this.requireEncryption && !hasEncryption) {
            List<ErrorCodeValidator.Error> errors = Collections.singletonList(new ErrorCodeValidator.Error(19, "No encryption."));
            throw new InvalidJwtException("The JWT has no encryption but the JWT Consumer is configured to require it: " + jwtContext.getJwt(), errors, jwtContext);
        }
        this.validate(jwtContext);
    }

    public JwtContext process(String jwt) throws InvalidJwtException {
        String workingJwt = jwt;
        JwtClaims jwtClaims = null;
        LinkedList<JsonWebStructure> joseObjects = new LinkedList<JsonWebStructure>();
        JwtContext jwtContext = new JwtContext(jwt, null, Collections.unmodifiableList(joseObjects));
        while (jwtClaims == null) {
            ErrorCodeValidator.Error error;
            StringBuilder sb;
            try {
                String payload;
                JsonWebStructure joseObject = JsonWebStructure.fromCompactSerialization(workingJwt);
                if (joseObject instanceof JsonWebSignature) {
                    JsonWebSignature jws = (JsonWebSignature)joseObject;
                    payload = jws.getUnverifiedPayload();
                } else {
                    JsonWebEncryption jwe = (JsonWebEncryption)joseObject;
                    if (this.jweProviderContext != null) {
                        jwe.setProviderContext(this.jweProviderContext);
                    }
                    if (this.relaxDecryptionKeyValidation) {
                        jwe.setDoKeyValidation(false);
                    }
                    if (this.jweContentEncryptionAlgorithmConstraints != null) {
                        jwe.setContentEncryptionAlgorithmConstraints(this.jweContentEncryptionAlgorithmConstraints);
                    }
                    List<JsonWebStructure> nestingContext = Collections.unmodifiableList(joseObjects);
                    Key key = this.decryptionKeyResolver.resolveKey(jwe, nestingContext);
                    jwe.setKey(key);
                    if (this.jweAlgorithmConstraints != null) {
                        jwe.setAlgorithmConstraints(this.jweAlgorithmConstraints);
                    }
                    if (this.jweCustomizer != null) {
                        this.jweCustomizer.customize(jwe, nestingContext);
                    }
                    payload = jwe.getPayload();
                }
                if (this.isNestedJwt(joseObject)) {
                    workingJwt = payload;
                } else {
                    try {
                        jwtClaims = JwtClaims.parse(payload, jwtContext);
                        jwtContext.setJwtClaims(jwtClaims);
                    }
                    catch (InvalidJwtException ije) {
                        if (this.liberalContentTypeHandling) {
                            try {
                                JsonWebStructure.fromCompactSerialization(jwt);
                                workingJwt = payload;
                            }
                            catch (JoseException je) {
                                throw ije;
                            }
                        }
                        throw ije;
                    }
                }
                joseObjects.addFirst(joseObject);
            }
            catch (JoseException e2) {
                sb = new StringBuilder();
                sb.append("Unable to process");
                if (!joseObjects.isEmpty()) {
                    sb.append(" nested");
                }
                sb.append(" JOSE object (cause: ").append(e2).append("): ").append(workingJwt);
                error = new ErrorCodeValidator.Error(17, sb.toString());
                throw new InvalidJwtException("JWT processing failed.", error, e2, jwtContext);
            }
            catch (InvalidJwtException e3) {
                throw e3;
            }
            catch (Exception e4) {
                sb = new StringBuilder();
                sb.append("Unexpected exception encountered while processing");
                if (!joseObjects.isEmpty()) {
                    sb.append(" nested");
                }
                sb.append(" JOSE object (").append(e4).append("): ").append(workingJwt);
                error = new ErrorCodeValidator.Error(17, sb.toString());
                throw new InvalidJwtException("JWT processing failed.", error, e4, jwtContext);
            }
        }
        this.processContext(jwtContext);
        return jwtContext;
    }

    void validate(JwtContext jwtCtx) throws InvalidJwtException {
        ArrayList<ErrorCodeValidator.Error> issues = new ArrayList<ErrorCodeValidator.Error>();
        for (ErrorCodeValidator validator : this.validators) {
            ErrorCodeValidator.Error error;
            try {
                error = validator.validate(jwtCtx);
            }
            catch (MalformedClaimException e2) {
                error = new ErrorCodeValidator.Error(18, e2.getMessage());
            }
            catch (Exception e3) {
                String msg = "Unexpected exception thrown from validator " + validator.getClass().getName() + ": " + ExceptionHelp.toStringWithCausesAndAbbreviatedStack(e3, this.getClass());
                error = new ErrorCodeValidator.Error(17, msg);
            }
            if (error == null) continue;
            issues.add(error);
        }
        if (!issues.isEmpty()) {
            String msg = "JWT (claims->" + jwtCtx.getJwtClaims().getRawJson() + ") rejected due to invalid claims.";
            throw new InvalidJwtException(msg, issues, jwtCtx);
        }
    }

    private boolean isNestedJwt(JsonWebStructure joseObject) {
        String cty = joseObject.getContentTypeHeaderValue();
        return cty != null && (cty.equalsIgnoreCase("jwt") || cty.equalsIgnoreCase("application/jwt"));
    }
}

