/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwx;

public class CompactSerializer {
    private static final String PERIOD_SEPARATOR = ".";
    private static final String PERIOD_SEPARATOR_REGEX = "\\.";
    private static final String EMPTY_STRING = "";

    public static String[] deserialize(String compactSerialization) {
        String[] parts = compactSerialization.split(PERIOD_SEPARATOR_REGEX);
        if (compactSerialization.endsWith(PERIOD_SEPARATOR)) {
            String[] tempParts = new String[parts.length + 1];
            System.arraycopy(parts, 0, tempParts, 0, parts.length);
            tempParts[parts.length] = EMPTY_STRING;
            parts = tempParts;
        }
        return parts;
    }

    public static String serialize(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2] == null ? EMPTY_STRING : parts[i2];
            sb.append(part);
            if (i2 == parts.length - 1) continue;
            sb.append(PERIOD_SEPARATOR);
        }
        return sb.toString();
    }
}

