/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class CDATAEncoder
extends Encoder {
    private static final char[] CDATA_END_ENCODED = "]]]]><![CDATA[>".toCharArray();
    private static final int CDATA_END_ENCODED_LENGTH = 15;
    private static final int CDATA_END_LENGTH = 3;

    CDATAEncoder() {
    }

    protected int maxEncodedLength(int n2) {
        int worstCase = n2 / 3;
        int remainder = n2 % 3;
        return worstCase * 15 + remainder;
    }

    protected int firstEncodedOffset(String input, int off, int len) {
        int n2 = off + len;
        for (int i2 = off; i2 < n2; ++i2) {
            char ch = input.charAt(i2);
            if (ch <= '~') {
                if (ch != ']') {
                    if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
                    return i2;
                }
                if (i2 + 1 < n2) {
                    if (input.charAt(i2 + 1) != ']') continue;
                    while (i2 + 2 < n2 && input.charAt(i2 + 2) == ']') {
                        ++i2;
                    }
                    if (i2 + 2 < n2) {
                        if (input.charAt(i2 + 2) != '>') continue;
                        return i2;
                    }
                    return n2;
                }
                return n2;
            }
            if (ch < '\ud800') {
                if (ch > '\u009f' || ch == '\u0085') continue;
                return i2;
            }
            if (ch <= '\udbff') {
                if (i2 + 1 < n2) {
                    if (Character.isLowSurrogate(input.charAt(i2 + 1))) {
                        int cp = Character.toCodePoint(ch, input.charAt(i2 + 1));
                        if (Unicode.isNonCharacter(cp)) {
                            return i2;
                        }
                        ++i2;
                        continue;
                    }
                    return i2;
                }
                return i2;
            }
            if (ch > '\udfff' && ch <= '\ufffd' && ('\ufdd0' > ch || ch > '\ufdef')) continue;
            return i2;
        }
        return n2;
    }

    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i2;
        char[] in = input.array();
        char[] out = output.array();
        int n2 = input.arrayOffset() + input.limit();
        int j2 = output.arrayOffset() + output.position();
        int m2 = output.arrayOffset() + output.limit();
        for (i2 = input.arrayOffset() + input.position(); i2 < n2; ++i2) {
            char ch = in[i2];
            if (ch <= '~') {
                if (ch != ']') {
                    if (j2 >= m2) {
                        return CDATAEncoder.overflow(input, i2, output, j2);
                    }
                    if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                        out[j2++] = ch;
                        continue;
                    }
                    out[j2++] = 32;
                    continue;
                }
                if (i2 + 1 < n2) {
                    if (in[i2 + 1] != ']') {
                        if (j2 >= m2) {
                            return CDATAEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 93;
                        continue;
                    }
                    while (i2 + 2 < n2 && in[i2 + 2] == ']') {
                        if (j2 >= m2) {
                            return CDATAEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 93;
                        ++i2;
                    }
                    if (i2 + 2 < n2) {
                        if (in[i2 + 2] == '>') {
                            if (j2 + 15 > m2) {
                                return CDATAEncoder.overflow(input, i2, output, j2);
                            }
                            System.arraycopy(CDATA_END_ENCODED, 0, out, j2, 15);
                            j2 += 15;
                            i2 += 2;
                            continue;
                        }
                        if (j2 >= m2) {
                            return CDATAEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 93;
                        continue;
                    }
                    if (!endOfInput) break;
                    if (j2 + 2 > m2) {
                        return CDATAEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = 93;
                    out[j2++] = 93;
                    i2 = n2;
                    break;
                }
                if (!endOfInput) break;
                if (j2 >= m2) {
                    return CDATAEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 93;
                ++i2;
                break;
            }
            if (ch < '\ud800') {
                if (ch > '\u009f' || ch == '\u0085') {
                    if (j2 >= m2) {
                        return CDATAEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = ch;
                    continue;
                }
                if (j2 >= m2) {
                    return CDATAEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 32;
                continue;
            }
            if (ch <= '\udbff') {
                if (i2 + 1 < n2) {
                    if (Character.isLowSurrogate(in[i2 + 1])) {
                        int cp = Character.toCodePoint(ch, in[i2 + 1]);
                        if (Unicode.isNonCharacter(cp)) {
                            if (j2 >= m2) {
                                return CDATAEncoder.overflow(input, i2, output, j2);
                            }
                            out[j2++] = 32;
                            ++i2;
                            continue;
                        }
                        if (j2 + 1 >= m2) {
                            return CDATAEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = ch;
                        out[j2++] = in[++i2];
                        continue;
                    }
                    if (j2 >= m2) {
                        return CDATAEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = 32;
                    continue;
                }
                if (!endOfInput) break;
                if (j2 >= m2) {
                    return CDATAEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 32;
                continue;
            }
            if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                if (j2 >= m2) {
                    return CDATAEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 32;
                continue;
            }
            if (j2 >= m2) {
                return CDATAEncoder.overflow(input, i2, output, j2);
            }
            out[j2++] = ch;
        }
        return CDATAEncoder.underflow(input, i2, output, j2);
    }

    public String toString() {
        return "CDATAEncoder";
    }
}

