/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.ASCIIBits;
import org.owasp.encoder.Encoder;

class CSSEncoder
extends Encoder {
    static final int LONG_BITS = 64;
    static final int HEX_ENCODED_LENGTH = 4;
    static final char INVALID_REPLACEMENT_CHARACTER = '_';
    final long _lowMask;
    final long _highMask;
    final Mode _mode;

    CSSEncoder(Mode mode) {
        this._mode = mode;
        this._lowMask = mode.lowMask();
        this._highMask = mode.highMask();
    }

    protected int maxEncodedLength(int n2) {
        return 4 * n2;
    }

    protected int firstEncodedOffset(String input, int off, int len) {
        int n2 = off + len;
        for (int i2 = off; i2 < n2; ++i2) {
            char ch = input.charAt(i2);
            if (ch < '\u0080') {
                if ((ch < '@' ? this._lowMask & 1L << ch : this._highMask & 1L << ch - 64) != 0L) {
                    continue;
                }
            } else if (ch > '\u009f' && ch < '\u2028' || ch > '\u2029') {
                if (ch < '\ud800' || ch > '\udfff') continue;
                if (ch <= '\udbff') {
                    if (i2 + 1 < n2) {
                        if (Character.isLowSurrogate(input.charAt(i2 + 1))) {
                            ++i2;
                            continue;
                        }
                        return i2;
                    }
                    return i2;
                }
                return i2;
            }
            return i2;
        }
        return n2;
    }

    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i2;
        char[] in = input.array();
        char[] out = output.array();
        int n2 = input.arrayOffset() + input.limit();
        int j2 = output.arrayOffset() + output.position();
        int m2 = output.arrayOffset() + output.limit();
        for (i2 = input.arrayOffset() + input.position(); i2 < n2; ++i2) {
            int ch = in[i2];
            if (ch < 128) {
                if ((ch < 64 ? this._lowMask & 1L << ch : this._highMask & 1L << ch - 64) != 0L) {
                    if (j2 >= m2) {
                        return CSSEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = ch;
                    continue;
                }
            } else if (ch > 159 && ch < 8232 || ch > 8233) {
                if (ch < 55296 || ch > 57343) {
                    if (j2 >= m2) {
                        return CSSEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = ch;
                    continue;
                }
                if (ch <= 56319) {
                    if (i2 + 1 < n2) {
                        if (Character.isLowSurrogate(in[i2 + 1])) {
                            if (j2 + 1 >= m2) {
                                return CSSEncoder.overflow(input, i2, output, j2);
                            }
                            out[j2++] = ch;
                            out[j2++] = in[++i2];
                            continue;
                        }
                        if (j2 >= m2) {
                            return CSSEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 95;
                        continue;
                    }
                    if (!endOfInput) break;
                    if (j2 >= m2) {
                        return CSSEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = 95;
                    continue;
                }
                if (j2 >= m2) {
                    return CSSEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 95;
                continue;
            }
            int k2 = j2 + 1;
            int tmp = ch;
            do {
                ++k2;
            } while ((tmp >>>= 4) != 0);
            boolean needsSpace = false;
            if (i2 + 1 < n2) {
                char la = in[i2 + 1];
                if ('0' <= la && la <= '9' || 'a' <= la && la <= 'f' || 'A' <= la && la <= 'F' || la == ' ' || la == '\n' || la == '\r' || la == '\t' || la == '\f') {
                    needsSpace = true;
                    ++k2;
                }
            } else if (!endOfInput) break;
            if (k2 > m2) {
                return CSSEncoder.overflow(input, i2, output, j2);
            }
            out[j2] = 92;
            j2 = k2--;
            if (needsSpace) {
                out[k2] = 32;
            }
            tmp = ch;
            do {
                out[--k2] = HEX[tmp & 0xF];
            } while ((tmp >>>= 4) != 0);
            assert (out[k2 - 1] == '\\');
        }
        return CSSEncoder.underflow(input, i2, output, j2);
    }

    public String toString() {
        return "CSSEncoder(mode=" + (Object)((Object)this._mode) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        STRING(new ASCIIBits().set(32, 126).clear("\"'<&/\\>")),
        URL(new ASCIIBits().set("!#$%").set(42, 91).set(93, 126).clear("/<>"));

        private final long _lowMask;
        private final long _highMask;

        private Mode(ASCIIBits bits) {
            this._lowMask = bits._lowerMask;
            this._highMask = bits._upperMask;
        }

        long lowMask() {
            return this._lowMask;
        }

        long highMask() {
            return this._highMask;
        }
    }
}

