/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public abstract class Encoder {
    static final char[] HEX = "0123456789abcdef".toCharArray();
    static final int HEX_SHIFT = 4;
    static final int HEX_MASK = 15;

    Encoder() {
    }

    public CoderResult encode(CharBuffer input, CharBuffer output, boolean endOfInput) {
        if (input.hasRemaining()) {
            if (input.hasArray() && output.hasArray()) {
                return this.encodeArrays(input, output, endOfInput);
            }
            return this.encodeBuffers(input, output, endOfInput);
        }
        return CoderResult.UNDERFLOW;
    }

    CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        throw new UnsupportedOperationException();
    }

    CoderResult encodeBuffers(CharBuffer input, CharBuffer output, boolean endOfInput) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    abstract int maxEncodedLength(int var1);

    abstract int firstEncodedOffset(String var1, int var2, int var3);

    static CoderResult overflow(CharBuffer input, int i2, CharBuffer output, int j2) {
        input.position(i2 - input.arrayOffset());
        output.position(j2 - output.arrayOffset());
        return CoderResult.OVERFLOW;
    }

    static CoderResult underflow(CharBuffer input, int i2, CharBuffer output, int j2) {
        input.position(i2 - input.arrayOffset());
        output.position(j2 - output.arrayOffset());
        return CoderResult.UNDERFLOW;
    }
}

