/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class HTMLEncoder
extends Encoder {
    private static final int ENCODE_AFFIX_CHAR_COUNT = 3;
    private static final char[] TAB = "&#9;".toCharArray();
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();

    HTMLEncoder() {
    }

    int maxEncodedLength(int n2) {
        return n2 * 7;
    }

    int firstEncodedOffset(String input, int off, int len) {
        int n2 = off + len;
        block4: for (int i2 = off; i2 < n2; ++i2) {
            char ch = input.charAt(i2);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '`': 
                case '\u0085': {
                    return i2;
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    continue block4;
                }
                default: {
                    if (Character.isHighSurrogate(ch)) {
                        if (i2 + 1 < n2) {
                            if (Character.isLowSurrogate(input.charAt(i2 + 1))) {
                                int cp = Character.toCodePoint(ch, input.charAt(i2 + 1));
                                if (Unicode.isNonCharacter(cp)) {
                                    return i2;
                                }
                                ++i2;
                                continue block4;
                            }
                        } else {
                            return i2;
                        }
                    }
                    if (!(ch <= '\u009f' || '\ud800' <= ch && ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef' || ch == '\u2028') && ch != '\u2029') continue block4;
                    return i2;
                }
            }
        }
        return n2;
    }

    static int append(char[] src, char[] out, int j2) {
        System.arraycopy(src, 0, out, j2, src.length);
        return j2 + src.length;
    }

    static int encode(int codePoint, char[] out, int j2) {
        out[j2++] = 38;
        out[j2++] = 35;
        if (codePoint >= 1000) {
            out[j2++] = (char)(codePoint / 1000 % 10 + 48);
        }
        if (codePoint >= 100) {
            out[j2++] = (char)(codePoint / 100 % 10 + 48);
        }
        if (codePoint >= 10) {
            out[j2++] = (char)(codePoint / 10 % 10 + 48);
        }
        out[j2++] = (char)(codePoint % 10 + 48);
        out[j2++] = 59;
        return j2;
    }

    CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i2;
        char[] in = input.array();
        char[] out = output.array();
        int n2 = input.arrayOffset() + input.limit();
        int j2 = output.arrayOffset() + output.position();
        int m2 = output.arrayOffset() + output.limit();
        block9: for (i2 = input.arrayOffset() + input.position(); i2 < n2; ++i2) {
            char ch = in[i2];
            switch (ch) {
                case '\t': {
                    if (j2 + TAB.length > m2) {
                        return HTMLEncoder.overflow(input, i2, output, j2);
                    }
                    j2 = HTMLEncoder.append(TAB, out, j2);
                    continue block9;
                }
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '\'': 
                case '/': 
                case '=': 
                case '`': {
                    if (5 + j2 > m2) {
                        return HTMLEncoder.overflow(input, i2, output, j2);
                    }
                    j2 = HTMLEncoder.encode(ch, out, j2);
                    continue block9;
                }
                case '\u0085': {
                    if (6 + j2 > m2) {
                        return HTMLEncoder.overflow(input, i2, output, j2);
                    }
                    j2 = HTMLEncoder.encode(ch, out, j2);
                    continue block9;
                }
                case '&': {
                    if (j2 + AMP.length > m2) {
                        return HTMLEncoder.overflow(input, i2, output, j2);
                    }
                    j2 = HTMLEncoder.append(AMP, out, j2);
                    continue block9;
                }
                case '<': {
                    if (j2 + LT.length > m2) {
                        return HTMLEncoder.overflow(input, i2, output, j2);
                    }
                    j2 = HTMLEncoder.append(LT, out, j2);
                    continue block9;
                }
                case '>': {
                    if (j2 + GT.length > m2) {
                        return HTMLEncoder.overflow(input, i2, output, j2);
                    }
                    j2 = HTMLEncoder.append(GT, out, j2);
                    continue block9;
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    if (j2 >= m2) {
                        return HTMLEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = ch;
                    continue block9;
                }
                default: {
                    if (Character.isHighSurrogate(ch)) {
                        if (i2 + 1 < n2) {
                            if (Character.isLowSurrogate(in[i2 + 1])) {
                                int cp = Character.toCodePoint(ch, in[i2 + 1]);
                                if (Unicode.isNonCharacter(cp)) {
                                    if (j2 >= m2) {
                                        return HTMLEncoder.overflow(input, i2, output, j2);
                                    }
                                    out[j2++] = 45;
                                    ++i2;
                                    continue block9;
                                }
                                if (j2 + 1 >= m2) {
                                    return HTMLEncoder.overflow(input, i2, output, j2);
                                }
                                out[j2++] = ch;
                                out[j2++] = in[++i2];
                                continue block9;
                            }
                        } else if (!endOfInput) break block9;
                    }
                    if (j2 >= m2) {
                        return HTMLEncoder.overflow(input, i2, output, j2);
                    }
                    if (ch <= '\u009f' || '\ud800' <= ch && ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                        out[j2++] = 45;
                        continue block9;
                    }
                    if (ch == '\u2028' || ch == '\u2029') {
                        if (7 + j2 > m2) {
                            return HTMLEncoder.overflow(input, i2, output, j2);
                        }
                        j2 = HTMLEncoder.encode(ch, out, j2);
                        continue block9;
                    }
                    out[j2++] = ch;
                }
            }
        }
        return HTMLEncoder.underflow(input, i2, output, j2);
    }
}

