/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class XMLCommentEncoder
extends Encoder {
    static final char HYPHEN_REPLACEMENT = '~';

    XMLCommentEncoder() {
    }

    protected int maxEncodedLength(int n2) {
        return n2;
    }

    protected int firstEncodedOffset(String input, int off, int len) {
        int n2 = off + len;
        for (int i2 = off; i2 < n2; ++i2) {
            char ch = input.charAt(i2);
            if (ch <= '~') {
                if (ch == '-') {
                    if (i2 + 1 < n2) {
                        if (input.charAt(i2 + 1) != '-') continue;
                        return i2;
                    }
                    return i2;
                }
                if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
                return i2;
            }
            if (ch < '\ud800') {
                if (ch > '\u009f' || ch == '\u0085') continue;
                return i2;
            }
            if (ch <= '\udbff') {
                if (i2 + 1 < n2 && Character.isLowSurrogate(input.charAt(i2 + 1))) {
                    int cp = Character.toCodePoint(ch, input.charAt(i2 + 1));
                    if (Unicode.isNonCharacter(cp)) {
                        return i2;
                    }
                    ++i2;
                    continue;
                }
                return i2;
            }
            if (ch > '\udfff' && ch <= '\ufffd' && ('\ufdd0' > ch || ch > '\ufdef')) continue;
            return i2;
        }
        return n2;
    }

    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i2;
        char[] in = input.array();
        char[] out = output.array();
        int n2 = input.arrayOffset() + input.limit();
        int j2 = output.arrayOffset() + output.position();
        int m2 = output.arrayOffset() + output.limit();
        for (i2 = input.arrayOffset() + input.position(); i2 < n2; ++i2) {
            char ch = in[i2];
            if (ch <= '~') {
                if (ch == '-') {
                    if (i2 + 1 < n2) {
                        if (in[i2 + 1] == '-') {
                            if (j2 + 1 >= m2) {
                                return XMLCommentEncoder.overflow(input, i2, output, j2);
                            }
                            out[j2++] = 45;
                            out[j2++] = 126;
                            ++i2;
                            continue;
                        }
                        if (j2 >= m2) {
                            return XMLCommentEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 45;
                        continue;
                    }
                    if (!endOfInput) break;
                    if (j2 >= m2) {
                        return XMLCommentEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = 126;
                    continue;
                }
                if (ch > ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                    if (j2 >= m2) {
                        return XMLCommentEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = ch;
                    continue;
                }
                if (j2 >= m2) {
                    return XMLCommentEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 32;
                continue;
            }
            if (ch < '\ud800') {
                if (j2 >= m2) {
                    return XMLCommentEncoder.overflow(input, i2, output, j2);
                }
                if (ch > '\u009f' || ch == '\u0085') {
                    out[j2++] = ch;
                    continue;
                }
                out[j2++] = 32;
                continue;
            }
            if (ch <= '\udbff') {
                if (i2 + 1 < n2) {
                    if (Character.isLowSurrogate(in[i2 + 1])) {
                        int cp = Character.toCodePoint(ch, in[i2 + 1]);
                        if (Unicode.isNonCharacter(cp)) {
                            if (j2 >= m2) {
                                return XMLCommentEncoder.overflow(input, i2, output, j2);
                            }
                            out[j2++] = 32;
                            ++i2;
                            continue;
                        }
                        if (j2 + 1 >= m2) {
                            return XMLCommentEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = ch;
                        out[j2++] = in[++i2];
                        continue;
                    }
                    if (j2 >= m2) {
                        return XMLCommentEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = 32;
                    continue;
                }
                if (!endOfInput) break;
                if (j2 >= m2) {
                    return XMLCommentEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 32;
                continue;
            }
            if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                if (j2 >= m2) {
                    return XMLCommentEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 32;
                continue;
            }
            if (j2 >= m2) {
                return XMLCommentEncoder.overflow(input, i2, output, j2);
            }
            out[j2++] = ch;
        }
        return XMLCommentEncoder.underflow(input, i2, output, j2);
    }

    public String toString() {
        return "XMLCommentEncoder";
    }
}

