/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class XMLEncoder
extends Encoder {
    private static final long BASE_VALID_MASK = 9728L;
    static final int MAX_ENCODED_CHAR_LENGTH = 5;
    static final int AMP_LENGTH = 5;
    static final int LT_LENGTH = 4;
    static final int GT_LENGTH = 4;
    static final int APOS_LENGTH = 5;
    static final int QUOT_LENGTH = 5;
    static final char INVALID_CHARACTER_REPLACEMENT = ' ';
    private final long _validMask;
    private final Mode _mode;

    XMLEncoder() {
        this(Mode.ALL);
    }

    XMLEncoder(Mode mode) {
        this._mode = mode;
        this._validMask = mode.validMask();
    }

    public int maxEncodedLength(int n2) {
        return n2 * 5;
    }

    public int firstEncodedOffset(String input, int off, int len) {
        int n2 = off + len;
        for (int i2 = off; i2 < n2; ++i2) {
            char ch = input.charAt(i2);
            if (ch < '\u007f') {
                if (ch > '>' || (this._validMask & 1L << ch) != 0L) continue;
                return i2;
            }
            if (ch < '\ud800') {
                if (ch > '\u009f' || ch == '\u0085') continue;
                return i2;
            }
            if (ch <= '\udbff') {
                if (i2 + 1 < n2 && Character.isLowSurrogate(input.charAt(i2 + 1))) {
                    int cp = Character.toCodePoint(ch, input.charAt(i2 + 1));
                    if (Unicode.isNonCharacter(cp)) {
                        return i2;
                    }
                    ++i2;
                    continue;
                }
                return i2;
            }
            if (ch > '\udfff' && ch <= '\ufffd' && ('\ufdd0' > ch || ch > '\ufdef')) continue;
            return i2;
        }
        return n2;
    }

    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i2;
        char[] in = input.array();
        char[] out = output.array();
        int n2 = input.arrayOffset() + input.limit();
        int j2 = output.arrayOffset() + output.position();
        int m2 = output.arrayOffset() + output.limit();
        for (i2 = input.arrayOffset() + input.position(); i2 < n2; ++i2) {
            char ch = in[i2];
            if (ch < '\u007f') {
                if (ch > '>' || (this._validMask & 1L << ch) != 0L) {
                    if (j2 >= m2) {
                        return XMLEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = ch;
                    continue;
                }
                switch (ch) {
                    case '&': {
                        if (j2 + 5 > m2) {
                            return XMLEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 38;
                        out[j2++] = 97;
                        out[j2++] = 109;
                        out[j2++] = 112;
                        out[j2++] = 59;
                        break;
                    }
                    case '<': {
                        if (j2 + 4 > m2) {
                            return XMLEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 38;
                        out[j2++] = 108;
                        out[j2++] = 116;
                        out[j2++] = 59;
                        break;
                    }
                    case '>': {
                        if (j2 + 4 > m2) {
                            return XMLEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 38;
                        out[j2++] = 103;
                        out[j2++] = 116;
                        out[j2++] = 59;
                        break;
                    }
                    case '\'': {
                        if (j2 + 5 > m2) {
                            return XMLEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 38;
                        out[j2++] = 35;
                        out[j2++] = 51;
                        out[j2++] = 57;
                        out[j2++] = 59;
                        break;
                    }
                    case '\"': {
                        if (j2 + 5 > m2) {
                            return XMLEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 38;
                        out[j2++] = 35;
                        out[j2++] = 51;
                        out[j2++] = 52;
                        out[j2++] = 59;
                        break;
                    }
                    default: {
                        if (j2 >= m2) {
                            return XMLEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = 32;
                        break;
                    }
                }
                continue;
            }
            if (ch < '\ud800') {
                if (j2 >= m2) {
                    return XMLEncoder.overflow(input, i2, output, j2);
                }
                if (ch > '\u009f' || ch == '\u0085') {
                    out[j2++] = ch;
                    continue;
                }
                out[j2++] = 32;
                continue;
            }
            if (ch <= '\udbff') {
                if (i2 + 1 < n2) {
                    if (Character.isLowSurrogate(in[i2 + 1])) {
                        int cp = Character.toCodePoint(ch, in[i2 + 1]);
                        if (Unicode.isNonCharacter(cp)) {
                            if (j2 >= m2) {
                                return XMLEncoder.overflow(input, i2, output, j2);
                            }
                            out[j2++] = 32;
                            ++i2;
                            continue;
                        }
                        if (j2 + 1 >= m2) {
                            return XMLEncoder.overflow(input, i2, output, j2);
                        }
                        out[j2++] = ch;
                        out[j2++] = in[++i2];
                        continue;
                    }
                    if (j2 >= m2) {
                        return XMLEncoder.overflow(input, i2, output, j2);
                    }
                    out[j2++] = 32;
                    continue;
                }
                if (!endOfInput) break;
                if (j2 >= m2) {
                    return XMLEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 32;
                continue;
            }
            if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                if (j2 >= m2) {
                    return XMLEncoder.overflow(input, i2, output, j2);
                }
                out[j2++] = 32;
                continue;
            }
            if (j2 >= m2) {
                return XMLEncoder.overflow(input, i2, output, j2);
            }
            out[j2++] = ch;
        }
        return XMLEncoder.underflow(input, i2, output, j2);
    }

    public String toString() {
        return "XMLEncoder(" + (Object)((Object)this._mode) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        ALL("&<>'\""),
        CONTENT("&<>"),
        ATTRIBUTE("&<'\""),
        SINGLE_QUOTED_ATTRIBUTE("&<'"),
        DOUBLE_QUOTED_ATTRIBUTE("&<\"");

        private final long _validMask;

        private Mode(String encodedChars) {
            long encodeMask = 0L;
            int n3 = encodedChars.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                encodeMask |= 1L << encodedChars.charAt(i2);
            }
            this._validMask = 0x2600L | 0xFFFFFFFF00000000L & (encodeMask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        long validMask() {
            return this._validMask;
        }
    }
}

