/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

public final class Bits {
    private Bits() {
    }

    public static int intBitMask(int low, int high) {
        assert (low >= 0);
        assert (low <= high);
        assert (high < 32);
        return (high == 31 ? 0 : 1 << high + 1) - (1 << low);
    }

    public static long longBitMask(int low, int high) {
        assert (low >= 0);
        assert (low <= high);
        assert (high < 64);
        return (high == 63 ? 0L : 1L << (int)((long)high + 1L)) - (1L << (int)((long)low));
    }

    public static boolean anyAreSet(int var, int flags) {
        return (var & flags) != 0;
    }

    public static boolean allAreSet(int var, int flags) {
        return (var & flags) == flags;
    }

    public static boolean anyAreClear(int var, int flags) {
        return (var & flags) != flags;
    }

    public static boolean allAreClear(int var, int flags) {
        return (var & flags) == 0;
    }

    public static boolean anyAreSet(long var, long flags) {
        return (var & flags) != 0L;
    }

    public static boolean allAreSet(long var, long flags) {
        return (var & flags) == flags;
    }

    public static boolean anyAreClear(long var, long flags) {
        return (var & flags) != flags;
    }

    public static boolean allAreClear(long var, long flags) {
        return (var & flags) == 0L;
    }

    public static int unsigned(byte v) {
        return v & 0xFF;
    }

    public static int unsigned(short v) {
        return v & 0xFFFF;
    }

    public static long unsigned(int v) {
        return (long)v & 0xFFFFFFFFL;
    }

    public static short shortFromBytesLE(byte[] b2, int off) {
        return (short)(b2[off + 1] << 8 | b2[off] & 0xFF);
    }

    public static short shortFromBytesBE(byte[] b2, int off) {
        return (short)(b2[off] << 8 | b2[off + 1] & 0xFF);
    }

    public static char charFromBytesLE(byte[] b2, int off) {
        return (char)(b2[off + 1] << 8 | b2[off] & 0xFF);
    }

    public static char charFromBytesBE(byte[] b2, int off) {
        return (char)(b2[off] << 8 | b2[off + 1] & 0xFF);
    }

    public static int mediumFromBytesLE(byte[] b2, int off) {
        return (b2[off + 2] & 0xFF) << 16 | (b2[off + 1] & 0xFF) << 8 | b2[off] & 0xFF;
    }

    public static int mediumFromBytesBE(byte[] b2, int off) {
        return (b2[off] & 0xFF) << 16 | (b2[off + 1] & 0xFF) << 8 | b2[off + 2] & 0xFF;
    }

    public static int intFromBytesLE(byte[] b2, int off) {
        return b2[off + 3] << 24 | (b2[off + 2] & 0xFF) << 16 | (b2[off + 1] & 0xFF) << 8 | b2[off] & 0xFF;
    }

    public static int intFromBytesBE(byte[] b2, int off) {
        return b2[off] << 24 | (b2[off + 1] & 0xFF) << 16 | (b2[off + 2] & 0xFF) << 8 | b2[off + 3] & 0xFF;
    }

    public static long longFromBytesLE(byte[] b2, int off) {
        return ((long)b2[off + 7] & 0xFFL) << 56 | ((long)b2[off + 6] & 0xFFL) << 48 | ((long)b2[off + 5] & 0xFFL) << 40 | ((long)b2[off + 4] & 0xFFL) << 32 | ((long)b2[off + 3] & 0xFFL) << 24 | ((long)b2[off + 2] & 0xFFL) << 16 | ((long)b2[off + 1] & 0xFFL) << 8 | (long)b2[off] & 0xFFL;
    }

    public static long longFromBytesBE(byte[] b2, int off) {
        return ((long)b2[off] & 0xFFL) << 56 | ((long)b2[off + 1] & 0xFFL) << 48 | ((long)b2[off + 2] & 0xFFL) << 40 | ((long)b2[off + 3] & 0xFFL) << 32 | ((long)b2[off + 4] & 0xFFL) << 24 | ((long)b2[off + 5] & 0xFFL) << 16 | ((long)b2[off + 6] & 0xFFL) << 8 | (long)b2[off + 7] & 0xFFL;
    }
}

