/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ChannelPipe;
import org.xnio.CompressionType;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.LocalSocketAddress;
import org.xnio.MessageConnection;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoFactory;
import org.xnio.XnioIoThread;
import org.xnio._private.Messages;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.AssembledConnectedMessageChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.ReadableMessageChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WritableMessageChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.DeflatingStreamSinkConduit;
import org.xnio.conduits.InflatingStreamSourceConduit;
import org.xnio.conduits.StreamSinkChannelWrappingConduit;
import org.xnio.conduits.StreamSourceChannelWrappingConduit;

public abstract class XnioWorker
extends AbstractExecutorService
implements Configurable,
ExecutorService,
XnioIoFactory {
    private final Xnio xnio;
    private final TaskPool taskPool;
    private final String name;
    private final Runnable terminationTask;
    private volatile int taskSeq;
    private volatile int coreSize;
    private static final AtomicIntegerFieldUpdater<XnioWorker> taskSeqUpdater = AtomicIntegerFieldUpdater.newUpdater(XnioWorker.class, "taskSeq");
    private static final AtomicIntegerFieldUpdater<XnioWorker> coreSizeUpdater = AtomicIntegerFieldUpdater.newUpdater(XnioWorker.class, "coreSize");
    private static final AtomicInteger seq = new AtomicInteger(1);
    private static final RuntimePermission CREATE_WORKER_PERMISSION = new RuntimePermission("createXnioWorker");
    private final BlockingQueue<Runnable> taskQueue;
    private static Set<Option<?>> OPTIONS = Option.setBuilder().add((Option<?>)Options.WORKER_TASK_CORE_THREADS).add((Option<?>)Options.WORKER_TASK_MAX_THREADS).add((Option<?>)Options.WORKER_TASK_KEEPALIVE).create();
    private static final IoFuture.HandlingNotifier<StreamConnection, FutureResult<ConnectedStreamChannel>> STREAM_WRAPPING_HANDLER = new IoFuture.HandlingNotifier<StreamConnection, FutureResult<ConnectedStreamChannel>>(){

        @Override
        public void handleCancelled(FutureResult<ConnectedStreamChannel> attachment) {
            attachment.setCancelled();
        }

        @Override
        public void handleFailed(IOException exception, FutureResult<ConnectedStreamChannel> attachment) {
            attachment.setException(exception);
        }
    };
    private static final IoFuture.HandlingNotifier<MessageConnection, FutureResult<ConnectedMessageChannel>> MESSAGE_WRAPPING_HANDLER = new IoFuture.HandlingNotifier<MessageConnection, FutureResult<ConnectedMessageChannel>>(){

        @Override
        public void handleCancelled(FutureResult<ConnectedMessageChannel> attachment) {
            attachment.setCancelled();
        }

        @Override
        public void handleFailed(IOException exception, FutureResult<ConnectedMessageChannel> attachment) {
            attachment.setException(exception);
        }
    };

    private int getNextSeq() {
        return taskSeqUpdater.incrementAndGet(this);
    }

    protected XnioWorker(Xnio xnio, ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) {
        String workerName;
        this.xnio = xnio;
        this.terminationTask = terminationTask;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_WORKER_PERMISSION);
        }
        if ((workerName = optionMap.get(Options.WORKER_NAME)) == null) {
            workerName = "XNIO-" + seq.getAndIncrement();
        }
        this.name = workerName;
        this.taskQueue = new LinkedBlockingQueue<Runnable>();
        this.coreSize = optionMap.get(Options.WORKER_TASK_CORE_THREADS, 4);
        boolean markThreadAsDaemon = optionMap.get(Options.THREAD_DAEMON, false);
        int threadCount = optionMap.get(Options.WORKER_TASK_MAX_THREADS, 16);
        this.taskPool = new TaskPool(threadCount, threadCount, optionMap.get(Options.WORKER_TASK_KEEPALIVE, 60000), TimeUnit.MILLISECONDS, this.taskQueue, new WorkerThreadFactory(threadGroup, optionMap, markThreadAsDaemon), new ThreadPoolExecutor.AbortPolicy());
    }

    @Deprecated
    public AcceptingChannel<? extends ConnectedStreamChannel> createStreamServer(SocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        final AcceptingChannel<StreamConnection> server = this.createStreamConnectionServer(bindAddress, null, optionMap);
        AcceptingChannel<ConnectedStreamChannel> acceptingChannel = new AcceptingChannel<ConnectedStreamChannel>(){

            @Override
            public ConnectedStreamChannel accept() throws IOException {
                StreamConnection connection = (StreamConnection)server.accept();
                return connection == null ? null : new AssembledConnectedStreamChannel(connection, (StreamSourceChannel)connection.getSourceChannel(), (StreamSinkChannel)connection.getSinkChannel());
            }

            @Override
            public ChannelListener.Setter<? extends AcceptingChannel<ConnectedStreamChannel>> getAcceptSetter() {
                return ChannelListeners.getDelegatingSetter(server.getAcceptSetter(), this);
            }

            @Override
            public ChannelListener.Setter<? extends AcceptingChannel<ConnectedStreamChannel>> getCloseSetter() {
                return ChannelListeners.getDelegatingSetter(server.getCloseSetter(), this);
            }

            @Override
            public SocketAddress getLocalAddress() {
                return server.getLocalAddress();
            }

            @Override
            public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                return server.getLocalAddress(type);
            }

            @Override
            public void suspendAccepts() {
                server.suspendAccepts();
            }

            @Override
            public void resumeAccepts() {
                server.resumeAccepts();
            }

            @Override
            public boolean isAcceptResumed() {
                return server.isAcceptResumed();
            }

            @Override
            public void wakeupAccepts() {
                server.wakeupAccepts();
            }

            @Override
            public void awaitAcceptable() throws IOException {
                server.awaitAcceptable();
            }

            @Override
            public void awaitAcceptable(long time, TimeUnit timeUnit) throws IOException {
                server.awaitAcceptable(time, timeUnit);
            }

            @Override
            public XnioWorker getWorker() {
                return server.getWorker();
            }

            @Override
            @Deprecated
            public XnioExecutor getAcceptThread() {
                return server.getAcceptThread();
            }

            @Override
            public XnioIoThread getIoThread() {
                return server.getIoThread();
            }

            @Override
            public void close() throws IOException {
                server.close();
            }

            @Override
            public boolean isOpen() {
                return server.isOpen();
            }

            @Override
            public boolean supportsOption(Option<?> option) {
                return server.supportsOption(option);
            }

            @Override
            public <T> T getOption(Option<T> option) throws IOException {
                return server.getOption(option);
            }

            @Override
            public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                return server.setOption(option, value);
            }
        };
        acceptingChannel.getAcceptSetter().set(acceptListener);
        return acceptingChannel;
    }

    public AcceptingChannel<StreamConnection> createStreamConnectionServer(SocketAddress bindAddress, ChannelListener<? super AcceptingChannel<StreamConnection>> acceptListener, OptionMap optionMap) throws IOException {
        if (bindAddress == null) {
            throw Messages.msg.nullParameter("bindAddress");
        }
        if (bindAddress instanceof InetSocketAddress) {
            return this.createTcpConnectionServer((InetSocketAddress)bindAddress, acceptListener, optionMap);
        }
        if (bindAddress instanceof LocalSocketAddress) {
            return this.createLocalStreamConnectionServer((LocalSocketAddress)bindAddress, acceptListener, optionMap);
        }
        throw Messages.msg.badSockType(bindAddress.getClass());
    }

    protected AcceptingChannel<StreamConnection> createTcpConnectionServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<StreamConnection>> acceptListener, OptionMap optionMap) throws IOException {
        throw Messages.msg.unsupported("createTcpConnectionServer");
    }

    protected AcceptingChannel<StreamConnection> createLocalStreamConnectionServer(LocalSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<StreamConnection>> acceptListener, OptionMap optionMap) throws IOException {
        throw Messages.msg.unsupported("createLocalStreamConnectionServer");
    }

    @Deprecated
    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, OptionMap optionMap) {
        FutureResult<ConnectedStreamChannel> futureResult = new FutureResult<ConnectedStreamChannel>();
        StreamConnectionWrapListener nestedOpenListener = new StreamConnectionWrapListener(futureResult, openListener);
        IoFuture<StreamConnection> future = this.openStreamConnection(destination, nestedOpenListener, optionMap);
        future.addNotifier(STREAM_WRAPPING_HANDLER, futureResult);
        futureResult.addCancelHandler(future);
        return futureResult.getIoFuture();
    }

    @Deprecated
    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult<ConnectedStreamChannel> futureResult = new FutureResult<ConnectedStreamChannel>();
        StreamConnectionWrapListener nestedOpenListener = new StreamConnectionWrapListener(futureResult, openListener);
        IoFuture<StreamConnection> future = this.openStreamConnection(destination, nestedOpenListener, bindListener, optionMap);
        future.addNotifier(STREAM_WRAPPING_HANDLER, futureResult);
        futureResult.addCancelHandler(future);
        return futureResult.getIoFuture();
    }

    @Deprecated
    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult<ConnectedStreamChannel> futureResult = new FutureResult<ConnectedStreamChannel>();
        StreamConnectionWrapListener nestedOpenListener = new StreamConnectionWrapListener(futureResult, openListener);
        IoFuture<StreamConnection> future = this.openStreamConnection(bindAddress, destination, nestedOpenListener, bindListener, optionMap);
        future.addNotifier(STREAM_WRAPPING_HANDLER, futureResult);
        futureResult.addCancelHandler(future);
        return futureResult.getIoFuture();
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, OptionMap optionMap) {
        return this.chooseThread().openStreamConnection(destination, openListener, optionMap);
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        return this.chooseThread().openStreamConnection(destination, openListener, bindListener, optionMap);
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        return this.chooseThread().openStreamConnection(bindAddress, destination, openListener, bindListener, optionMap);
    }

    @Deprecated
    public IoFuture<ConnectedStreamChannel> acceptStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult<ConnectedStreamChannel> futureResult = new FutureResult<ConnectedStreamChannel>();
        StreamConnectionWrapListener nestedOpenListener = new StreamConnectionWrapListener(futureResult, openListener);
        IoFuture<StreamConnection> future = this.acceptStreamConnection(destination, nestedOpenListener, bindListener, optionMap);
        future.addNotifier(STREAM_WRAPPING_HANDLER, futureResult);
        futureResult.addCancelHandler(future);
        return futureResult.getIoFuture();
    }

    @Override
    public IoFuture<StreamConnection> acceptStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        return this.chooseThread().acceptStreamConnection(destination, openListener, bindListener, optionMap);
    }

    @Deprecated
    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult<ConnectedMessageChannel> futureResult = new FutureResult<ConnectedMessageChannel>();
        MessageConnectionWrapListener nestedOpenListener = new MessageConnectionWrapListener(futureResult, openListener);
        IoFuture<MessageConnection> future = this.openMessageConnection(destination, nestedOpenListener, optionMap);
        future.addNotifier(MESSAGE_WRAPPING_HANDLER, futureResult);
        futureResult.addCancelHandler(future);
        return futureResult.getIoFuture();
    }

    @Deprecated
    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult<ConnectedMessageChannel> futureResult = new FutureResult<ConnectedMessageChannel>();
        MessageConnectionWrapListener nestedOpenListener = new MessageConnectionWrapListener(futureResult, openListener);
        IoFuture<MessageConnection> future = this.openMessageConnection(destination, nestedOpenListener, optionMap);
        future.addNotifier(MESSAGE_WRAPPING_HANDLER, futureResult);
        futureResult.addCancelHandler(future);
        return futureResult.getIoFuture();
    }

    @Override
    public IoFuture<MessageConnection> openMessageConnection(SocketAddress destination, ChannelListener<? super MessageConnection> openListener, OptionMap optionMap) {
        return this.chooseThread().openMessageConnection(destination, openListener, optionMap);
    }

    @Deprecated
    public IoFuture<ConnectedMessageChannel> acceptDatagram(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult<ConnectedMessageChannel> futureResult = new FutureResult<ConnectedMessageChannel>();
        MessageConnectionWrapListener nestedOpenListener = new MessageConnectionWrapListener(futureResult, openListener);
        IoFuture<MessageConnection> future = this.acceptMessageConnection(destination, nestedOpenListener, bindListener, optionMap);
        future.addNotifier(MESSAGE_WRAPPING_HANDLER, futureResult);
        futureResult.addCancelHandler(future);
        return futureResult.getIoFuture();
    }

    @Override
    public IoFuture<MessageConnection> acceptMessageConnection(SocketAddress destination, ChannelListener<? super MessageConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        return this.chooseThread().acceptMessageConnection(destination, openListener, bindListener, optionMap);
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        throw Messages.msg.unsupported("createUdpServer");
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, ChannelListeners.nullChannelListener(), optionMap);
    }

    @Deprecated
    public void createPipe(ChannelListener<? super StreamChannel> leftOpenListener, ChannelListener<? super StreamChannel> rightOpenListener, OptionMap optionMap) throws IOException {
        ChannelPipe<StreamChannel, StreamChannel> pipe = this.createFullDuplexPipe();
        boolean establishWriting = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false);
        StreamChannel left = pipe.getLeftSide();
        XnioExecutor leftExec = establishWriting ? left.getWriteThread() : left.getReadThread();
        StreamChannel right = pipe.getRightSide();
        XnioExecutor rightExec = establishWriting ? right.getWriteThread() : right.getReadThread();
        leftExec.execute(ChannelListeners.getChannelListenerTask(left, leftOpenListener));
        rightExec.execute(ChannelListeners.getChannelListenerTask(right, rightOpenListener));
    }

    @Deprecated
    public void createOneWayPipe(ChannelListener<? super StreamSourceChannel> sourceListener, ChannelListener<? super StreamSinkChannel> sinkListener, OptionMap optionMap) throws IOException {
        ChannelPipe<StreamSourceChannel, StreamSinkChannel> pipe = this.createHalfDuplexPipe();
        StreamSourceChannel left = pipe.getLeftSide();
        XnioExecutor leftExec = left.getReadThread();
        StreamSinkChannel right = pipe.getRightSide();
        XnioExecutor rightExec = right.getWriteThread();
        leftExec.execute(ChannelListeners.getChannelListenerTask(left, sourceListener));
        rightExec.execute(ChannelListeners.getChannelListenerTask(right, sinkListener));
    }

    public StreamSourceChannel getInflatingChannel(StreamSourceChannel delegate, OptionMap options) throws IOException {
        boolean nowrap;
        switch (options.get(Options.COMPRESSION_TYPE, CompressionType.DEFLATE)) {
            case DEFLATE: {
                nowrap = false;
                break;
            }
            case GZIP: {
                nowrap = true;
                break;
            }
            default: {
                throw Messages.msg.badCompressionFormat();
            }
        }
        return this.getInflatingChannel(delegate, new Inflater(nowrap));
    }

    protected StreamSourceChannel getInflatingChannel(StreamSourceChannel delegate, Inflater inflater) throws IOException {
        return new ConduitStreamSourceChannel(Configurable.EMPTY, new InflatingStreamSourceConduit(new StreamSourceChannelWrappingConduit(delegate), inflater));
    }

    public StreamSinkChannel getDeflatingChannel(StreamSinkChannel delegate, OptionMap options) throws IOException {
        boolean nowrap;
        int level = options.get(Options.COMPRESSION_LEVEL, -1);
        switch (options.get(Options.COMPRESSION_TYPE, CompressionType.DEFLATE)) {
            case DEFLATE: {
                nowrap = false;
                break;
            }
            case GZIP: {
                nowrap = true;
                break;
            }
            default: {
                throw Messages.msg.badCompressionFormat();
            }
        }
        return this.getDeflatingChannel(delegate, new Deflater(level, nowrap));
    }

    protected StreamSinkChannel getDeflatingChannel(StreamSinkChannel delegate, Deflater deflater) throws IOException {
        return new ConduitStreamSinkChannel(Configurable.EMPTY, new DeflatingStreamSinkConduit(new StreamSinkChannelWrappingConduit(delegate), deflater));
    }

    @Override
    public ChannelPipe<StreamChannel, StreamChannel> createFullDuplexPipe() throws IOException {
        return this.chooseThread().createFullDuplexPipe();
    }

    @Override
    public ChannelPipe<StreamConnection, StreamConnection> createFullDuplexPipeConnection() throws IOException {
        return this.chooseThread().createFullDuplexPipeConnection();
    }

    @Override
    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe() throws IOException {
        return this.chooseThread().createHalfDuplexPipe();
    }

    @Override
    public ChannelPipe<StreamConnection, StreamConnection> createFullDuplexPipeConnection(XnioIoFactory peer) throws IOException {
        return this.chooseThread().createFullDuplexPipeConnection(peer);
    }

    @Override
    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe(XnioIoFactory peer) throws IOException {
        return this.chooseThread().createHalfDuplexPipe(peer);
    }

    @Override
    public abstract void shutdown();

    @Override
    public abstract List<Runnable> shutdownNow();

    @Override
    public abstract boolean isShutdown();

    @Override
    public abstract boolean isTerminated();

    @Override
    public abstract boolean awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    public abstract void awaitTermination() throws InterruptedException;

    public final XnioIoThread getIoThread() {
        return this.chooseThread();
    }

    public abstract XnioIoThread getIoThread(int var1);

    protected Runnable getTerminationTask() {
        return this.terminationTask;
    }

    protected void taskPoolTerminated() {
    }

    protected void shutDownTaskPool() {
        this.taskPool.shutdown();
    }

    protected List<Runnable> shutDownTaskPoolNow() {
        return this.taskPool.shutdownNow();
    }

    @Override
    public void execute(Runnable command) {
        this.taskPool.execute(command);
    }

    public abstract int getIoThreadCount();

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option.equals(Options.WORKER_TASK_CORE_THREADS)) {
            return option.cast(this.coreSize);
        }
        if (option.equals(Options.WORKER_TASK_MAX_THREADS)) {
            return option.cast(this.taskPool.getMaximumPoolSize());
        }
        if (option.equals(Options.WORKER_TASK_KEEPALIVE)) {
            return option.cast((int)Math.min(Integer.MAX_VALUE, this.taskPool.getKeepAliveTime(TimeUnit.MILLISECONDS)));
        }
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option.equals(Options.WORKER_TASK_CORE_THREADS)) {
            return option.cast(coreSizeUpdater.getAndSet(this, Options.WORKER_TASK_CORE_THREADS.cast(value)));
        }
        if (option.equals(Options.WORKER_TASK_MAX_THREADS)) {
            int old = this.taskPool.getMaximumPoolSize();
            this.taskPool.setCorePoolSize(Options.WORKER_TASK_MAX_THREADS.cast(value));
            this.taskPool.setMaximumPoolSize(Options.WORKER_TASK_MAX_THREADS.cast(value));
            return option.cast(old);
        }
        if (option.equals(Options.WORKER_TASK_KEEPALIVE)) {
            long old = this.taskPool.getKeepAliveTime(TimeUnit.MILLISECONDS);
            this.taskPool.setKeepAliveTime(Options.WORKER_TASK_KEEPALIVE.cast(value).intValue(), TimeUnit.MILLISECONDS);
            return option.cast((int)Math.min(Integer.MAX_VALUE, old));
        }
        return null;
    }

    public Xnio getXnio() {
        return this.xnio;
    }

    public String getName() {
        return this.name;
    }

    protected abstract XnioIoThread chooseThread();

    protected final int getCoreWorkerPoolSize() {
        return this.coreSize;
    }

    protected final int getMaxWorkerPoolSize() {
        return this.taskPool.getMaximumPoolSize();
    }

    protected final int getWorkerQueueSize() {
        return this.taskQueue.size();
    }

    class WorkerThreadFactory
    implements ThreadFactory {
        private final ThreadGroup threadGroup;
        private final OptionMap optionMap;
        private final boolean markThreadAsDaemon;

        WorkerThreadFactory(ThreadGroup threadGroup, OptionMap optionMap, boolean markThreadAsDaemon) {
            this.threadGroup = threadGroup;
            this.optionMap = optionMap;
            this.markThreadAsDaemon = markThreadAsDaemon;
        }

        @Override
        public Thread newThread(final Runnable r2) {
            return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    Thread taskThread = new Thread(WorkerThreadFactory.this.threadGroup, r2, XnioWorker.this.name + " task-" + XnioWorker.this.getNextSeq(), WorkerThreadFactory.this.optionMap.get(Options.STACK_SIZE, 0L));
                    if (WorkerThreadFactory.this.markThreadAsDaemon) {
                        taskThread.setDaemon(true);
                    }
                    return taskThread;
                }
            });
        }
    }

    static class MessageConnectionWrapListener
    implements ChannelListener<MessageConnection> {
        private final FutureResult<ConnectedMessageChannel> futureResult;
        private final ChannelListener<? super ConnectedMessageChannel> openListener;

        public MessageConnectionWrapListener(FutureResult<ConnectedMessageChannel> futureResult, ChannelListener<? super ConnectedMessageChannel> openListener) {
            this.futureResult = futureResult;
            this.openListener = openListener;
        }

        @Override
        public void handleEvent(MessageConnection channel) {
            AssembledConnectedMessageChannel assembledChannel = new AssembledConnectedMessageChannel(channel, (ReadableMessageChannel)channel.getSourceChannel(), (WritableMessageChannel)channel.getSinkChannel());
            if (!this.futureResult.setResult(assembledChannel)) {
                IoUtils.safeClose((Closeable)assembledChannel);
            } else {
                ChannelListeners.invokeChannelListener(assembledChannel, this.openListener);
            }
        }
    }

    static class StreamConnectionWrapListener
    implements ChannelListener<StreamConnection> {
        private final FutureResult<ConnectedStreamChannel> futureResult;
        private final ChannelListener<? super ConnectedStreamChannel> openListener;

        public StreamConnectionWrapListener(FutureResult<ConnectedStreamChannel> futureResult, ChannelListener<? super ConnectedStreamChannel> openListener) {
            this.futureResult = futureResult;
            this.openListener = openListener;
        }

        @Override
        public void handleEvent(StreamConnection channel) {
            AssembledConnectedStreamChannel assembledChannel = new AssembledConnectedStreamChannel(channel, (StreamSourceChannel)channel.getSourceChannel(), (StreamSinkChannel)channel.getSinkChannel());
            if (!this.futureResult.setResult(assembledChannel)) {
                IoUtils.safeClose((Closeable)assembledChannel);
            } else {
                ChannelListeners.invokeChannelListener(assembledChannel, this.openListener);
            }
        }
    }

    final class TaskPool
    extends ThreadPoolExecutor {
        TaskPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        @Override
        protected void terminated() {
            XnioWorker.this.taskPoolTerminated();
        }
    }
}

