/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.Pooled;
import org.xnio._private.Messages;
import org.xnio.conduits.AbstractSourceConduit;
import org.xnio.conduits.MessageSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class FramingMessageSourceConduit
extends AbstractSourceConduit<StreamSourceConduit>
implements MessageSourceConduit {
    private final Pooled<ByteBuffer> receiveBuffer;
    private boolean ready;

    public FramingMessageSourceConduit(StreamSourceConduit next, Pooled<ByteBuffer> receiveBuffer) {
        super(next);
        this.receiveBuffer = receiveBuffer;
    }

    @Override
    public void resumeReads() {
        if (this.ready) {
            ((StreamSourceConduit)this.next).wakeupReads();
        } else {
            ((StreamSourceConduit)this.next).resumeReads();
        }
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (!this.ready) {
            ((StreamSourceConduit)this.next).awaitReadable(time, timeUnit);
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        if (!this.ready) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
    }

    @Override
    public void terminateReads() throws IOException {
        this.receiveBuffer.free();
        ((StreamSourceConduit)this.next).terminateReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int receive(ByteBuffer dst) throws IOException {
        int res;
        ByteBuffer receiveBuffer = this.receiveBuffer.getResource();
        while ((res = ((StreamSourceConduit)this.next).read(receiveBuffer)) > 0) {
        }
        if (receiveBuffer.position() < 4) {
            if (res == -1) {
                receiveBuffer.clear();
            }
            this.ready = false;
            return res;
        }
        receiveBuffer.flip();
        try {
            int length = receiveBuffer.getInt();
            if (length < 0 || length > receiveBuffer.capacity() - 4) {
                Buffers.unget(receiveBuffer, 4);
                throw Messages.msg.recvInvalidMsgLength(length);
            }
            if (receiveBuffer.remaining() < length) {
                if (res == -1) {
                    receiveBuffer.clear();
                } else {
                    Buffers.unget(receiveBuffer, 4);
                }
                this.ready = false;
                int n2 = res;
                return n2;
            }
            if (dst.hasRemaining()) {
                int n3 = Buffers.copy(length, dst, receiveBuffer);
                return n3;
            }
            Buffers.skip(receiveBuffer, length);
            int n4 = 0;
            return n4;
        }
        finally {
            if (res != -1) {
                receiveBuffer.compact();
                if (receiveBuffer.position() >= 4 && receiveBuffer.position() >= 4 + receiveBuffer.getInt(0)) {
                    this.ready = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long receive(ByteBuffer[] dsts, int offs, int len) throws IOException {
        int res;
        ByteBuffer receiveBuffer = this.receiveBuffer.getResource();
        while ((res = ((StreamSourceConduit)this.next).read(receiveBuffer)) > 0) {
        }
        if (receiveBuffer.position() < 4) {
            if (res == -1) {
                receiveBuffer.clear();
            }
            this.ready = false;
            return res;
        }
        receiveBuffer.flip();
        try {
            int length = receiveBuffer.getInt();
            if (length < 0 || length > receiveBuffer.capacity() - 4) {
                Buffers.unget(receiveBuffer, 4);
                throw Messages.msg.recvInvalidMsgLength(length);
            }
            if (receiveBuffer.remaining() < length) {
                if (res == -1) {
                    receiveBuffer.clear();
                } else {
                    Buffers.unget(receiveBuffer, 4);
                }
                this.ready = false;
                long l2 = res;
                return l2;
            }
            if (Buffers.hasRemaining(dsts, offs, len)) {
                long l3 = Buffers.copy(length, dsts, offs, len, receiveBuffer);
                return l3;
            }
            Buffers.skip(receiveBuffer, length);
            long l4 = 0L;
            return l4;
        }
        finally {
            if (res != -1) {
                receiveBuffer.compact();
                if (receiveBuffer.position() >= 4 && receiveBuffer.position() >= 4 + receiveBuffer.getInt(0)) {
                    this.ready = true;
                }
            }
        }
    }
}

