/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.Xnio;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WriteTimeoutException;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioSocketStreamConnection;
import org.xnio.nio.NioXnio;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

final class NioSocketConduit
extends NioHandle
implements StreamSourceConduit,
StreamSinkConduit {
    private final SocketChannel socketChannel;
    private final NioSocketStreamConnection connection;
    private ReadReadyHandler readReadyHandler;
    private WriteReadyHandler writeReadyHandler;
    private volatile int readTimeout;
    private long lastRead;
    private static final AtomicIntegerFieldUpdater<NioSocketConduit> readTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(NioSocketConduit.class, "readTimeout");
    private volatile int writeTimeout;
    private long lastWrite;
    private static final AtomicIntegerFieldUpdater<NioSocketConduit> writeTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(NioSocketConduit.class, "writeTimeout");

    NioSocketConduit(WorkerThread workerThread, SelectionKey selectionKey, NioSocketStreamConnection connection) {
        super(workerThread, selectionKey);
        this.connection = connection;
        this.socketChannel = (SocketChannel)selectionKey.channel();
    }

    @Override
    void handleReady(int ops) {
        try {
            if (ops == 0) {
                SelectionKey key = this.getSelectionKey();
                int interestOps = key.interestOps();
                if (interestOps != 0) {
                    ops = interestOps;
                } else {
                    this.forceTermination();
                    return;
                }
            }
            if (Bits.allAreSet(ops, 1)) {
                try {
                    if (this.isReadShutdown()) {
                        this.suspendReads();
                    }
                    this.readReadyHandler.readReady();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (Bits.allAreSet(ops, 4)) {
                try {
                    if (this.isWriteShutdown()) {
                        this.suspendWrites();
                    }
                    this.writeReadyHandler.writeReady();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public XnioWorker getWorker() {
        return this.getWorkerThread().getWorker();
    }

    @Override
    void forceTermination() {
        WriteReadyHandler write;
        ReadReadyHandler read = this.readReadyHandler;
        if (read != null) {
            read.forceTermination();
        }
        if ((write = this.writeReadyHandler) != null) {
            write.forceTermination();
        }
    }

    @Override
    void terminated() {
        WriteReadyHandler write;
        ReadReadyHandler read = this.readReadyHandler;
        if (read != null) {
            read.terminated();
        }
        if ((write = this.writeReadyHandler) != null) {
            write.terminated();
        }
    }

    int getAndSetWriteTimeout(int newVal) {
        return writeTimeoutUpdater.getAndSet(this, newVal);
    }

    int getWriteTimeout() {
        return this.writeTimeout;
    }

    private void checkWriteTimeout(boolean xfer) throws WriteTimeoutException {
        int timeout = this.writeTimeout;
        if (timeout > 0) {
            if (xfer) {
                this.lastWrite = System.nanoTime();
            } else {
                long lastRead = this.lastWrite;
                if (lastRead > 0L && (System.nanoTime() - lastRead) / 1000000L > (long)timeout) {
                    throw Log.log.writeTimeout();
                }
            }
        }
    }

    @Override
    public final long transferFrom(FileChannel src, long position, long count) throws IOException {
        try {
            long res = src.transferTo(position, count, this.socketChannel);
            this.checkWriteTimeout(res > 0L);
            return res;
        }
        catch (IOException e2) {
            try {
                this.socketChannel.shutdownOutput();
            }
            catch (IOException second) {
                second.addSuppressed(e2);
                throw second;
            }
            throw e2;
        }
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return Conduits.transfer(source, count, throughBuffer, this);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        try {
            int res = this.socketChannel.write(src);
            this.checkWriteTimeout(res > 0);
            return res;
        }
        catch (IOException e2) {
            try {
                this.socketChannel.shutdownOutput();
            }
            catch (IOException second) {
                second.addSuppressed(e2);
                throw second;
            }
            throw e2;
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 1) {
            return this.write(srcs[offset]);
        }
        try {
            long res = this.socketChannel.write(srcs, offset, length);
            this.checkWriteTimeout(res > 0L);
            return res;
        }
        catch (IOException e2) {
            try {
                this.socketChannel.shutdownOutput();
            }
            catch (IOException second) {
                second.addSuppressed(e2);
                throw second;
            }
            throw e2;
        }
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public boolean flush() throws IOException {
        return true;
    }

    @Override
    public void terminateWrites() throws IOException {
        if (this.connection.writeClosed()) {
            try {
                if (this.getSelectionKey().isValid()) {
                    this.suspend(4);
                }
                if (this.socketChannel.isOpen()) {
                    this.socketChannel.socket().shutdownOutput();
                }
            }
            catch (ClosedChannelException closedChannelException) {
            }
            finally {
                this.writeTerminated();
            }
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        this.terminateWrites();
    }

    void writeTerminated() {
        WriteReadyHandler writeReadyHandler = this.writeReadyHandler;
        if (writeReadyHandler != null) {
            try {
                writeReadyHandler.terminated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isWriteShutdown() {
        return this.connection.isWriteShutdown();
    }

    @Override
    public void resumeWrites() {
        this.resume(4);
    }

    @Override
    public void suspendWrites() {
        this.suspend(4);
    }

    @Override
    public void wakeupWrites() {
        this.wakeup(4);
    }

    @Override
    public boolean isWriteResumed() {
        return this.isResumed(4);
    }

    @Override
    public void awaitWritable() throws IOException {
        Xnio.checkBlockingAllowed();
        if (this.isWriteShutdown()) {
            return;
        }
        SelectorUtils.await((NioXnio)this.getWorker().getXnio(), this.socketChannel, 4);
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        Xnio.checkBlockingAllowed();
        if (this.isWriteShutdown()) {
            return;
        }
        SelectorUtils.await((NioXnio)this.getWorker().getXnio(), this.socketChannel, 4, time, timeUnit);
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.getWorkerThread();
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
    }

    int getAndSetReadTimeout(int newVal) {
        return readTimeoutUpdater.getAndSet(this, newVal);
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    private void checkReadTimeout(boolean xfer) throws ReadTimeoutException {
        int timeout = this.readTimeout;
        if (timeout > 0) {
            if (xfer) {
                this.lastRead = System.nanoTime();
            } else {
                long lastRead = this.lastRead;
                if (lastRead > 0L && (System.nanoTime() - lastRead) / 1000000L > (long)timeout) {
                    throw Log.log.readTimeout();
                }
            }
        }
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long res = target.transferFrom(this.socketChannel, position, count);
        this.checkReadTimeout(res > 0L);
        return res;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return Conduits.transfer(this, count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        try {
            res = this.socketChannel.read(dst);
        }
        catch (ClosedChannelException e2) {
            return -1;
        }
        if (res != -1) {
            this.checkReadTimeout(res > 0);
        } else {
            this.terminateReads();
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res;
        if (length == 1) {
            return this.read(dsts[offset]);
        }
        try {
            res = this.socketChannel.read(dsts, offset, length);
        }
        catch (ClosedChannelException e2) {
            return -1L;
        }
        if (res != -1L) {
            this.checkReadTimeout(res > 0L);
        } else {
            this.terminateReads();
        }
        return res;
    }

    @Override
    public void terminateReads() throws IOException {
        if (this.connection.readClosed()) {
            try {
                if (this.getSelectionKey().isValid()) {
                    this.suspend(1);
                }
                if (this.socketChannel.isOpen()) {
                    this.socketChannel.socket().shutdownInput();
                }
            }
            catch (ClosedChannelException closedChannelException) {
            }
            finally {
                this.readTerminated();
            }
        }
    }

    void readTerminated() {
        ReadReadyHandler readReadyHandler = this.readReadyHandler;
        if (readReadyHandler != null) {
            try {
                readReadyHandler.terminated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isReadShutdown() {
        return this.connection.isReadShutdown();
    }

    @Override
    public void resumeReads() {
        this.resume(1);
    }

    @Override
    public void suspendReads() {
        this.suspend(1);
    }

    @Override
    public void wakeupReads() {
        this.wakeup(1);
    }

    @Override
    public boolean isReadResumed() {
        return this.isResumed(1);
    }

    @Override
    public void awaitReadable() throws IOException {
        Xnio.checkBlockingAllowed();
        SelectorUtils.await((NioXnio)this.getWorker().getXnio(), this.socketChannel, 1);
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        Xnio.checkBlockingAllowed();
        SelectorUtils.await((NioXnio)this.getWorker().getXnio(), this.socketChannel, 1, time, timeUnit);
    }

    @Override
    public XnioIoThread getReadThread() {
        return this.getWorkerThread();
    }

    @Override
    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = handler;
    }

    SocketChannel getSocketChannel() {
        return this.socketChannel;
    }
}

