/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.Xnio;
import org.xnio._private.Messages;

public final class JsseSslUtils {
    private JsseSslUtils() {
    }

    public static SSLContext createSSLContext(OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        return JsseSslUtils.createSSLContext(null, null, null, optionMap);
    }

    public static SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom, OptionMap optionMap) throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        Sequence<Class<? extends TrustManager>> trustManagerClasses;
        int i2;
        int size;
        Sequence<Class<? extends KeyManager>> keyManagerClasses;
        String provider = optionMap.get(Options.SSL_PROVIDER);
        String protocol = optionMap.get(Options.SSL_PROTOCOL);
        if (protocol == null) {
            return SSLContext.getDefault();
        }
        SSLContext sslContext = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        if (keyManagers == null && (keyManagerClasses = optionMap.get(Options.SSL_JSSE_KEY_MANAGER_CLASSES)) != null) {
            size = keyManagerClasses.size();
            keyManagers = new KeyManager[size];
            for (i2 = 0; i2 < size; ++i2) {
                keyManagers[i2] = JsseSslUtils.instantiate(keyManagerClasses.get(i2));
            }
        }
        if (trustManagers == null && (trustManagerClasses = optionMap.get(Options.SSL_JSSE_TRUST_MANAGER_CLASSES)) != null) {
            size = trustManagerClasses.size();
            trustManagers = new TrustManager[size];
            for (i2 = 0; i2 < size; ++i2) {
                trustManagers[i2] = JsseSslUtils.instantiate(trustManagerClasses.get(i2));
            }
        }
        sslContext.init(keyManagers, trustManagers, secureRandom);
        sslContext.getClientSessionContext().setSessionCacheSize(optionMap.get(Options.SSL_CLIENT_SESSION_CACHE_SIZE, 0));
        sslContext.getClientSessionContext().setSessionTimeout(optionMap.get(Options.SSL_CLIENT_SESSION_TIMEOUT, 0));
        sslContext.getServerSessionContext().setSessionCacheSize(optionMap.get(Options.SSL_SERVER_SESSION_CACHE_SIZE, 0));
        sslContext.getServerSessionContext().setSessionTimeout(optionMap.get(Options.SSL_SERVER_SESSION_TIMEOUT, 0));
        return sslContext;
    }

    private static <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e2) {
            throw Messages.msg.cantInstantiate(clazz, e2);
        }
        catch (IllegalAccessException e3) {
            throw Messages.msg.cantInstantiate(clazz, e3);
        }
        catch (NoSuchMethodException e4) {
            throw Messages.msg.cantInstantiate(clazz, e4);
        }
        catch (InvocationTargetException e5) {
            throw Messages.msg.cantInstantiate(clazz, e5.getCause());
        }
    }

    public static SSLEngine createSSLEngine(SSLContext sslContext, OptionMap optionMap, InetSocketAddress peerAddress) {
        Sequence<String> protocols;
        SSLEngine engine = sslContext.createSSLEngine(optionMap.get(Options.SSL_PEER_HOST_NAME, JsseSslUtils.getHostNameNoResolve(peerAddress)), optionMap.get(Options.SSL_PEER_PORT, peerAddress.getPort()));
        engine.setUseClientMode(true);
        engine.setEnableSessionCreation(optionMap.get(Options.SSL_ENABLE_SESSION_CREATION, true));
        Sequence<String> cipherSuites = optionMap.get(Options.SSL_ENABLED_CIPHER_SUITES);
        if (cipherSuites != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : cipherSuites) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
        }
        if ((protocols = optionMap.get(Options.SSL_ENABLED_PROTOCOLS)) != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedProtocols()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : protocols) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledProtocols(finalList.toArray(new String[finalList.size()]));
        }
        return engine;
    }

    static String getHostNameNoResolve(InetSocketAddress socketAddress) {
        InetAddress address;
        String string;
        int slash;
        if (Xnio.NIO2) {
            return socketAddress.getHostString();
        }
        String hostName = socketAddress.isUnresolved() ? socketAddress.getHostName() : ((slash = (string = (address = socketAddress.getAddress()).toString()).indexOf(47)) == -1 || slash == 0 ? string.substring(slash + 1) : string.substring(0, slash));
        return hostName;
    }
}

