/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.streams;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.xnio._private.Messages;
import org.xnio.streams.Streams;

public final class WriterOutputStream
extends OutputStream {
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final ByteBuffer byteBuffer;
    private final char[] chars;
    private volatile boolean closed;

    public WriterOutputStream(Writer writer) {
        this(writer, Charset.defaultCharset());
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder) {
        this(writer, decoder, 1024);
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder, int bufferSize) {
        if (writer == null) {
            throw Messages.msg.nullParameter("writer");
        }
        if (decoder == null) {
            throw Messages.msg.nullParameter("decoder");
        }
        if (bufferSize < 1) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        this.writer = writer;
        this.decoder = decoder;
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        this.chars = new char[(int)((float)bufferSize * decoder.maxCharsPerByte() + 0.5f)];
    }

    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, WriterOutputStream.getDecoder(charset));
    }

    public WriterOutputStream(Writer writer, String charsetName) throws UnsupportedEncodingException {
        this(writer, Streams.getCharset(charsetName));
    }

    private static CharsetDecoder getDecoder(Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder.replaceWith("?");
        return decoder;
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.closed) {
            throw Messages.msg.streamClosed();
        }
        ByteBuffer byteBuffer = this.byteBuffer;
        if (!byteBuffer.hasRemaining()) {
            this.doFlush(false);
        }
        byteBuffer.put((byte)b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.closed) {
            throw Messages.msg.streamClosed();
        }
        ByteBuffer byteBuffer = this.byteBuffer;
        while (len > 0) {
            int r2 = byteBuffer.remaining();
            if (r2 == 0) {
                this.doFlush(false);
                continue;
            }
            int c2 = Math.min(len, r2);
            byteBuffer.put(b2, off, c2);
            len -= c2;
            off += c2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(boolean eof) throws IOException {
        CharBuffer charBuffer = CharBuffer.wrap(this.chars);
        ByteBuffer byteBuffer = this.byteBuffer;
        CharsetDecoder decoder = this.decoder;
        byteBuffer.flip();
        try {
            while (byteBuffer.hasRemaining()) {
                CoderResult result = decoder.decode(byteBuffer, charBuffer, eof);
                if (result.isOverflow()) {
                    this.writer.write(this.chars, 0, charBuffer.position());
                    charBuffer.clear();
                    continue;
                }
                if (result.isUnderflow()) {
                    int p2 = charBuffer.position();
                    if (p2 > 0) {
                        this.writer.write(this.chars, 0, p2);
                    }
                    return;
                }
                if (!result.isError()) continue;
                if (result.isMalformed()) {
                    throw Messages.msg.malformedInput();
                }
                if (result.isUnmappable()) {
                    throw Messages.msg.unmappableCharacter();
                }
                throw Messages.msg.characterDecodingProblem();
            }
        }
        finally {
            byteBuffer.compact();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw Messages.msg.streamClosed();
        }
        this.doFlush(false);
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.doFlush(true);
        this.byteBuffer.clear();
        this.writer.close();
    }

    public String toString() {
        return "Output stream writing to " + this.writer;
    }
}

