/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.balance;

import com.networknt.balance.LoadBalance;
import com.networknt.registry.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinLoadBalance
implements LoadBalance {
    static Logger logger = LoggerFactory.getLogger(RoundRobinLoadBalance.class);
    private AtomicInteger idx = new AtomicInteger(0);

    public RoundRobinLoadBalance() {
        if (logger.isInfoEnabled()) {
            logger.info("A RoundRobinLoadBalance instance is started");
        }
    }

    @Override
    public URL select(List<URL> urls, String requestKey) {
        URL url = null;
        if (urls.size() > 1) {
            url = this.doSelect(urls);
        } else if (urls.size() == 1) {
            url = urls.get(0);
        }
        return url;
    }

    protected URL doSelect(List<URL> urls) {
        int index = this.getNextPositive();
        for (int i = 0; i < urls.size(); ++i) {
            URL url = urls.get((i + index) % urls.size());
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private int getNextPositive() {
        return this.getPositive(this.idx.incrementAndGet());
    }
}

