/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.body.BodyConfig;
import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(BodyHandler.class);
    static final String CONTENT_TYPE_MISMATCH = "ERR10015";
    public static final AttachmentKey<Object> REQUEST_BODY = AttachmentKey.create(Object.class);
    public static final String CONFIG_NAME = "body";
    public static final BodyConfig config = (BodyConfig)Config.getInstance().getJsonObjectConfig("body", BodyConfig.class);
    private volatile HttpHandler next;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType != null && contentType.startsWith("application/json")) {
            if (exchange.isInIoThread()) {
                exchange.dispatch(this);
                return;
            }
            exchange.startBlocking();
            InputStream is = exchange.getInputStream();
            if (is != null) {
                try {
                    if (is.available() != -1) {
                        Object body;
                        String s = new Scanner(is, "UTF-8").useDelimiter("\\A").next();
                        if ((s = s.trim()).startsWith("{")) {
                            body = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                        } else if (s.startsWith("[")) {
                            body = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<HashMap<String, Object>>>(){});
                        } else {
                            Status status = new Status(CONTENT_TYPE_MISMATCH, contentType);
                            exchange.setStatusCode(status.getStatusCode());
                            exchange.getResponseSender().send(status.toString());
                            return;
                        }
                        exchange.putAttachment(REQUEST_BODY, body);
                    }
                }
                catch (IOException e) {
                    logger.error("IOException: ", e);
                }
            }
        }
        this.next.handleRequest(exchange);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(BodyHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

