/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.cdccore.kafka.producer;

import com.networknt.config.Config;
import com.networknt.eventuate.cdccore.kafka.KafkaConfig;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class CdcKafkaProducer {
    private Producer<String, String> producer;
    private String bootstrapServers;
    private Properties producerProps;
    static String CONFIG_NAME = "kafkaconfig";
    static final KafkaConfig config = (KafkaConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, KafkaConfig.class);

    public CdcKafkaProducer() {
        this(config.getBootstrapServers());
    }

    public CdcKafkaProducer(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        this.producerProps = new Properties();
        this.producerProps.put("bootstrap.servers", bootstrapServers);
        this.producerProps.put("acks", config.getAcks());
        this.producerProps.put("retries", (Object)config.getRetries());
        this.producerProps.put("batch.size", (Object)config.getBatchSize());
        this.producerProps.put("linger.ms", (Object)config.getLingerms());
        this.producerProps.put("buffer.memory", (Object)config.getBufferMemory());
        this.producerProps.put("key.serializer", config.getKeySerializer());
        this.producerProps.put("value.serializer", config.getValueSerializer());
        this.producer = new KafkaProducer<String, String>(this.producerProps);
    }

    public void setProducer(Producer<String, String> producer) {
        this.producer = producer;
    }

    public CompletableFuture<?> send(String topic, String key, String body) {
        CompletableFuture result = new CompletableFuture();
        this.producer.send(new ProducerRecord<String, String>(topic, key, body), (metadata, exception) -> {
            if (exception == null) {
                result.complete(metadata);
            } else {
                result.completeExceptionally(exception);
            }
        });
        return result;
    }

    public void close() {
        this.producer.close(1L, TimeUnit.SECONDS);
    }
}

