/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.cdcservice;

import com.networknt.config.Config;
import com.networknt.eventuate.cdcservice.CdcServiceConfig;
import com.networknt.eventuate.debezium.EventTableChangesToAggregateTopicRelay;
import com.networknt.server.StartupHookProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class CdcStartupHookProvider
implements StartupHookProvider {
    static String CONFIG_NAME = "cdcservice";
    static CdcServiceConfig config;
    static EventTableChangesToAggregateTopicRelay relay;
    public static CuratorFramework curatorFramework;

    @Override
    public void onStartup() {
        config = (CdcServiceConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, CdcServiceConfig.class);
        curatorFramework = this.makeStartedCuratorClient(config.getZookeeper());
        relay = new EventTableChangesToAggregateTopicRelay(config.getKafka(), CdcStartupHookProvider.config.dbHost, CdcStartupHookProvider.config.dbPort, CdcStartupHookProvider.config.dbUser, CdcStartupHookProvider.config.dbPass, curatorFramework);
        relay.start();
        System.out.println("CdcStartupHookProvider is called");
    }

    CuratorFramework makeStartedCuratorClient(String connectionString) {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework client = CuratorFrameworkFactory.builder().retryPolicy(retryPolicy).connectString(connectionString).build();
        client.start();
        return client;
    }
}

