/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.exception;

import com.networknt.config.Config;
import com.networknt.exception.ApiException;
import com.networknt.exception.ExceptionConfig;
import com.networknt.exception.FrameworkException;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ExceptionHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);
    public static final String CONFIG_NAME = "exception";
    static final ExceptionConfig config = (ExceptionConfig)Config.getInstance().getJsonObjectConfig("exception", ExceptionConfig.class);
    static final String STATUS_RUNTIME_EXCEPTION = "ERR10010";
    static final String STATUS_UNCAUGHT_EXCEPTION = "ERR10011";
    private volatile HttpHandler next;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        try {
            this.next.handleRequest(exchange);
        }
        catch (Throwable e) {
            logger.error("Exception:", e);
            if (exchange.isResponseChannelAvailable()) {
                if (e instanceof RuntimeException) {
                    if (e instanceof FrameworkException) {
                        FrameworkException fe = (FrameworkException)e;
                        exchange.setStatusCode(fe.getStatus().getStatusCode());
                        exchange.getResponseSender().send(fe.getStatus().toString());
                    } else {
                        Status status = new Status(STATUS_RUNTIME_EXCEPTION, new Object[0]);
                        exchange.setStatusCode(status.getStatusCode());
                        exchange.getResponseSender().send(status.toString());
                    }
                } else if (e instanceof ApiException) {
                    ApiException ae = (ApiException)e;
                    exchange.setStatusCode(ae.getStatus().getStatusCode());
                    exchange.getResponseSender().send(ae.getStatus().toString());
                } else {
                    Status status = new Status(STATUS_UNCAUGHT_EXCEPTION, new Object[0]);
                    exchange.setStatusCode(status.getStatusCode());
                    exchange.getResponseSender().send(status.toString());
                }
            }
        }
        finally {
            MDC.clear();
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(ExceptionHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

