/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support.command;

import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.support.FailbackRegistry;
import com.networknt.registry.support.command.CommandListener;
import com.networknt.registry.support.command.CommandServiceManager;
import com.networknt.registry.support.command.RpcCommand;
import com.networknt.registry.support.command.RpcCommandUtil;
import com.networknt.registry.support.command.ServiceListener;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandFailbackRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(CommandFailbackRegistry.class);
    private ConcurrentHashMap<URL, CommandServiceManager> commandManagerMap = new ConcurrentHashMap();

    public CommandFailbackRegistry(URL url) {
        super(url);
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry init. url: " + url.toSimpleString());
        }
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry subscribe. url: " + url.toSimpleString());
        }
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
        manager.addNotifyListener(listener);
        this.subscribeService(urlCopy, manager);
        this.subscribeCommand(urlCopy, manager);
        List<URL> urls = this.doDiscover(urlCopy);
        if (urls != null && urls.size() > 0) {
            this.notify(urlCopy, listener, urls);
        }
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry unsubscribe. url: " + url.toSimpleString());
        }
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.commandManagerMap.get(urlCopy);
        manager.removeNotifyListener(listener);
        this.unsubscribeService(urlCopy, manager);
        this.unsubscribeCommand(urlCopy, manager);
    }

    @Override
    protected List<URL> doDiscover(URL url) {
        List<URL> finalResult;
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry discover. url: " + url.toSimpleString());
        }
        URL urlCopy = url.createCopy();
        String commandStr = this.discoverCommand(urlCopy);
        RpcCommand rpcCommand = null;
        if (StringUtils.isNotEmpty(commandStr)) {
            rpcCommand = RpcCommandUtil.stringToCommand(commandStr);
        }
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry discover command. commandStr: " + commandStr + ", rpccommand " + (rpcCommand == null ? "is null." : "is not null."));
        }
        if (rpcCommand != null) {
            rpcCommand.sort();
            CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
            finalResult = manager.discoverServiceWithCommand(urlCopy, new HashMap<String, Integer>(), rpcCommand);
            manager.setCommandCache(commandStr);
        } else {
            finalResult = this.discoverService(urlCopy);
        }
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry discover size: " + finalResult.size() + ", result:" + finalResult.toString());
        }
        return finalResult;
    }

    public List<URL> commandPreview(URL url, RpcCommand rpcCommand, String previewIP) {
        List<URL> finalResult;
        URL urlCopy = url.createCopy();
        if (rpcCommand != null) {
            CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
            finalResult = manager.discoverServiceWithCommand(urlCopy, new HashMap<String, Integer>(), rpcCommand, previewIP);
        } else {
            finalResult = this.discoverService(urlCopy);
        }
        return finalResult;
    }

    private CommandServiceManager getCommandServiceManager(URL urlCopy) {
        CommandServiceManager manager = this.commandManagerMap.get(urlCopy);
        if (manager == null) {
            manager = new CommandServiceManager(urlCopy);
            manager.setRegistry(this);
            CommandServiceManager manager1 = this.commandManagerMap.putIfAbsent(urlCopy, manager);
            if (manager1 != null) {
                manager = manager1;
            }
        }
        return manager;
    }

    public ConcurrentHashMap<URL, CommandServiceManager> getCommandManagerMap() {
        return this.commandManagerMap;
    }

    protected abstract void subscribeService(URL var1, ServiceListener var2);

    protected abstract void subscribeCommand(URL var1, CommandListener var2);

    protected abstract void unsubscribeService(URL var1, ServiceListener var2);

    protected abstract void unsubscribeCommand(URL var1, CommandListener var2);

    protected abstract List<URL> discoverService(URL var1);

    protected abstract String discoverCommand(URL var1);
}

