/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support.command;

import com.networknt.exception.FrameworkException;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.registry.URLParamType;
import com.networknt.registry.support.command.CommandFailbackRegistry;
import com.networknt.registry.support.command.CommandListener;
import com.networknt.registry.support.command.RpcCommand;
import com.networknt.registry.support.command.RpcCommandUtil;
import com.networknt.registry.support.command.ServiceListener;
import com.networknt.status.Status;
import com.networknt.switcher.SwitcherUtil;
import com.networknt.utility.CollectionUtil;
import com.networknt.utility.ConcurrentHashSet;
import com.networknt.utility.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandServiceManager
implements CommandListener,
ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(CommandServiceManager.class);
    private static final String REGISTRY_IS_NULL = "ERR10024";
    private static final String WEIGHT_OUT_OF_RANGE = "ERR10025";
    public static final String LIGHT_COMMAND_SWITCHER = "feature.light.command.enable";
    private static Pattern IP_PATTERN = Pattern.compile("^!?[0-9.]*\\*?$");
    private URL refUrl;
    private ConcurrentHashSet<NotifyListener> notifySet;
    private CommandFailbackRegistry registry;
    private Map<String, List<URL>> groupServiceCache;
    private String commandStringCache = "";
    private volatile RpcCommand commandCache;

    public CommandServiceManager(URL refUrl) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandServiceManager init url:" + refUrl.toFullStr());
        }
        this.refUrl = refUrl;
        this.notifySet = new ConcurrentHashSet();
        this.groupServiceCache = new ConcurrentHashMap<String, List<URL>>();
    }

    @Override
    public void notifyService(URL serviceUrl, URL registryUrl, List<URL> urls) {
        if (this.registry == null) {
            throw new FrameworkException(new Status(REGISTRY_IS_NULL, new Object[0]));
        }
        URL urlCopy = serviceUrl.createCopy();
        String groupName = urlCopy.getParameter(URLParamType.group.getName(), URLParamType.group.getValue());
        this.groupServiceCache.put(groupName, urls);
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (this.commandCache != null) {
            HashMap<String, Integer> weights = new HashMap<String, Integer>();
            finalResult = this.discoverServiceWithCommand(this.refUrl, weights, this.commandCache);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("command cache is null. service:" + serviceUrl.toSimpleString());
            }
            finalResult.addAll(this.discoverOneGroup(this.refUrl));
        }
        for (NotifyListener notifyListener : this.notifySet) {
            notifyListener.notify(this.registry.getUrl(), finalResult);
        }
    }

    @Override
    public void notifyCommand(URL serviceUrl, String commandString) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandServiceManager notify command. service:" + serviceUrl.toSimpleString() + ", command:" + commandString);
        }
        if (!SwitcherUtil.isOpen(LIGHT_COMMAND_SWITCHER) || commandString == null) {
            if (logger.isInfoEnabled()) {
                logger.info("command reset empty since swither is close.");
            }
            commandString = "";
        }
        ArrayList<URL> finalResult = new ArrayList<URL>();
        URL urlCopy = serviceUrl.createCopy();
        if (!StringUtils.equals(commandString, this.commandStringCache)) {
            this.commandStringCache = commandString;
            this.commandCache = RpcCommandUtil.stringToCommand(this.commandStringCache);
            HashMap<String, Integer> weights = new HashMap<String, Integer>();
            if (this.commandCache != null) {
                this.commandCache.sort();
                finalResult = this.discoverServiceWithCommand(this.refUrl, weights, this.commandCache);
            } else {
                if (StringUtils.isNotBlank(commandString)) {
                    logger.warn("command parse fail, ignored! command:" + commandString);
                    commandString = "";
                }
                finalResult.addAll(this.discoverOneGroup(this.refUrl));
            }
            Set<String> groupKeys = this.groupServiceCache.keySet();
            for (String gk : groupKeys) {
                if (weights.containsKey(gk)) continue;
                this.groupServiceCache.remove(gk);
                URL urlTemp = urlCopy.createCopy();
                urlTemp.addParameter(URLParamType.group.getName(), gk);
                this.registry.unsubscribeService(urlTemp, this);
            }
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("command is not changed. url:" + serviceUrl.toSimpleString());
            }
            return;
        }
        for (NotifyListener notifyListener : this.notifySet) {
            notifyListener.notify(this.registry.getUrl(), finalResult);
        }
        if ("".equals(commandString)) {
            if (logger.isInfoEnabled()) {
                logger.info("reSub service" + this.refUrl.toSimpleString());
            }
            this.registry.subscribeService(this.refUrl, this);
        }
    }

    public List<URL> discoverServiceWithCommand(URL serviceUrl, Map<String, Integer> weights, RpcCommand rpcCommand) {
        String localIP = NetUtils.getLocalAddress().getHostAddress();
        return this.discoverServiceWithCommand(serviceUrl, weights, rpcCommand, localIP);
    }

    public List<URL> discoverServiceWithCommand(URL serviceUrl, Map<String, Integer> weights, RpcCommand rpcCommand, String localIP) {
        if (rpcCommand == null || CollectionUtil.isEmpty(rpcCommand.getClientCommandList())) {
            return this.discoverOneGroup(serviceUrl);
        }
        LinkedList<URL> mergedResult = new LinkedList<URL>();
        String path = serviceUrl.getPath();
        List<RpcCommand.ClientCommand> clientCommandList = rpcCommand.getClientCommandList();
        boolean hit = false;
        for (RpcCommand.ClientCommand command : clientCommandList) {
            mergedResult = new LinkedList();
            boolean match = RpcCommandUtil.match(command.getPattern(), path);
            if (!match) continue;
            hit = true;
            if (!CollectionUtil.isEmpty(command.getMergeGroups())) {
                try {
                    this.buildWeightsMap(weights, command);
                }
                catch (FrameworkException e) {
                    logger.error("build weights map fail!" + e.getMessage());
                    continue;
                }
                mergedResult.addAll(this.mergeResult(serviceUrl, weights));
            } else {
                mergedResult.addAll(this.discoverOneGroup(serviceUrl));
            }
            if (logger.isInfoEnabled()) {
                logger.info("mergedResult: size-" + mergedResult.size() + " --- " + ((Object)mergedResult).toString());
            }
            if (CollectionUtil.isEmpty(command.getRouteRules())) break;
            if (logger.isInfoEnabled()) {
                logger.info("router: " + command.getRouteRules().toString());
            }
            for (String routeRule : command.getRouteRules()) {
                int idx;
                String[] fromTo = routeRule.replaceAll("\\s+", "").split("to");
                if (fromTo.length != 2) {
                    logger.warn("Invalid route rule configuration");
                    continue;
                }
                String from = fromTo[0];
                String to = fromTo[1];
                if (from.length() < 1 || to.length() < 1 || !IP_PATTERN.matcher(from).find() || !IP_PATTERN.matcher(to).find()) {
                    logger.warn("Invalid route rule configuration");
                    continue;
                }
                boolean oppositeFrom = from.startsWith("!");
                boolean oppositeTo = to.startsWith("!");
                if (oppositeFrom) {
                    from = from.substring(1);
                }
                if (oppositeTo) {
                    to = to.substring(1);
                }
                boolean matchFrom = (idx = from.indexOf(42)) != -1 ? localIP.startsWith(from.substring(0, idx)) : localIP.equals(from);
                if (oppositeFrom) {
                    boolean bl = matchFrom = !matchFrom;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("matchFrom: " + matchFrom + ", localip:" + localIP + ", from:" + from);
                }
                if (!matchFrom) continue;
                Iterator iterator = mergedResult.iterator();
                while (iterator.hasNext()) {
                    URL url = (URL)iterator.next();
                    if (url.getProtocol().equalsIgnoreCase("rule")) continue;
                    idx = to.indexOf(42);
                    boolean matchTo = idx != -1 ? url.getHost().startsWith(to.substring(0, idx)) : url.getHost().equals(to);
                    if (oppositeTo) {
                        boolean bl = matchTo = !matchTo;
                    }
                    if (matchTo) continue;
                    iterator.remove();
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("router To not match. url remove : " + url.toSimpleString());
                }
            }
        }
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (!hit) {
            finalResult = this.discoverOneGroup(serviceUrl);
        } else {
            finalResult.addAll(mergedResult);
        }
        return finalResult;
    }

    private void buildWeightsMap(Map<String, Integer> weights, RpcCommand.ClientCommand command) {
        for (String rule : command.getMergeGroups()) {
            String[] gw = rule.split(":");
            int weight = 1;
            if (gw.length > 1) {
                try {
                    weight = Integer.parseInt(gw[1]);
                }
                catch (NumberFormatException e) {
                    throw new FrameworkException(new Status(WEIGHT_OUT_OF_RANGE, weight));
                }
                if (weight < 0 || weight > 100) {
                    throw new FrameworkException(new Status(WEIGHT_OUT_OF_RANGE, weight));
                }
            }
            weights.put(gw[0], weight);
        }
    }

    private List<URL> mergeResult(URL url, Map<String, Integer> weights) {
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (weights.size() > 1) {
            URLImpl ruleUrl = new URLImpl("rule", url.getHost(), url.getPort(), url.getPath());
            StringBuilder weightsBuilder = new StringBuilder(64);
            for (Map.Entry<String, Integer> entry : weights.entrySet()) {
                weightsBuilder.append(entry.getKey()).append(':').append(entry.getValue()).append(',');
            }
            ruleUrl.addParameter(URLParamType.weights.getName(), weightsBuilder.deleteCharAt(weightsBuilder.length() - 1).toString());
            finalResult.add(ruleUrl);
        }
        for (String key : weights.keySet()) {
            if (this.groupServiceCache.containsKey(key)) {
                finalResult.addAll((Collection<URL>)this.groupServiceCache.get(key));
                continue;
            }
            URL urlTemp = url.createCopy();
            urlTemp.addParameter(URLParamType.group.getName(), key);
            finalResult.addAll(this.discoverOneGroup(urlTemp));
            this.registry.subscribeService(urlTemp, this);
        }
        return finalResult;
    }

    private List<URL> discoverOneGroup(URL urlCopy) {
        String group;
        List<URL> list;
        if (logger.isInfoEnabled()) {
            logger.info("CommandServiceManager discover one group. url:" + urlCopy.toSimpleString());
        }
        if ((list = this.groupServiceCache.get(group = urlCopy.getParameter(URLParamType.group.getName(), URLParamType.group.getValue()))) == null) {
            list = this.registry.discoverService(urlCopy);
            this.groupServiceCache.put(group, list);
        }
        return list;
    }

    public void setCommandCache(String command) {
        this.commandStringCache = command;
        this.commandCache = RpcCommandUtil.stringToCommand(this.commandStringCache);
        if (logger.isInfoEnabled()) {
            logger.info("CommandServiceManager set commandcache. commandstring:" + this.commandStringCache + ", comandcache " + (this.commandCache == null ? "is null." : "is not null."));
        }
    }

    public void addNotifyListener(NotifyListener notifyListener) {
        this.notifySet.add(notifyListener);
    }

    public void removeNotifyListener(NotifyListener notifyListener) {
        this.notifySet.remove(notifyListener);
    }

    public void setRegistry(CommandFailbackRegistry registry) {
        this.registry = registry;
    }

    static {
        SwitcherUtil.initSwitcher(LIGHT_COMMAND_SWITCHER, true);
    }
}

