/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support.command;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.networknt.config.Config;
import com.networknt.registry.support.command.RpcCommand;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCommandUtil {
    private static final Logger logger = LoggerFactory.getLogger(RpcCommand.class);
    private static PatternEvaluator evaluator = new PatternEvaluator();

    public static RpcCommand stringToCommand(String commandString) {
        try {
            return Config.getInstance().getMapper().readValue(commandString, RpcCommand.class);
        }
        catch (Exception e) {
            logger.error("Invalid JSON format " + commandString);
            return null;
        }
    }

    public static String commandToString(RpcCommand command) throws JsonProcessingException {
        return Config.getInstance().getMapper().writeValueAsString(command);
    }

    public static boolean match(String expression, String path) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return evaluator.match(expression, path);
    }

    private static class PatternEvaluator {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9_$.*]+");
        Set<Character> all = ImmutableSet.of(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('!'), Character.valueOf('&'), new Character[]{Character.valueOf('|')});
        Map<Character, ImmutableSet<Character>> following = ImmutableMap.builder().put(Character.valueOf('('), ImmutableSet.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('!'))).put(Character.valueOf(')'), ImmutableSet.of(Character.valueOf('|'), Character.valueOf('&'), Character.valueOf(')'))).put(Character.valueOf('0'), ImmutableSet.of(Character.valueOf('|'), Character.valueOf('&'), Character.valueOf(')'))).put(Character.valueOf('1'), ImmutableSet.of(Character.valueOf('|'), Character.valueOf('&'), Character.valueOf(')'))).put(Character.valueOf('!'), ImmutableSet.of(Character.valueOf('('), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('!'))).put(Character.valueOf('&'), ImmutableSet.of(Character.valueOf('('), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('!'))).put(Character.valueOf('|'), ImmutableSet.of(Character.valueOf('('), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('!'))).build();

        private PatternEvaluator() {
        }

        boolean match(String expression, String path) {
            Matcher matcher = this.pattern.matcher(expression.replaceAll("\\s+", ""));
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String s = matcher.group();
                int idx = s.indexOf(42);
                if (idx != -1) {
                    matcher.appendReplacement(buffer, path.startsWith(s.substring(0, idx)) ? "1" : "0");
                    continue;
                }
                matcher.appendReplacement(buffer, s.equals(path) ? "1" : "0");
            }
            matcher.appendTail(buffer);
            String result1 = buffer.toString();
            LinkedList<LinkedList> outer = new LinkedList<LinkedList>();
            LinkedList<Character> inner = new LinkedList<Character>();
            inner.push(Character.valueOf('#'));
            outer.push(inner);
            int i = 0;
            int len = result1.length();
            while (outer.size() > 0 && i < len) {
                LinkedList sub = (LinkedList)outer.peekLast();
                block6: while (sub.size() > 0 && i < len) {
                    char curr = result1.charAt(i++);
                    this.support(curr);
                    char prev = ((Character)sub.peekFirst()).charValue();
                    if (prev != '#') {
                        this.supportFollowing(prev, curr);
                    }
                    switch (curr) {
                        case '(': {
                            sub = new LinkedList();
                            sub.push(Character.valueOf('#'));
                            outer.push(sub);
                            continue block6;
                        }
                        case ')': {
                            outer.removeFirst();
                            ((LinkedList)outer.peekFirst()).push(Character.valueOf(this.evalWithinParentheses(sub)));
                            sub = (LinkedList)outer.peekFirst();
                            continue block6;
                        }
                    }
                    sub.push(Character.valueOf(curr));
                }
            }
            if (outer.size() != 1) {
                throw new IllegalArgumentException("Syntax error!");
            }
            char result = this.evalWithinParentheses((LinkedList)outer.peekLast());
            return result == '1';
        }

        char evalWithinParentheses(LinkedList<Character> list) {
            int curr;
            int operand = list.pop().charValue();
            if (operand != 48 && operand != 49) {
                this.syntaxError();
            }
            while (!list.isEmpty()) {
                curr = list.pop().charValue();
                if (curr == 33) {
                    operand = operand == 48 ? 49 : 48;
                    continue;
                }
                if (curr == 35) break;
                if (operand == 48 || operand == 49) {
                    list.addLast(Character.valueOf((char)operand));
                    list.addLast(Character.valueOf((char)curr));
                    operand = 0;
                    continue;
                }
                operand = curr;
            }
            list.addLast(Character.valueOf((char)operand));
            list.addLast(Character.valueOf('#'));
            operand = list.pop().charValue();
            while (!list.isEmpty()) {
                curr = list.pop().charValue();
                if (curr == 38) {
                    char c = list.pop().charValue();
                    operand = operand == 49 && c == '1' ? 49 : 48;
                    continue;
                }
                if (curr == 35) break;
                if (operand == 48 || operand == 49) {
                    list.addLast(Character.valueOf((char)operand));
                    list.addLast(Character.valueOf((char)curr));
                    operand = 0;
                    continue;
                }
                operand = curr;
            }
            list.addLast(Character.valueOf((char)operand));
            operand = 48;
            while (!list.isEmpty() && (operand = list.pop().charValue()) != 49) {
            }
            return (char)operand;
        }

        void syntaxError() {
            throw new IllegalArgumentException("Syntax error! only support ()!&| in priority.");
        }

        void syntaxError(String s) {
            throw new IllegalArgumentException("Syntax error: " + s);
        }

        void support(char c) {
            if (!this.all.contains(Character.valueOf(c))) {
                this.syntaxError("Unsupported Character " + c);
            }
        }

        void supportFollowing(char prev, char c) {
            if (!this.following.get(Character.valueOf(prev)).contains(Character.valueOf(c))) {
                this.syntaxError("prev=" + prev + ", c=" + c);
            }
        }
    }
}

