/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.registry.Registry;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.server.DummyTrustManager;
import com.networknt.server.HandlerProvider;
import com.networknt.server.ServerConfig;
import com.networknt.server.ShutdownHookProvider;
import com.networknt.server.StartupHookProvider;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.switcher.SwitcherUtil;
import com.networknt.utility.Util;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Enumeration;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.xnio.Options;

public class Server {
    static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final String CONFIG_NAME = "server";
    public static final String CONFIG_SECRET = "secret";
    static final String DEFAULT_ENV = "dev";
    static final String LIGHT_ENV = "light-env";
    static final String LIGHT_CONFIG_SERVER_URI = "light-config-server-uri";
    static final String SID = "sId";
    public static ServerConfig config = (ServerConfig)Config.getInstance().getJsonObjectConfig("server", ServerConfig.class);
    public static Map<String, Object> secret = Config.getInstance().getJsonMapConfig("secret");
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new DummyTrustManager()};
    protected static boolean shutdownRequested = false;
    static Undertow server = null;
    static URL serviceHttpUrl;
    static URL serviceHttpsUrl;
    static Registry registry;
    static SSLContext sslContext;

    public static void main(String[] args) {
        logger.info("server starts");
        System.setProperty("org.jboss.logging.provider", "slf4j");
        MDC.put(SID, config.getServiceId());
        Server.loadConfig();
        Server.start();
    }

    public static void start() {
        Server.addDaemonShutdownHook();
        ServiceLoader<StartupHookProvider> startupLoaders = ServiceLoader.load(StartupHookProvider.class);
        for (StartupHookProvider provider : startupLoaders) {
            provider.onStartup();
        }
        if (Server.config.enableRegistry) {
            registry = (Registry)SingletonServiceFactory.getBean(Registry.class);
            if (registry == null) {
                throw new RuntimeException("Could not find registry instance in service map");
            }
            InetAddress inetAddress = Util.getInetAddress();
            String ipAddress = inetAddress.getHostAddress();
            if (Server.config.enableHttp) {
                serviceHttpUrl = new URLImpl("light", ipAddress, config.getHttpPort(), config.getServiceId());
                registry.register(serviceHttpUrl);
                if (logger.isInfoEnabled()) {
                    logger.info("register serviceHttpUrl " + serviceHttpUrl);
                }
            }
            if (Server.config.enableHttps) {
                serviceHttpsUrl = new URLImpl("light", ipAddress, config.getHttpsPort(), config.getServiceId());
                registry.register(serviceHttpsUrl);
                if (logger.isInfoEnabled()) {
                    logger.info("register serviceHttpsUrl " + serviceHttpsUrl);
                }
            }
        }
        HttpHandler handler = null;
        ServiceLoader<HandlerProvider> handlerLoaders = ServiceLoader.load(HandlerProvider.class);
        for (HandlerProvider handlerProvider : handlerLoaders) {
            if (handlerProvider.getHandler() == null) continue;
            handler = handlerProvider.getHandler();
            break;
        }
        if (handler == null) {
            logger.error("Unable to start the server - no route handler provider available in the classpath");
            return;
        }
        ServiceLoader<MiddlewareHandler> middlewareLoaders = ServiceLoader.load(MiddlewareHandler.class);
        logger.debug("found middlewareLoaders", (Object)middlewareLoaders);
        for (MiddlewareHandler middlewareHandler : middlewareLoaders) {
            logger.info("Plugin: " + middlewareHandler.getClass().getName());
            if (!middlewareHandler.isEnabled()) continue;
            handler = middlewareHandler.setNext(handler);
            middlewareHandler.register();
        }
        Undertow.Builder builder = Undertow.builder();
        if (Server.config.enableHttp2) {
            sslContext = Server.createSSLContext();
            builder.addHttpsListener(config.getHttpsPort(), config.getIp(), sslContext);
            builder.setServerOption(UndertowOptions.ENABLE_HTTP2, true);
        } else {
            if (Server.config.enableHttp) {
                builder.addHttpListener(config.getHttpPort(), config.getIp());
            }
            if (Server.config.enableHttps) {
                sslContext = Server.createSSLContext();
                builder.addHttpsListener(config.getHttpsPort(), config.getIp(), sslContext);
            }
        }
        server = builder.setBufferSize(16384).setIoThreads(Runtime.getRuntime().availableProcessors() * 2).setSocketOption(Options.BACKLOG, 10000).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, false).setServerOption(UndertowOptions.ALWAYS_SET_DATE, true).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, false).setHandler(Handlers.header(handler, "Server", "L")).setWorkerThreads(200).build();
        server.start();
        if (logger.isInfoEnabled()) {
            if (Server.config.enableHttp) {
                logger.info("Http Server started on ip:" + config.getIp() + " Port:" + config.getHttpPort());
            }
            if (Server.config.enableHttps) {
                logger.info("Https Server started on ip:" + config.getIp() + " Port:" + config.getHttpsPort());
            }
        }
        if (Server.config.enableRegistry) {
            SwitcherUtil.setSwitcherValue("RegistryHeartBeat", true);
            if (logger.isInfoEnabled()) {
                logger.info("Registry heart beat switcher is on");
            }
        }
    }

    public static void stop() {
        if (server != null) {
            server.stop();
        }
    }

    public static void shutdown() {
        if (Server.config.enableRegistry && registry != null && Server.config.enableHttp) {
            registry.unregister(serviceHttpUrl);
            if (logger.isInfoEnabled()) {
                logger.info("unregister serviceHttpUrl " + serviceHttpUrl);
            }
        }
        if (Server.config.enableRegistry && registry != null && Server.config.enableHttps) {
            registry.unregister(serviceHttpsUrl);
            if (logger.isInfoEnabled()) {
                logger.info("unregister serviceHttpsUrl " + serviceHttpsUrl);
            }
        }
        ServiceLoader<ShutdownHookProvider> shutdownLoaders = ServiceLoader.load(ShutdownHookProvider.class);
        for (ShutdownHookProvider provider : shutdownLoaders) {
            provider.onShutdown();
        }
        Server.stop();
        logger.info("Cleaning up before server shutdown");
    }

    protected static void addDaemonShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Server.shutdown();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore loadKeyStore() {
        String name = config.getKeystoreName();
        try (InputStream stream = Config.getInstance().getInputStreamFromFile(name);){
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, ((String)secret.get("serverKeystorePass")).toCharArray());
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (Exception e) {
            logger.error("Unable to load keystore " + name, e);
            throw new RuntimeException("Unable to load keystore " + name, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static KeyStore loadTrustStore() {
        String name = config.getTruststoreName();
        try (InputStream stream = Config.getInstance().getInputStreamFromFile(name);){
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, ((String)secret.get("serverTruststorePass")).toCharArray());
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (Exception e) {
            logger.error("Unable to load truststore " + name, e);
            throw new RuntimeException("Unable to load truststore " + name, e);
        }
    }

    private static TrustManager[] buildTrustManagers(KeyStore trustStore) {
        TrustManager[] trustManagers = null;
        if (trustStore == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                logger.error("Unable to initialise TrustManager[]", e);
                throw new RuntimeException("Unable to initialise TrustManager[]", e);
            }
        } else {
            trustManagers = TRUST_ALL_CERTS;
        }
        return trustManagers;
    }

    private static KeyManager[] buildKeyManagers(KeyStore keyStore, char[] keyPass) {
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyPass);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            logger.error("Unable to initialise KeyManager[]", e);
            throw new RuntimeException("Unable to initialise KeyManager[]", e);
        }
        return keyManagers;
    }

    private static SSLContext createSSLContext() throws RuntimeException {
        try {
            KeyManager[] keyManagers = Server.buildKeyManagers(Server.loadKeyStore(), ((String)secret.get("serverKeyPass")).toCharArray());
            TrustManager[] trustManagers = config.isEnableTwoWayTls() ? Server.buildTrustManagers(Server.loadTrustStore()) : Server.buildTrustManagers(null);
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            logger.error("Unable to create SSLContext", e);
            throw new RuntimeException("Unable to create SSLContext", e);
        }
    }

    private static void loadConfig() {
        String configUri;
        String env = System.getProperty(LIGHT_ENV);
        if (env == null) {
            logger.warn("Warning! No light-env has been passed in from command line. Default to dev");
            env = DEFAULT_ENV;
        }
        if ((configUri = System.getProperty(LIGHT_CONFIG_SERVER_URI)) != null) {
            String targetMergeDirectory = System.getProperty("light-4j-config-dir");
            if (targetMergeDirectory == null) {
                logger.warn("Warning! No light-4j-config-dir has been passed in from command line.");
                return;
            }
            String version = Util.getJarVersion();
            String service = config.getServiceId();
            configUri = configUri + "/v1/config/" + version + "/" + env + "/" + service;
            String tempDir = System.getProperty("java.io.tmpdir");
            String zipFile = tempDir + "/config.zip";
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet(configUri);
            try {
                HttpResponse response = httpClient.execute(httpGet);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    FileOutputStream fos = new FileOutputStream(zipFile);
                    entity.writeTo(fos);
                    fos.close();
                }
                Server.unzipFile(zipFile, targetMergeDirectory);
            }
            catch (IOException e) {
                logger.error("IOException", e);
            }
        } else {
            logger.info("light-config-server-uri is missing in the command line. Use local config files");
        }
    }

    private static void mergeConfigFiles(String source, String target) {
    }

    private static void unzipFile(String path, String target) {
        try (ZipFile file = new ZipFile(path);){
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            Files.createDirectory(fileSystem.getPath(target, new String[0]), new FileAttribute[0]);
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    System.out.println("Creating Directory:" + target + entry.getName());
                    Files.createDirectories(fileSystem.getPath(target + entry.getName(), new String[0]), new FileAttribute[0]);
                    continue;
                }
                InputStream is = file.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(is);
                String uncompressedFileName = target + entry.getName();
                Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);
                while (bis.available() > 0) {
                    fileOutput.write(bis.read());
                }
                fileOutput.close();
                System.out.println("Written :" + entry.getName());
            }
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }
}

