/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.service;

import com.networknt.config.Config;
import com.networknt.service.ServiceConfig;
import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonServiceFactory {
    static String CONFIG_NAME = "service";
    static Logger logger = LoggerFactory.getLogger(SingletonServiceFactory.class);
    private static Map<Class, Object> serviceMap = new HashMap<Class, Object>();

    private static void handleSingleImpl(List<Class> interfaceClasses, List<Object> value) throws Exception {
        block9: {
            Object object;
            block8: {
                object = value.get(0);
                if (!(object instanceof String)) break block8;
                Class<?> implClass = Class.forName((String)object);
                Object obj = SingletonServiceFactory.construct(implClass);
                for (Class c : interfaceClasses) {
                    serviceMap.put(c, obj);
                }
                break block9;
            }
            Map map = (Map)object;
            Iterator it = map.entrySet().iterator();
            if (!it.hasNext()) break block9;
            Map.Entry pair = it.next();
            String key = (String)pair.getKey();
            Class<?> implClass = Class.forName(key);
            Object mapOrList = pair.getValue();
            Object obj = null;
            if (mapOrList instanceof Map) {
                Method[] allMethods;
                obj = SingletonServiceFactory.construct(implClass);
                for (Method method : allMethods = implClass.getMethods()) {
                    if (!method.getName().startsWith("set")) continue;
                    Object[] o = new Object[1];
                    String propertyName = Introspector.decapitalize(method.getName().substring(3));
                    Object v = ((Map)mapOrList).get(propertyName);
                    if (v == null) {
                        Class<?>[] pType = method.getParameterTypes();
                        v = serviceMap.get(pType[0]);
                    }
                    if (v == null) continue;
                    o[0] = v;
                    method.invoke(obj, o);
                }
            } else if (mapOrList instanceof List) {
                obj = SingletonServiceFactory.constructWithParameters(implClass, (List)mapOrList);
            } else {
                throw new RuntimeException("Only Map or List is allowed for implementation parameters " + mapOrList);
            }
            for (Class c : interfaceClasses) {
                serviceMap.put(c, obj);
            }
        }
    }

    private static void handleMultipleImpl(List<Class> interfaceClasses, List<Object> value) throws Exception {
        int i;
        List arrays = interfaceClasses.stream().map(c -> Array.newInstance(c, value.size())).collect(Collectors.toList());
        for (i = 0; i < value.size(); ++i) {
            Object object = value.get(i);
            if (!(object instanceof String)) continue;
            Class<?> implClass = Class.forName((String)value.get(i));
            for (Object array : arrays) {
                Array.set(array, i, SingletonServiceFactory.construct(implClass));
            }
        }
        for (i = 0; i < interfaceClasses.size(); ++i) {
            serviceMap.put(interfaceClasses.get(i), arrays.get(i));
        }
    }

    private static void handleSingleton(String key, List<Object> value) throws Exception {
        ArrayList<Class> interfaceClasses = new ArrayList<Class>();
        if (key.contains(",")) {
            String[] interfaces;
            for (String anInterface : interfaces = key.split(",")) {
                interfaceClasses.add(Class.forName(anInterface));
            }
        } else {
            interfaceClasses.add(Class.forName(key));
        }
        if (value != null && value.size() == 1) {
            SingletonServiceFactory.handleSingleImpl(interfaceClasses, value);
        } else {
            SingletonServiceFactory.handleMultipleImpl(interfaceClasses, value);
        }
    }

    private static Object construct(Class clazz) throws Exception {
        Object instance = null;
        Constructor<?>[] allConstructors = clazz.getDeclaredConstructors();
        boolean hasDefaultConstructor = false;
        for (Constructor<?> ctor : allConstructors) {
            Class<?>[] pType = ctor.getParameterTypes();
            if (pType.length > 0) {
                boolean beanFound = true;
                Object[] params = new Object[pType.length];
                for (int j = 0; j < pType.length; ++j) {
                    Object obj = SingletonServiceFactory.getBean(pType[j]);
                    if (obj == null) {
                        beanFound = false;
                        break;
                    }
                    params[j] = obj;
                }
                if (!beanFound) continue;
                instance = ctor.newInstance(params);
                break;
            }
            hasDefaultConstructor = true;
        }
        if (instance != null) {
            return instance;
        }
        if (hasDefaultConstructor) {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        throw new Exception("No instance can be created for class " + clazz);
    }

    private static Object constructWithParameters(Class clazz, List parameters) throws Exception {
        Object instance = null;
        Constructor<?>[] allConstructors = clazz.getDeclaredConstructors();
        boolean hasDefaultConstructor = false;
        for (Constructor<?> ctor : allConstructors) {
            Class<?>[] pType = ctor.getParameterTypes();
            if (pType.length > 0) {
                if (pType.length != parameters.size()) continue;
                boolean matched = true;
                Object[] params = new Object[pType.length];
                for (int j = 0; j < pType.length; ++j) {
                    Map parameter = (Map)parameters.get(j);
                    Iterator it = parameter.entrySet().iterator();
                    if (!it.hasNext()) continue;
                    Map.Entry pair = it.next();
                    String key = (String)pair.getKey();
                    Object value = pair.getValue();
                    if (pType[j].getName().equals(key)) {
                        params[j] = value;
                        continue;
                    }
                    matched = false;
                    break;
                }
                if (!matched) continue;
                instance = ctor.newInstance(params);
                break;
            }
            hasDefaultConstructor = true;
        }
        if (instance != null) {
            return instance;
        }
        if (hasDefaultConstructor) {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        throw new Exception("No instance can be created for class " + clazz);
    }

    public static Object getBean(Class interfaceClass) {
        return serviceMap.get(interfaceClass);
    }

    static {
        ServiceConfig serviceConfig = (ServiceConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, ServiceConfig.class);
        List<Map<String, List<Object>>> singletons = serviceConfig.getSingletons();
        try {
            if (singletons != null && singletons.size() > 0) {
                for (Map<String, List<Object>> singleton : singletons) {
                    Iterator<Map.Entry<String, List<Object>>> it = singleton.entrySet().iterator();
                    if (!it.hasNext()) continue;
                    Map.Entry<String, List<Object>> pair = it.next();
                    String key = pair.getKey();
                    key = key.replaceAll("\\s+", "");
                    List<Object> value = pair.getValue();
                    SingletonServiceFactory.handleSingleton(key, value);
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception:", e);
        }
    }
}

