/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.mapping.ColumnMappers;
import io.debezium.util.Collect;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Immutable
public class Filters {
    protected static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet("mysql", "performance_schema", "sys", "information_schema");
    private final Predicate<String> dbFilter;
    private final Predicate<TableId> tableFilter;
    private final Predicate<String> isBuiltInDb = Filters::isBuiltInDatabase;
    private final Predicate<TableId> isBuiltInTable = Filters::isBuiltInTable;
    private final Predicate<ColumnId> columnFilter;
    private final ColumnMappers columnMappers;

    protected static boolean isBuiltInDatabase(String databaseName) {
        return BUILT_IN_DB_NAMES.contains(databaseName.toLowerCase());
    }

    protected static boolean isBuiltInTable(TableId id) {
        return Filters.isBuiltInDatabase(id.catalog());
    }

    protected static boolean isNotBuiltInDatabase(String databaseName) {
        return !Filters.isBuiltInDatabase(databaseName);
    }

    protected static boolean isNotBuiltInTable(TableId id) {
        return !Filters.isBuiltInTable(id);
    }

    protected static List<TableId> withoutBuiltIns(Collection<TableId> tableIds) {
        return tableIds.stream().filter(Filters::isNotBuiltInTable).collect(Collectors.toList());
    }

    protected static List<String> withoutBuiltInDatabases(Collection<String> dbNames) {
        return dbNames.stream().filter(Filters::isNotBuiltInDatabase).collect(Collectors.toList());
    }

    public Filters(Configuration config) {
        Predicate<String> dbFilter = Selectors.databaseSelector().includeDatabases(config.getString(MySqlConnectorConfig.DATABASE_WHITELIST)).excludeDatabases(config.getString(MySqlConnectorConfig.DATABASE_BLACKLIST)).build();
        Predicate<TableId> tableFilter = Selectors.tableSelector().includeDatabases(config.getString(MySqlConnectorConfig.DATABASE_WHITELIST)).excludeDatabases(config.getString(MySqlConnectorConfig.DATABASE_BLACKLIST)).includeTables(config.getString(MySqlConnectorConfig.TABLE_WHITELIST)).excludeTables(config.getString(MySqlConnectorConfig.TABLE_BLACKLIST)).build();
        if (config.getBoolean(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN)) {
            this.tableFilter = tableFilter.and(this.isBuiltInTable.negate());
            this.dbFilter = dbFilter.and(this.isBuiltInDb.negate());
        } else {
            this.tableFilter = tableFilter.or(this.isBuiltInTable);
            this.dbFilter = dbFilter.or(this.isBuiltInDb);
        }
        this.columnFilter = Selectors.excludeColumns(config.getString(MySqlConnectorConfig.COLUMN_BLACKLIST));
        ColumnMappers.Builder columnMapperBuilder = ColumnMappers.create();
        config.forEachMatchingFieldNameWithInteger("column\\.truncate\\.to\\.(\\d+)\\.chars", columnMapperBuilder::truncateStrings);
        config.forEachMatchingFieldNameWithInteger("column\\.mask\\.with\\.(\\d+)\\.chars", columnMapperBuilder::maskStrings);
        this.columnMappers = columnMapperBuilder.build();
    }

    public Predicate<String> databaseFilter() {
        return this.dbFilter;
    }

    public Predicate<TableId> tableInDatabaseFilter() {
        return tableId -> this.dbFilter.test(tableId.catalog());
    }

    public Predicate<TableId> tableFilter() {
        return this.tableFilter;
    }

    public Tables.TableNameFilter tableNameFilter() {
        return Tables.filterFor(this.tableFilter);
    }

    public Predicate<TableId> builtInTableFilter() {
        return this.isBuiltInTable;
    }

    public Predicate<String> builtInDatabaseFilter() {
        return this.isBuiltInDb;
    }

    public Predicate<ColumnId> columnFilter() {
        return this.columnFilter;
    }

    public ColumnMappers columnMappers() {
        return this.columnMappers;
    }
}

