/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.document.Document;
import io.debezium.relational.TableId;
import io.debezium.util.Collect;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

@NotThreadSafe
final class SourceInfo {
    public static final String SERVER_ID_KEY = "server_id";
    public static final String SERVER_NAME_KEY = "name";
    public static final String SERVER_PARTITION_KEY = "server";
    public static final String GTID_SET_KEY = "gtids";
    public static final String GTID_KEY = "gtid";
    public static final String EVENTS_TO_SKIP_OFFSET_KEY = "event";
    public static final String BINLOG_FILENAME_OFFSET_KEY = "file";
    public static final String BINLOG_POSITION_OFFSET_KEY = "pos";
    public static final String BINLOG_ROW_IN_EVENT_OFFSET_KEY = "row";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final String THREAD_KEY = "thread";
    public static final String DB_NAME_KEY = "db";
    public static final String TABLE_NAME_KEY = "table";
    public static final Schema SCHEMA = SchemaBuilder.struct().name("io.debezium.connector.mysql.Source").field("name", Schema.STRING_SCHEMA).field("server_id", Schema.INT64_SCHEMA).field("ts_sec", Schema.INT64_SCHEMA).field("gtid", Schema.OPTIONAL_STRING_SCHEMA).field("file", Schema.STRING_SCHEMA).field("pos", Schema.INT64_SCHEMA).field("row", Schema.INT32_SCHEMA).field("snapshot", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("thread", Schema.OPTIONAL_INT64_SCHEMA).field("db", Schema.OPTIONAL_STRING_SCHEMA).field("table", Schema.OPTIONAL_STRING_SCHEMA).build();
    private String currentGtidSet;
    private String currentGtid;
    private String currentBinlogFilename;
    private long currentBinlogPosition = 0L;
    private int currentRowNumber = 0;
    private long currentEventLengthInBytes = 0L;
    private String restartGtidSet;
    private String restartBinlogFilename;
    private long restartBinlogPosition = 0L;
    private long restartEventsToSkip = 0L;
    private int restartRowsToSkip = 0;
    private boolean inTransaction = false;
    private String serverName;
    private long serverId = 0L;
    private long binlogTimestampSeconds = 0L;
    private long threadId = -1L;
    private Map<String, String> sourcePartition;
    private boolean lastSnapshot = true;
    private boolean nextSnapshot = false;

    public void setServerName(String logicalId) {
        this.serverName = logicalId;
        this.sourcePartition = Collect.hashMapOf(SERVER_PARTITION_KEY, this.serverName);
    }

    public Map<String, String> partition() {
        return this.sourcePartition;
    }

    public void setBinlogStartPoint(String binlogFilename, long positionOfFirstEvent) {
        if (binlogFilename != null) {
            this.currentBinlogFilename = binlogFilename;
            this.restartBinlogFilename = binlogFilename;
        }
        assert (positionOfFirstEvent >= 0L);
        this.currentBinlogPosition = positionOfFirstEvent;
        this.restartBinlogPosition = positionOfFirstEvent;
        this.currentRowNumber = 0;
        this.restartRowsToSkip = 0;
    }

    public void setEventPosition(long positionOfCurrentEvent, long eventSizeInBytes) {
        this.currentBinlogPosition = positionOfCurrentEvent;
        this.currentEventLengthInBytes = eventSizeInBytes;
        if (!this.inTransaction) {
            this.restartBinlogPosition = positionOfCurrentEvent + eventSizeInBytes;
        }
    }

    public Map<String, ?> offset() {
        return this.offsetUsingPosition(this.restartRowsToSkip);
    }

    public Map<String, ?> offsetForRow(int eventRowNumber, int totalNumberOfRows) {
        if (eventRowNumber < totalNumberOfRows - 1) {
            this.currentRowNumber = eventRowNumber;
            this.restartRowsToSkip = this.currentRowNumber + 1;
            return this.offsetUsingPosition(this.restartRowsToSkip);
        }
        this.currentRowNumber = eventRowNumber;
        this.restartRowsToSkip = 0;
        return this.offsetUsingPosition(totalNumberOfRows);
    }

    private Map<String, ?> offsetUsingPosition(long rowsToSkip) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.serverId != 0L) {
            map.put(SERVER_ID_KEY, this.serverId);
        }
        if (this.restartGtidSet != null) {
            map.put(GTID_SET_KEY, this.restartGtidSet);
        }
        map.put(BINLOG_FILENAME_OFFSET_KEY, this.restartBinlogFilename);
        map.put(BINLOG_POSITION_OFFSET_KEY, this.restartBinlogPosition);
        if (this.restartEventsToSkip != 0L) {
            map.put(EVENTS_TO_SKIP_OFFSET_KEY, this.restartEventsToSkip);
        }
        if (rowsToSkip != 0L) {
            map.put(BINLOG_ROW_IN_EVENT_OFFSET_KEY, rowsToSkip);
        }
        if (this.binlogTimestampSeconds != 0L) {
            map.put(TIMESTAMP_KEY, this.binlogTimestampSeconds);
        }
        if (this.isSnapshotInEffect()) {
            map.put(SNAPSHOT_KEY, true);
        }
        return map;
    }

    public Schema schema() {
        return SCHEMA;
    }

    public Struct struct() {
        return this.struct(null);
    }

    public Struct struct(TableId tableId) {
        assert (this.serverName != null);
        Struct result = new Struct(SCHEMA);
        result.put(SERVER_NAME_KEY, (Object)this.serverName);
        result.put(SERVER_ID_KEY, (Object)this.serverId);
        if (this.currentGtid != null) {
            result.put(GTID_KEY, (Object)this.currentGtid);
        }
        result.put(BINLOG_FILENAME_OFFSET_KEY, (Object)this.currentBinlogFilename);
        result.put(BINLOG_POSITION_OFFSET_KEY, (Object)this.currentBinlogPosition);
        result.put(BINLOG_ROW_IN_EVENT_OFFSET_KEY, (Object)this.currentRowNumber);
        result.put(TIMESTAMP_KEY, (Object)this.binlogTimestampSeconds);
        if (this.lastSnapshot) {
            result.put(SNAPSHOT_KEY, (Object)true);
        }
        if (this.threadId >= 0L) {
            result.put(THREAD_KEY, (Object)this.threadId);
        }
        if (tableId != null) {
            result.put(DB_NAME_KEY, (Object)tableId.catalog());
            result.put(TABLE_NAME_KEY, (Object)tableId.table());
        }
        return result;
    }

    public boolean isSnapshotInEffect() {
        return this.nextSnapshot;
    }

    public void startNextTransaction() {
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.restartBinlogFilename = this.currentBinlogFilename;
        this.restartBinlogPosition = this.currentBinlogPosition;
        this.inTransaction = true;
    }

    public void completeEvent() {
        ++this.restartEventsToSkip;
    }

    public long eventsToSkipUponRestart() {
        return this.restartEventsToSkip;
    }

    public void commitTransaction() {
        this.restartGtidSet = this.currentGtidSet;
        this.restartBinlogFilename = this.currentBinlogFilename;
        this.restartBinlogPosition = this.currentBinlogPosition + this.currentEventLengthInBytes;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.inTransaction = false;
    }

    public void startGtid(String gtid, String gtidSet) {
        this.currentGtid = gtid;
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet = gtidSet.replaceAll("\n", "").replaceAll("\r", "");
            this.restartGtidSet = this.currentGtidSet != null ? this.currentGtidSet : trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet;
        }
    }

    public void setCompletedGtidSet(String gtidSet) {
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet = gtidSet.replaceAll("\n", "").replaceAll("\r", "");
            this.restartGtidSet = trimmedGtidSet;
        }
    }

    public void setBinlogServerId(long serverId) {
        this.serverId = serverId;
    }

    public void setBinlogTimestampSeconds(long timestampInSeconds) {
        this.binlogTimestampSeconds = timestampInSeconds;
    }

    public void setBinlogThread(long threadId) {
        this.threadId = threadId;
    }

    public void startSnapshot() {
        this.lastSnapshot = true;
        this.nextSnapshot = true;
    }

    public void markLastSnapshot() {
        this.lastSnapshot = true;
        this.nextSnapshot = false;
    }

    public void completeSnapshot() {
        this.lastSnapshot = false;
        this.nextSnapshot = false;
    }

    public void setOffset(Map<String, ?> sourceOffset) {
        if (sourceOffset != null) {
            this.setCompletedGtidSet((String)sourceOffset.get(GTID_SET_KEY));
            this.restartEventsToSkip = this.longOffsetValue(sourceOffset, EVENTS_TO_SKIP_OFFSET_KEY);
            String binlogFilename = (String)sourceOffset.get(BINLOG_FILENAME_OFFSET_KEY);
            if (binlogFilename == null) {
                throw new ConnectException("Source offset 'file' parameter is missing");
            }
            long binlogPosition = this.longOffsetValue(sourceOffset, BINLOG_POSITION_OFFSET_KEY);
            this.setBinlogStartPoint(binlogFilename, binlogPosition);
            this.restartRowsToSkip = (int)this.longOffsetValue(sourceOffset, BINLOG_ROW_IN_EVENT_OFFSET_KEY);
            this.lastSnapshot = this.nextSnapshot = this.booleanOffsetValue(sourceOffset, SNAPSHOT_KEY);
        }
    }

    private long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    private boolean booleanOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    public String gtidSet() {
        return this.currentGtidSet != null ? this.currentGtidSet : null;
    }

    public String binlogFilename() {
        return this.restartBinlogFilename;
    }

    public long binlogPosition() {
        return this.restartBinlogPosition;
    }

    protected long restartBinlogPosition() {
        return this.restartBinlogPosition;
    }

    public int rowsToSkipUponRestart() {
        return this.restartRowsToSkip;
    }

    public String serverName() {
        return this.serverName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.currentGtidSet != null) {
            sb.append("GTIDs ");
            sb.append(this.currentGtidSet);
            sb.append(" and binlog file '").append(this.restartBinlogFilename).append("'");
            sb.append(", pos=").append(this.restartBinlogPosition);
            sb.append(", skipping ").append(this.restartEventsToSkip);
            sb.append(" events plus ").append(this.restartRowsToSkip);
            sb.append(" rows");
        } else if (this.restartBinlogFilename == null) {
            sb.append("<latest>");
        } else if ("".equals(this.restartBinlogFilename)) {
            sb.append("earliest binlog file and position");
        } else {
            sb.append("binlog file '").append(this.restartBinlogFilename).append("'");
            sb.append(", pos=").append(this.restartBinlogPosition);
            sb.append(", skipping ").append(this.restartEventsToSkip);
            sb.append(" events plus ").append(this.restartRowsToSkip);
            sb.append(" rows");
        }
        return sb.toString();
    }

    public static boolean isPositionAtOrBefore(Document recorded, Document desired, Predicate<String> gtidFilter) {
        int desiredRow;
        int desiredEventCount;
        int desiredPosition;
        int desiredServerId;
        String recordedGtidSetStr = recorded.getString(GTID_SET_KEY);
        String desiredGtidSetStr = desired.getString(GTID_SET_KEY);
        if (desiredGtidSetStr != null) {
            if (recordedGtidSetStr != null) {
                GtidSet recordedGtidSet = new GtidSet(recordedGtidSetStr);
                GtidSet desiredGtidSet = new GtidSet(desiredGtidSetStr);
                if (gtidFilter != null) {
                    recordedGtidSet = recordedGtidSet.retainAll(gtidFilter);
                    desiredGtidSet = desiredGtidSet.retainAll(gtidFilter);
                }
                if (recordedGtidSet.equals(desiredGtidSet)) {
                    int desiredEventCount2;
                    if (!recorded.has(SNAPSHOT_KEY) && desired.has(SNAPSHOT_KEY)) {
                        return false;
                    }
                    int recordedEventCount = recorded.getInteger(EVENTS_TO_SKIP_OFFSET_KEY, 0);
                    int diff = recordedEventCount - (desiredEventCount2 = desired.getInteger(EVENTS_TO_SKIP_OFFSET_KEY, 0));
                    return diff <= 0;
                }
                return recordedGtidSet.isContainedWithin(desiredGtidSet);
            }
            return true;
        }
        if (recordedGtidSetStr != null) {
            return false;
        }
        int recordedServerId = recorded.getInteger(SERVER_ID_KEY, 0);
        if (recordedServerId != (desiredServerId = recorded.getInteger(SERVER_ID_KEY, 0))) {
            long desiredTimestamp;
            long recordedTimestamp = recorded.getLong(TIMESTAMP_KEY, 0L);
            return recordedTimestamp <= (desiredTimestamp = recorded.getLong(TIMESTAMP_KEY, 0L));
        }
        String recordedFilename = recorded.getString(BINLOG_FILENAME_OFFSET_KEY);
        String desiredFilename = desired.getString(BINLOG_FILENAME_OFFSET_KEY);
        assert (recordedFilename != null);
        int diff = recordedFilename.compareToIgnoreCase(desiredFilename);
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedPosition = recorded.getInteger(BINLOG_POSITION_OFFSET_KEY, -1);
        diff = recordedPosition - (desiredPosition = desired.getInteger(BINLOG_POSITION_OFFSET_KEY, -1));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedEventCount = recorded.getInteger(EVENTS_TO_SKIP_OFFSET_KEY, 0);
        diff = recordedEventCount - (desiredEventCount = desired.getInteger(EVENTS_TO_SKIP_OFFSET_KEY, 0));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedRow = recorded.getInteger(BINLOG_ROW_IN_EVENT_OFFSET_KEY, -1);
        diff = recordedRow - (desiredRow = desired.getInteger(BINLOG_ROW_IN_EVENT_OFFSET_KEY, -1));
        return diff <= 0;
    }
}

