/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;

@Immutable
public final class TableId
implements Comparable<TableId> {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String id;

    public static TableId parse(String str) {
        return TableId.parse(str, true);
    }

    public static TableId parse(String str, boolean useCatalogBeforeSchema) {
        String[] parts = str.split("[\\.]");
        if (parts.length < 0) {
            return null;
        }
        return TableId.parse(parts, parts.length, useCatalogBeforeSchema);
    }

    protected static TableId parse(String[] parts, int numParts, boolean useCatalogBeforeSchema) {
        if (numParts == 0) {
            return null;
        }
        if (numParts == 1) {
            return new TableId(null, null, parts[0]);
        }
        if (numParts == 2) {
            if (useCatalogBeforeSchema) {
                return new TableId(parts[0], null, parts[1]);
            }
            return new TableId(null, parts[0], parts[1]);
        }
        return new TableId(parts[0], parts[1], parts[2]);
    }

    public TableId(String catalogName, String schemaName, String tableName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        assert (this.tableName != null);
        this.id = TableId.tableId(this.catalogName, this.schemaName, this.tableName);
    }

    public String catalog() {
        return this.catalogName;
    }

    public String schema() {
        return this.schemaName;
    }

    public String table() {
        return this.tableName;
    }

    @Override
    public int compareTo(TableId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public int compareToIgnoreCase(TableId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareToIgnoreCase(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableId) {
            return this.compareTo((TableId)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    private static String tableId(String catalog, String schema, String table) {
        if (catalog == null || catalog.length() == 0) {
            if (schema == null || schema.length() == 0) {
                return table;
            }
            return schema + "." + table;
        }
        if (schema == null || schema.length() == 0) {
            return catalog + "." + table;
        }
        return catalog + "." + schema + "." + table;
    }
}

