/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import java.time.temporal.ChronoUnit;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class MicroDuration {
    public static final String SCHEMA_NAME = "io.debezium.time.MicroDuration";

    public static SchemaBuilder builder() {
        return SchemaBuilder.float64().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return MicroDuration.builder().build();
    }

    private MicroDuration() {
    }

    public static double durationMicros(int years, int months, int days, int hours, int minutes, double seconds, Double daysPerMonthAvg) {
        if (daysPerMonthAvg == null) {
            daysPerMonthAvg = ChronoUnit.MONTHS.getDuration().toDays();
        }
        double numberOfDays = (double)(years * 12 + months) * daysPerMonthAvg + (double)days;
        double numberOfSeconds = ((numberOfDays * 24.0 + (double)hours) * 60.0 + (double)minutes) * 60.0 + seconds;
        return numberOfSeconds * 1000000.0;
    }
}

