/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.time.LocalDateTime;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class MicroTimestamp {
    public static final String SCHEMA_NAME = "io.debezium.time.MicroTimestamp";

    public static SchemaBuilder builder() {
        return SchemaBuilder.int64().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return MicroTimestamp.builder().build();
    }

    public static long toEpochMicros(Object value) {
        LocalDateTime dateTime = Conversions.toLocalDateTime(value);
        long epochNanos = Conversions.toEpochNanos(dateTime);
        return Math.floorDiv(epochNanos, Conversions.NANOSECONDS_PER_MICROSECOND);
    }

    private MicroTimestamp() {
    }
}

