/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.annotation.ThreadSafe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
@ThreadSafe
public interface AvroValidator {
    public static final AvroValidator DEFAULT = AvroValidator.create(LoggerFactory.getLogger(AvroValidator.class));

    public String validate(String var1);

    public static AvroValidator defaultValidator() {
        return DEFAULT;
    }

    public static AvroValidator create(Logger logger2) {
        return AvroValidator.create(logger2, (String original, String replacement, String conflict) -> {
            String msg = "The Kafka Connect schema name '" + original + "' is not a valid Avro schema name and its replacement '" + replacement + "' conflicts with another different schema '" + conflict + "'";
            throw new ConnectException(msg);
        });
    }

    public static AvroValidator create(Logger logger2, ReplacementOccurred uponConflict) {
        ReplacementOccurred handler = (original, replacement, conflictsWith) -> {
            if (conflictsWith != null) {
                logger2.error("The Kafka Connect schema name '{}' is not a valid Avro schema name and its replacement '{}' conflicts with another different schema '{}'", original, replacement, conflictsWith);
                if (uponConflict != null) {
                    uponConflict.accept(original, replacement, conflictsWith);
                }
            } else {
                logger2.warn("The Kafka Connect schema name '{}' is not a valid Avro schema name, so replacing with '{}'", (Object)original, (Object)replacement);
            }
        };
        return AvroValidator.create(handler.firstTimeOnly());
    }

    public static AvroValidator create(ReplacementOccurred uponReplacement) {
        return AvroValidator.create("_", uponReplacement);
    }

    public static AvroValidator create(char replacement, ReplacementOccurred uponReplacement) {
        String replacementStr = "" + replacement;
        return original -> AvroValidator.validFullname(original, c -> replacementStr, uponReplacement);
    }

    public static AvroValidator create(String replacement, ReplacementOccurred uponReplacement) {
        return original -> AvroValidator.validFullname(original, c -> replacement, uponReplacement);
    }

    public static AvroValidator create(ReplacementFunction function, ReplacementOccurred uponReplacement) {
        return original -> AvroValidator.validFullname(original, function, uponReplacement);
    }

    public static boolean isValidFullname(String fullname) {
        if (fullname.length() == 0) {
            return true;
        }
        char c = fullname.charAt(0);
        if (!AvroValidator.isValidFullnameFirstCharacter(c)) {
            return false;
        }
        for (int i = 1; i != fullname.length(); ++i) {
            c = fullname.charAt(i);
            if (AvroValidator.isValidFullnameNonFirstCharacter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFullnameFirstCharacter(char c) {
        return c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isValidFullnameNonFirstCharacter(char c) {
        return c == '.' || AvroValidator.isValidFullnameFirstCharacter(c) || c >= '0' && c <= '9';
    }

    public static String validFullname(String proposedName) {
        return AvroValidator.validFullname(proposedName, "_");
    }

    public static String validFullname(String proposedName, String replacement) {
        return AvroValidator.validFullname(proposedName, (char c) -> replacement);
    }

    public static String validFullname(String proposedName, ReplacementFunction replacement) {
        return AvroValidator.validFullname(proposedName, replacement, null);
    }

    public static String validFullname(String proposedName, ReplacementFunction replacement, ReplacementOccurred uponReplacement) {
        if (proposedName.length() == 0) {
            return proposedName;
        }
        StringBuilder sb = new StringBuilder();
        char c = proposedName.charAt(0);
        boolean changed = false;
        if (AvroValidator.isValidFullnameFirstCharacter(c)) {
            sb.append(c);
        } else {
            sb.append(replacement.replace(c));
            changed = true;
        }
        for (int i = 1; i != proposedName.length(); ++i) {
            c = proposedName.charAt(i);
            if (AvroValidator.isValidFullnameNonFirstCharacter(c)) {
                sb.append(c);
                continue;
            }
            sb.append(replacement.replace(c));
            changed = true;
        }
        if (!changed) {
            return proposedName;
        }
        String result = sb.toString();
        if (uponReplacement != null) {
            uponReplacement.accept(proposedName, result, null);
        }
        return result;
    }

    @FunctionalInterface
    @ThreadSafe
    public static interface ReplacementOccurred {
        public void accept(String var1, String var2, String var3);

        default public ReplacementOccurred firstTimeOnly() {
            ReplacementOccurred delegate = this;
            Set alreadySeen = Collections.newSetFromMap(new ConcurrentHashMap());
            ConcurrentHashMap originalByReplacement = new ConcurrentHashMap();
            return (original, replacement, conflictsWith) -> {
                if (alreadySeen.add(original)) {
                    String replacementsOriginal = originalByReplacement.put(replacement, original);
                    if (replacementsOriginal == null || original.equals(replacementsOriginal)) {
                        delegate.accept(original, replacement, null);
                    } else {
                        delegate.accept(original, replacement, replacementsOriginal);
                    }
                }
            };
        }

        default public ReplacementOccurred andThen(ReplacementOccurred next) {
            if (next == null) {
                return this;
            }
            return (original, replacement, conflictsWith) -> {
                this.accept(original, replacement, conflictsWith);
                next.accept(original, replacement, conflictsWith);
            };
        }
    }

    @FunctionalInterface
    @ThreadSafe
    public static interface ReplacementFunction {
        public String replace(char var1);
    }
}

