/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.PathResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeEvent;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.xnio.FileChangeCallback;
import org.xnio.FileChangeEvent;
import org.xnio.FileSystemWatcher;
import org.xnio.OptionMap;
import org.xnio.Xnio;

public class PathResourceManager
implements ResourceManager {
    private static final boolean DEFAULT_CHANGE_LISTENERS_ALLOWED = !Boolean.getBoolean("io.undertow.disable-file-system-watcher");
    private final List<ResourceChangeListener> listeners = new ArrayList<ResourceChangeListener>();
    private FileSystemWatcher fileSystemWatcher;
    protected volatile String base;
    private final long transferMinSize;
    private final boolean caseSensitive;
    private final boolean followLinks;
    private final TreeSet<String> safePaths = new TreeSet();
    private final boolean allowResourceChangeListeners;

    public PathResourceManager(Path base) {
        this(base, 1024L, true, false, null);
    }

    public PathResourceManager(Path base, long transferMinSize) {
        this(base, transferMinSize, true, false, null);
    }

    public PathResourceManager(Path base, long transferMinSize, boolean caseSensitive) {
        this(base, transferMinSize, caseSensitive, false, null);
    }

    public PathResourceManager(Path base, long transferMinSize, boolean followLinks, String ... safePaths) {
        this(base, transferMinSize, true, followLinks, safePaths);
    }

    protected PathResourceManager(long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        this(transferMinSize, caseSensitive, followLinks, DEFAULT_CHANGE_LISTENERS_ALLOWED, safePaths);
    }

    protected PathResourceManager(long transferMinSize, boolean caseSensitive, boolean followLinks, boolean allowResourceChangeListeners, String ... safePaths) {
        this.caseSensitive = caseSensitive;
        this.followLinks = followLinks;
        this.transferMinSize = transferMinSize;
        this.allowResourceChangeListeners = allowResourceChangeListeners;
        if (this.followLinks) {
            if (safePaths == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            for (String safePath : safePaths) {
                if (safePath != null) continue;
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            this.safePaths.addAll(Arrays.asList(safePaths));
        }
    }

    public PathResourceManager(Path base, long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        this(base, transferMinSize, caseSensitive, followLinks, DEFAULT_CHANGE_LISTENERS_ALLOWED, safePaths);
    }

    public PathResourceManager(Path base, long transferMinSize, boolean caseSensitive, boolean followLinks, boolean allowResourceChangeListeners, String ... safePaths) {
        this.allowResourceChangeListeners = allowResourceChangeListeners;
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.normalize().toAbsolutePath().toString();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        this.base = basePath;
        this.transferMinSize = transferMinSize;
        this.caseSensitive = caseSensitive;
        this.followLinks = followLinks;
        if (this.followLinks) {
            if (safePaths == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            for (String safePath : safePaths) {
                if (safePath != null) continue;
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            this.safePaths.addAll(Arrays.asList(safePaths));
        }
    }

    public Path getBasePath() {
        return Paths.get(this.base, new String[0]);
    }

    public PathResourceManager setBase(Path base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.toAbsolutePath().toString();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        this.base = basePath;
        return this;
    }

    public PathResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        this.base = basePath;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        String path = p.startsWith("/") ? p.substring(1) : p;
        try {
            Path file = Paths.get(this.base, path);
            String normalizedFile = file.normalize().toString();
            if (!normalizedFile.startsWith(this.base)) {
                if (normalizedFile.length() == this.base.length() - 1) {
                    if (!this.base.startsWith(normalizedFile)) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (Files.exists(file, new LinkOption[0])) {
                if (path.endsWith(File.separator) && !Files.isDirectory(file, new LinkOption[0])) {
                    return null;
                }
                boolean followAll = this.followLinks && this.safePaths.isEmpty();
                SymlinkResult symlinkBase = this.getSymlinkBase(this.base, file);
                if (!followAll && symlinkBase != null && symlinkBase.requiresCheck) {
                    if (this.followLinks && this.isSymlinkSafe(file)) {
                        return this.getFileResource(file, path, symlinkBase.path, normalizedFile);
                    }
                } else {
                    return this.getFileResource(file, path, symlinkBase == null ? null : symlinkBase.path, normalizedFile);
                }
            }
            return null;
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Invalid path %s", new Object[0]);
            return null;
        }
    }

    @Override
    public boolean isResourceChangeListenerSupported() {
        return this.allowResourceChangeListeners;
    }

    @Override
    public synchronized void registerResourceChangeListener(ResourceChangeListener listener) {
        if (!this.allowResourceChangeListeners) {
            return;
        }
        this.listeners.add(listener);
        if (this.fileSystemWatcher == null) {
            this.fileSystemWatcher = Xnio.getInstance().createFileSystemWatcher("Watcher for " + this.base, OptionMap.EMPTY);
            this.fileSystemWatcher.watchPath(new File(this.base), new FileChangeCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleChanges(Collection<FileChangeEvent> changes) {
                    PathResourceManager pathResourceManager = PathResourceManager.this;
                    synchronized (pathResourceManager) {
                        ArrayList<ResourceChangeEvent> events = new ArrayList<ResourceChangeEvent>();
                        for (FileChangeEvent change : changes) {
                            if (!change.getFile().getAbsolutePath().startsWith(PathResourceManager.this.base)) continue;
                            String path = change.getFile().getAbsolutePath().substring(PathResourceManager.this.base.length());
                            events.add(new ResourceChangeEvent(path, ResourceChangeEvent.Type.valueOf(change.getType().name())));
                        }
                        for (ResourceChangeListener listener : PathResourceManager.this.listeners) {
                            listener.handleChanges(events);
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void removeResourceChangeListener(ResourceChangeListener listener) {
        if (!this.allowResourceChangeListeners) {
            return;
        }
        this.listeners.remove(listener);
    }

    public long getTransferMinSize() {
        return this.transferMinSize;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fileSystemWatcher != null) {
            this.fileSystemWatcher.close();
        }
    }

    private SymlinkResult getSymlinkBase(String base, Path file) throws IOException {
        int nameCount = file.getNameCount();
        Path root = Paths.get(base, new String[0]);
        int rootCount = root.getNameCount();
        Path f = file;
        for (int i = nameCount - 1; i >= 0; --i) {
            if (Files.isSymbolicLink(f)) {
                return new SymlinkResult(i + 1 > rootCount, f);
            }
            f = f.getParent();
        }
        return null;
    }

    private boolean isFileSameCase(Path file, String normalizeFile) throws IOException {
        String canonicalName = file.toRealPath(new LinkOption[0]).toString();
        return canonicalName.equals(normalizeFile);
    }

    private boolean isSymlinkSafe(Path file) throws IOException {
        String canonicalPath = file.toRealPath(new LinkOption[0]).toString();
        for (String safePath : this.safePaths) {
            String absSafePath;
            Path absSafePathFile;
            String canonicalSafePath;
            if (safePath.length() <= 0 || !(safePath.charAt(0) == File.separatorChar ? safePath.length() > 0 && canonicalPath.length() >= safePath.length() && canonicalPath.startsWith(safePath) : (canonicalSafePath = (absSafePathFile = Paths.get(absSafePath = this.base + File.separatorChar + safePath, new String[0])).toRealPath(new LinkOption[0]).toString()).length() > 0 && canonicalPath.length() >= canonicalSafePath.length() && canonicalPath.startsWith(canonicalSafePath))) continue;
            return true;
        }
        return false;
    }

    protected PathResource getFileResource(Path file, String path, Path symlinkBase, String normalizedFile) throws IOException {
        if (this.caseSensitive) {
            if (symlinkBase != null) {
                String symlinkBaseResolved;
                String relative = symlinkBase.relativize(file.normalize()).toString();
                String fileResolved = file.toRealPath(new LinkOption[0]).toString();
                if (!fileResolved.startsWith(symlinkBaseResolved = symlinkBase.toRealPath(new LinkOption[0]).toString())) {
                    return null;
                }
                String compare = fileResolved.substring(symlinkBaseResolved.length());
                if (compare.startsWith(File.separator)) {
                    compare = compare.substring(1);
                }
                if (relative.startsWith(File.separator)) {
                    relative = relative.substring(1);
                }
                if (relative.equals(compare)) {
                    return new PathResource(file, this, path);
                }
                return null;
            }
            if (this.isFileSameCase(file, normalizedFile)) {
                return new PathResource(file, this, path);
            }
            return null;
        }
        return new PathResource(file, this, path);
    }

    private static class SymlinkResult {
        public final boolean requiresCheck;
        public final Path path;

        private SymlinkResult(boolean requiresCheck, Path path) {
            this.requiresCheck = requiresCheck;
            this.path = path;
        }
    }
}

