/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.ensemble.exhibitor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.RetryLoop;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.ExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.Exhibitors;
import org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhibitorEnsembleProvider
implements EnsembleProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<Exhibitors> exhibitors = new AtomicReference();
    private final AtomicReference<Exhibitors> masterExhibitors = new AtomicReference();
    private final ExhibitorRestClient restClient;
    private final String restUriPath;
    private final int pollingMs;
    private final RetryPolicy retryPolicy;
    private final ScheduledExecutorService service = ThreadUtils.newSingleThreadScheduledExecutor("ExhibitorEnsembleProvider");
    private final Random random = new Random();
    private final AtomicReference<String> connectionString = new AtomicReference<String>("");
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private static final String MIME_TYPE = "application/x-www-form-urlencoded";
    private static final String VALUE_PORT = "port";
    private static final String VALUE_COUNT = "count";
    private static final String VALUE_SERVER_PREFIX = "server";

    public ExhibitorEnsembleProvider(Exhibitors exhibitors, ExhibitorRestClient restClient, String restUriPath, int pollingMs, RetryPolicy retryPolicy) {
        this.exhibitors.set(exhibitors);
        this.masterExhibitors.set(exhibitors);
        this.restClient = restClient;
        this.restUriPath = restUriPath;
        this.pollingMs = pollingMs;
        this.retryPolicy = retryPolicy;
    }

    public void setExhibitors(Exhibitors newExhibitors) {
        this.exhibitors.set(newExhibitors);
        this.masterExhibitors.set(newExhibitors);
    }

    public void pollForInitialEnsemble() throws Exception {
        Preconditions.checkState(this.state.get() == State.LATENT, "Cannot be called after start()");
        this.poll();
    }

    @Override
    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.service.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ExhibitorEnsembleProvider.this.poll();
            }
        }, this.pollingMs, this.pollingMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState(this.state.compareAndSet(State.STARTED, State.CLOSED), "Already closed or has not been started");
        this.service.shutdownNow();
    }

    @Override
    public String getConnectionString() {
        return this.connectionString.get();
    }

    @Override
    public void setConnectionString(String connectionString) {
        this.log.info("setConnectionString received. Ignoring. " + connectionString);
    }

    @Override
    public boolean updateServerListEnabled() {
        return false;
    }

    @VisibleForTesting
    protected void poll() {
        Exhibitors localExhibitors = this.exhibitors.get();
        Map<String, String> values = this.queryExhibitors(localExhibitors);
        int count = this.getCountFromValues(values);
        if (count == 0) {
            this.log.warn("0 count returned from Exhibitors. Using backup connection values.");
            values = this.useBackup(localExhibitors);
            count = this.getCountFromValues(values);
        }
        if (count > 0) {
            int port = Integer.parseInt(values.get(VALUE_PORT));
            StringBuilder newConnectionString = new StringBuilder();
            ArrayList<String> newHostnames = Lists.newArrayList();
            for (int i = 0; i < count; ++i) {
                if (newConnectionString.length() > 0) {
                    newConnectionString.append(",");
                }
                String server = values.get(VALUE_SERVER_PREFIX + i);
                newConnectionString.append(server).append(":").append(port);
                newHostnames.add(server);
            }
            String newConnectionStringValue = newConnectionString.toString();
            if (!newConnectionStringValue.equals(this.connectionString.get())) {
                this.log.info(String.format("Connection string has changed. Old value (%s), new value (%s)", this.connectionString.get(), newConnectionStringValue));
            }
            Exhibitors newExhibitors = new Exhibitors(newHostnames, localExhibitors.getRestPort(), new Exhibitors.BackupConnectionStringProvider(){

                @Override
                public String getBackupConnectionString() throws Exception {
                    return ((Exhibitors)ExhibitorEnsembleProvider.this.masterExhibitors.get()).getBackupConnectionString();
                }
            });
            this.connectionString.set(newConnectionStringValue);
            this.exhibitors.set(newExhibitors);
        }
    }

    private int getCountFromValues(Map<String, String> values) {
        try {
            return Integer.parseInt(values.get(VALUE_COUNT));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private Map<String, String> useBackup(Exhibitors localExhibitors) {
        Map<String, String> values = this.newValues();
        try {
            String backupConnectionString = localExhibitors.getBackupConnectionString();
            int thePort = -1;
            int count = 0;
            for (String spec : backupConnectionString.split(",")) {
                String[] parts = (spec = spec.trim()).split(":");
                if (parts.length == 2) {
                    String hostname = parts[0];
                    int port = Integer.parseInt(parts[1]);
                    if (thePort < 0) {
                        thePort = port;
                    } else if (port != thePort) {
                        this.log.warn("Inconsistent port in connection component: " + spec);
                    }
                    values.put(VALUE_SERVER_PREFIX + count, hostname);
                    ++count;
                    continue;
                }
                this.log.warn("Bad backup connection component: " + spec);
            }
            values.put(VALUE_COUNT, Integer.toString(count));
            values.put(VALUE_PORT, Integer.toString(thePort));
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            this.log.error("Couldn't get backup connection string", e);
        }
        return values;
    }

    private Map<String, String> newValues() {
        HashMap<String, String> values = Maps.newHashMap();
        values.put(VALUE_COUNT, "0");
        return values;
    }

    private static Map<String, String> decodeExhibitorList(String str) throws UnsupportedEncodingException {
        HashMap<String, String> values = Maps.newHashMap();
        for (String spec : str.split("&")) {
            String[] parts = spec.split("=");
            if (parts.length != 2) continue;
            values.put(parts[0], URLDecoder.decode(parts[1], "UTF-8"));
        }
        return values;
    }

    private Map<String, String> queryExhibitors(Exhibitors localExhibitors) {
        Map<String, String> values = this.newValues();
        long start = System.currentTimeMillis();
        int retries = 0;
        boolean done = false;
        while (!done) {
            ArrayList<String> hostnames = Lists.newArrayList(localExhibitors.getHostnames());
            if (hostnames.size() == 0) {
                done = true;
                continue;
            }
            String hostname = (String)hostnames.get(this.random.nextInt(hostnames.size()));
            try {
                String encoded = this.restClient.getRaw(hostname, localExhibitors.getRestPort(), this.restUriPath, MIME_TYPE);
                values.putAll(ExhibitorEnsembleProvider.decodeExhibitorList(encoded));
                done = true;
            }
            catch (Throwable e) {
                ThreadUtils.checkInterrupted(e);
                if (this.retryPolicy.allowRetry(retries++, System.currentTimeMillis() - start, RetryLoop.getDefaultRetrySleeper())) {
                    this.log.warn("Couldn't get servers from Exhibitor. Retrying.", e);
                    continue;
                }
                this.log.error("Couldn't get servers from Exhibitor. Giving up.", e);
                done = true;
            }
        }
        return values;
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

