/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import org.apache.curator.framework.imps.BackgroundSyncImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.InternalConnectionHandler;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.state.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassicInternalConnectionHandler
implements InternalConnectionHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    ClassicInternalConnectionHandler() {
    }

    @Override
    public void checkNewConnection(CuratorFrameworkImpl client) {
    }

    @Override
    public void suspendConnection(CuratorFrameworkImpl client) {
        if (client.setToSuspended()) {
            this.doSyncForSuspendedConnection(client, client.getZookeeperClient().getInstanceIndex());
        }
    }

    private void doSyncForSuspendedConnection(final CuratorFrameworkImpl client, final long instanceIndex) {
        BackgroundSyncImpl operation = new BackgroundSyncImpl(client, null);
        OperationAndData.ErrorCallback<String> errorCallback = new OperationAndData.ErrorCallback<String>(){

            @Override
            public void retriesExhausted(OperationAndData<String> operationAndData) {
                if (instanceIndex < 0L || instanceIndex == client.getZookeeperClient().getInstanceIndex()) {
                    client.addStateChange(ConnectionState.LOST);
                } else {
                    ClassicInternalConnectionHandler.this.log.debug("suspendConnection() failure ignored as the ZooKeeper instance was reset. Retrying.");
                    ClassicInternalConnectionHandler.this.doSyncForSuspendedConnection(client, -1L);
                }
            }
        };
        client.performBackgroundOperation(new OperationAndData<String>(operation, "/", null, errorCallback, null, null));
    }
}

