/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.barriers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class DistributedDoubleBarrier {
    private final CuratorFramework client;
    private final String barrierPath;
    private final int memberQty;
    private final String ourPath;
    private final String readyPath;
    private final AtomicBoolean hasBeenNotified = new AtomicBoolean(false);
    private final AtomicBoolean connectionLost = new AtomicBoolean(false);
    private final Watcher watcher = new Watcher(){

        @Override
        public void process(WatchedEvent event) {
            DistributedDoubleBarrier.this.connectionLost.set(event.getState() != Watcher.Event.KeeperState.SyncConnected);
            DistributedDoubleBarrier.this.notifyFromWatcher();
        }
    };
    private static final String READY_NODE = "ready";

    public DistributedDoubleBarrier(CuratorFramework client, String barrierPath, int memberQty) {
        Preconditions.checkState(memberQty > 0, "memberQty cannot be 0");
        this.client = client;
        this.barrierPath = PathUtils.validatePath(barrierPath);
        this.memberQty = memberQty;
        this.ourPath = ZKPaths.makePath(barrierPath, UUID.randomUUID().toString());
        this.readyPath = ZKPaths.makePath(barrierPath, READY_NODE);
    }

    public void enter() throws Exception {
        this.enter(-1L, null);
    }

    public boolean enter(long maxWait, TimeUnit unit) throws Exception {
        boolean result;
        long startMs = System.currentTimeMillis();
        boolean hasMaxWait = unit != null;
        long maxWaitMs = hasMaxWait ? TimeUnit.MILLISECONDS.convert(maxWait, unit) : Long.MAX_VALUE;
        boolean readyPathExists = ((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).forPath(this.readyPath) != null;
        ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.ourPath);
        boolean bl = result = readyPathExists || this.internalEnter(startMs, hasMaxWait, maxWaitMs);
        if (this.connectionLost.get()) {
            throw new KeeperException.ConnectionLossException();
        }
        return result;
    }

    public synchronized void leave() throws Exception {
        this.leave(-1L, null);
    }

    public synchronized boolean leave(long maxWait, TimeUnit unit) throws Exception {
        long startMs = System.currentTimeMillis();
        boolean hasMaxWait = unit != null;
        long maxWaitMs = hasMaxWait ? TimeUnit.MILLISECONDS.convert(maxWait, unit) : Long.MAX_VALUE;
        return this.internalLeave(startMs, hasMaxWait, maxWaitMs);
    }

    @VisibleForTesting
    protected List<String> getChildrenForEntering() throws Exception {
        return (List)this.client.getChildren().forPath(this.barrierPath);
    }

    private List<String> filterAndSortChildren(List<String> children) {
        Iterable<String> filtered = Iterables.filter(children, new Predicate<String>(){

            @Override
            public boolean apply(String name) {
                return !name.equals(DistributedDoubleBarrier.READY_NODE);
            }
        });
        ArrayList<String> filteredList = Lists.newArrayList(filtered);
        Collections.sort(filteredList);
        return filteredList;
    }

    private boolean internalLeave(long startMs, boolean hasMaxWait, long maxWaitMs) throws Exception {
        String ourPathName = ZKPaths.getNodeFromPath(this.ourPath);
        boolean ourNodeShouldExist = true;
        boolean result = true;
        while (true) {
            Stat stat;
            boolean IsLowestNode;
            List<String> children;
            if (this.connectionLost.get()) {
                throw new KeeperException.ConnectionLossException();
            }
            try {
                children = (List)this.client.getChildren().forPath(this.barrierPath);
            }
            catch (KeeperException.NoNodeException dummy) {
                children = Lists.newArrayList();
            }
            children = this.filterAndSortChildren(children);
            if (children == null || children.size() == 0) break;
            int ourIndex = children.indexOf(ourPathName);
            if (ourIndex < 0 && ourNodeShouldExist) {
                if (this.connectionLost.get()) break;
                throw new IllegalStateException(String.format("Our path (%s) is missing", ourPathName));
            }
            if (children.size() == 1) {
                if (ourNodeShouldExist && !children.get(0).equals(ourPathName)) {
                    throw new IllegalStateException(String.format("Last path (%s) is not ours (%s)", children.get(0), ourPathName));
                }
                this.checkDeleteOurPath(ourNodeShouldExist);
                break;
            }
            boolean bl = IsLowestNode = ourIndex == 0;
            if (IsLowestNode) {
                String highestNodePath = ZKPaths.makePath(this.barrierPath, children.get(children.size() - 1));
                stat = (Stat)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).forPath(highestNodePath);
            } else {
                String lowestNodePath = ZKPaths.makePath(this.barrierPath, children.get(0));
                stat = (Stat)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).forPath(lowestNodePath);
                this.checkDeleteOurPath(ourNodeShouldExist);
                ourNodeShouldExist = false;
            }
            if (stat == null) continue;
            if (hasMaxWait) {
                long elapsed = System.currentTimeMillis() - startMs;
                long thisWaitMs = maxWaitMs - elapsed;
                if (thisWaitMs <= 0L) {
                    result = false;
                    continue;
                }
                this.wait(thisWaitMs);
                continue;
            }
            this.wait();
        }
        try {
            this.client.delete().forPath(this.readyPath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        return result;
    }

    private void checkDeleteOurPath(boolean shouldExist) throws Exception {
        if (shouldExist) {
            this.client.delete().forPath(this.ourPath);
        }
    }

    private synchronized boolean internalEnter(long startMs, boolean hasMaxWait, long maxWaitMs) throws Exception {
        int count;
        boolean result = true;
        List<String> children = this.getChildrenForEntering();
        int n = count = children != null ? children.size() : 0;
        if (count >= this.memberQty) {
            try {
                this.client.create().forPath(this.readyPath);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        } else if (hasMaxWait && !this.hasBeenNotified.get()) {
            long elapsed = System.currentTimeMillis() - startMs;
            long thisWaitMs = maxWaitMs - elapsed;
            if (thisWaitMs <= 0L) {
                result = false;
            } else {
                this.wait(thisWaitMs);
            }
            if (!this.hasBeenNotified.get()) {
                result = false;
            }
        } else {
            this.wait();
        }
        return result;
    }

    private synchronized void notifyFromWatcher() {
        this.hasBeenNotified.set(true);
        this.notifyAll();
    }
}

