/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;

public class InterProcessSemaphoreMutex
implements InterProcessLock {
    private final InterProcessSemaphoreV2 semaphore;
    private final WatcherRemoveCuratorFramework watcherRemoveClient;
    private volatile Lease lease;

    public InterProcessSemaphoreMutex(CuratorFramework client, String path) {
        this.watcherRemoveClient = client.newWatcherRemoveCuratorFramework();
        this.semaphore = new InterProcessSemaphoreV2((CuratorFramework)this.watcherRemoveClient, path, 1);
    }

    @Override
    public void acquire() throws Exception {
        this.lease = this.semaphore.acquire();
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        Lease acquiredLease = this.semaphore.acquire(time, unit);
        if (acquiredLease == null) {
            return false;
        }
        this.lease = acquiredLease;
        return true;
    }

    @Override
    public void release() throws Exception {
        Preconditions.checkState(this.lease != null, "Not acquired");
        try {
            this.lease.close();
            this.watcherRemoveClient.removeWatchers();
        }
        finally {
            this.lease = null;
        }
    }

    @Override
    public boolean isAcquiredInThisProcess() {
        return this.lease != null;
    }
}

