/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.cli;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.Connect;
import org.apache.kafka.connect.runtime.ConnectorFactory;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.standalone.StandaloneConfig;
import org.apache.kafka.connect.runtime.standalone.StandaloneHerder;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class ConnectStandalone {
    private static final Logger log = LoggerFactory.getLogger(ConnectStandalone.class);

    public static void main(String[] args) throws Exception {
        String workerPropsFile;
        if (args.length < 2) {
            log.info("Usage: ConnectStandalone worker.properties connector1.properties [connector2.properties ...]");
            System.exit(1);
        }
        Map<String, String> workerProps = !(workerPropsFile = args[0]).isEmpty() ? Utils.propsToStringMap(Utils.loadProps(workerPropsFile)) : Collections.emptyMap();
        SystemTime time = new SystemTime();
        ConnectorFactory connectorFactory = new ConnectorFactory();
        StandaloneConfig config = new StandaloneConfig(workerProps);
        RestServer rest = new RestServer(config);
        URI advertisedUrl = rest.advertisedUrl();
        String workerId = advertisedUrl.getHost() + ":" + advertisedUrl.getPort();
        Worker worker = new Worker(workerId, time, connectorFactory, config, new FileOffsetBackingStore());
        StandaloneHerder herder = new StandaloneHerder(worker);
        Connect connect = new Connect(herder, rest);
        try {
            connect.start();
            for (final String connectorPropsFile : Arrays.copyOfRange(args, 1, args.length)) {
                Map<String, String> connectorProps = Utils.propsToStringMap(Utils.loadProps(connectorPropsFile));
                FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>(new Callback<Herder.Created<ConnectorInfo>>(){

                    @Override
                    public void onCompletion(Throwable error, Herder.Created<ConnectorInfo> info) {
                        if (error != null) {
                            log.error("Failed to create job for {}", (Object)connectorPropsFile);
                        } else {
                            log.info("Created connector {}", (Object)info.result().name());
                        }
                    }
                });
                herder.putConnectorConfig(connectorProps.get("name"), connectorProps, false, cb);
                cb.get();
            }
        }
        catch (Throwable t) {
            log.error("Stopping after connector error", t);
            connect.stop();
        }
        connect.awaitStop();
    }
}

