/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ConnectorFactory {
    public Connector newConnector(String connectorClassOrAlias) {
        return ConnectorFactory.instantiate(ConnectorFactory.getConnectorClass(connectorClassOrAlias));
    }

    public Task newTask(Class<? extends Task> taskClass) {
        return ConnectorFactory.instantiate(taskClass);
    }

    private static <T> T instantiate(Class<? extends T> cls) {
        try {
            return Utils.newInstance(cls);
        }
        catch (Throwable t) {
            throw new ConnectException("Instantiation error", t);
        }
    }

    private static Class<? extends Connector> getConnectorClass(String connectorClassOrAlias) {
        try {
            Class<?> clazz = Class.forName(connectorClassOrAlias);
            if (!Connector.class.isAssignableFrom(clazz)) {
                throw new ConnectException("Class " + connectorClassOrAlias + " does not implement Connector");
            }
            return clazz;
        }
        catch (ClassNotFoundException clazz) {
            Reflections reflections = new Reflections(new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()));
            Set<Class<? extends Connector>> connectors = reflections.getSubTypesOf(Connector.class);
            ArrayList<Class<? extends Connector>> results = new ArrayList<Class<? extends Connector>>();
            for (Class<Connector> clazz2 : connectors) {
                if (clazz2.getSimpleName().equals(connectorClassOrAlias)) {
                    results.add(clazz2);
                }
                if (!clazz2.getSimpleName().equals(connectorClassOrAlias + "Connector")) continue;
                results.add(clazz2);
            }
            if (results.isEmpty()) {
                throw new ConnectException("Failed to find any class that implements Connector and which name matches " + connectorClassOrAlias + ", available connectors are: " + ConnectorFactory.connectorNames(connectors));
            }
            if (results.size() > 1) {
                throw new ConnectException("More than one connector matches alias " + connectorClassOrAlias + ". Please use full package and class name instead. Classes found: " + ConnectorFactory.connectorNames(results));
            }
            return (Class)results.get(0);
        }
    }

    private static String connectorNames(Collection<Class<? extends Connector>> connectors) {
        StringBuilder names = new StringBuilder();
        for (Class<? extends Connector> c : connectors) {
            names.append(c.getName()).append(", ");
        }
        return names.substring(0, names.toString().length() - 2);
    }
}

