/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.IllegalWorkerStateException;
import org.apache.kafka.connect.sink.SinkTaskContext;

public class WorkerSinkTaskContext
implements SinkTaskContext {
    private Map<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
    private long timeoutMs = -1L;
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Set<TopicPartition> pausedPartitions;

    public WorkerSinkTaskContext(KafkaConsumer<byte[], byte[]> consumer) {
        this.consumer = consumer;
        this.pausedPartitions = new HashSet<TopicPartition>();
    }

    @Override
    public void offset(Map<TopicPartition, Long> offsets) {
        this.offsets.putAll(offsets);
    }

    @Override
    public void offset(TopicPartition tp, long offset) {
        this.offsets.put(tp, offset);
    }

    public void clearOffsets() {
        this.offsets.clear();
    }

    public Map<TopicPartition, Long> offsets() {
        return this.offsets;
    }

    @Override
    public void timeout(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public long timeout() {
        return this.timeoutMs;
    }

    @Override
    public Set<TopicPartition> assignment() {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to look up partition assignment until the task is initialized");
        }
        return this.consumer.assignment();
    }

    @Override
    public void pause(TopicPartition ... partitions) {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to pause consumption until the task is initialized");
        }
        try {
            for (TopicPartition partition : partitions) {
                this.pausedPartitions.add(partition);
            }
            this.consumer.pause(Arrays.asList(partitions));
        }
        catch (IllegalStateException e) {
            throw new IllegalWorkerStateException("SinkTasks may not pause partitions that are not currently assigned to them.", e);
        }
    }

    @Override
    public void resume(TopicPartition ... partitions) {
        if (this.consumer == null) {
            throw new IllegalWorkerStateException("SinkTaskContext may not be used to resume consumption until the task is initialized");
        }
        try {
            for (TopicPartition partition : partitions) {
                this.pausedPartitions.remove(partition);
            }
            this.consumer.resume(Arrays.asList(partitions));
        }
        catch (IllegalStateException e) {
            throw new IllegalWorkerStateException("SinkTasks may not resume partitions that are not currently assigned to them.", e);
        }
    }

    public Set<TopicPartition> pausedPartitions() {
        return this.pausedPartitions;
    }
}

