/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.errors;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.kafka.connect.errors.AlreadyExistsException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.rest.entities.ErrorMessage;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectExceptionMapper
implements ExceptionMapper<ConnectException> {
    private static final Logger log = LoggerFactory.getLogger(ConnectExceptionMapper.class);

    public Response toResponse(ConnectException exception) {
        log.debug("Uncaught exception in REST call: ", exception);
        if (exception instanceof ConnectRestException) {
            ConnectRestException restException = (ConnectRestException)exception;
            return Response.status((int)restException.statusCode()).entity((Object)new ErrorMessage(restException.errorCode(), restException.getMessage())).build();
        }
        if (exception instanceof NotFoundException) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Response.Status.NOT_FOUND.getStatusCode(), exception.getMessage())).build();
        }
        if (exception instanceof AlreadyExistsException) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ErrorMessage(Response.Status.CONFLICT.getStatusCode(), exception.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorMessage(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), exception.getMessage())).build();
    }
}

